/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.MonitoredClasses;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.MonitoredClasses.PlaceHolder;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAMQUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAQueueManagerUtils;
import java.lang.reflect.Field;

public class CAMQQueueSession
extends PlaceHolder {
    private static Field fMQSession_messageListener = null;
    private static Field fMDBWrapper_jmsDest = null;
    private static Field fJMS_MQQueue_baseQueueName = null;

    @Override
    public String getHostName(InvocationData invocationdata) {
        Object mqObject = invocationdata.getInvocationObject();
        Class<?> mqSessionClass = mqObject.getClass();
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQQueueSession:getHostName:mqSessionClass: " + mqSessionClass.getName());
        try {
            this.hostname = CAMQUtils.getMQSessionHostName(mqObject);
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "CAMQQueueSession:getHostName:Exception: " + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQQueueSession:getHostName:Host Name: " + this.hostname);
        return this.hostname;
    }

    @Override
    public String getQueueManagerName(InvocationData invocationdata) {
        Object mqObject = invocationdata.getInvocationObject();
        Class<?> mqSessionClass = mqObject.getClass();
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQQueueSession:getQueueManagerName:mqSessionClass: " + mqSessionClass.getName());
        try {
            this.qmname = CAMQUtils.getMQSessionQueueManagerName(mqObject);
            if (this.qmname == null || this.qmname.trim().length() == 0) {
                Object mqQueueManagerObject = CAMQUtils.getMQSessionQueueManager(mqObject);
                this.qmname = CAQueueManagerUtils.getQMName(mqQueueManagerObject);
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "CAMQQueueSession:getQueueManagerName:Exception: " + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQQueueSession:getQueueManagerName:Queue Manager Name: " + this.qmname);
        return this.qmname;
    }

    @Override
    public String getQueueName(InvocationData invocationdata) {
        Object mqObject = invocationdata.getInvocationObject();
        Class<?> mqSessionClass = mqObject.getClass();
        String mqSessionClassName = mqSessionClass.getName();
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQQueueSession:getQueueName:mqSessionClass: " + mqSessionClassName);
        if (mqSessionClassName.equals("com.ibm.mq.jms.MQXASession") || mqSessionClassName.equals("com.ibm.mq.jms.MQQueueSession") || mqSessionClassName.equals("com.ibm.mq.jms.MQTopicSession")) {
            mqSessionClass = mqSessionClass.getSuperclass();
        } else if (mqSessionClassName.equals("com.ibm.mq.jms.MQXAQueueSession") || mqSessionClassName.equals("com.ibm.mq.jms.MQXATopicSession")) {
            mqSessionClass = mqSessionClass.getSuperclass().getSuperclass();
        }
        try {
            Object mdbWrapperObject;
            if (fMQSession_messageListener == null) {
                fMQSession_messageListener = mqSessionClass.getDeclaredField("messageListener");
                fMQSession_messageListener.setAccessible(true);
            }
            if ((mdbWrapperObject = fMQSession_messageListener.get(mqObject)) != null) {
                Object jmsDestination;
                if (fMDBWrapper_jmsDest == null) {
                    fMDBWrapper_jmsDest = mdbWrapperObject.getClass().getDeclaredField("jmsDest");
                    fMDBWrapper_jmsDest.setAccessible(true);
                }
                if ((jmsDestination = fMDBWrapper_jmsDest.get(mdbWrapperObject)) != null) {
                    if (fJMS_MQQueue_baseQueueName == null) {
                        Class<?> jmsDestinationClass = jmsDestination.getClass();
                        if (jmsDestinationClass.getName().equals("com.ibm.mq.jms.MQTemporaryQueue")) {
                            jmsDestinationClass = jmsDestinationClass.getSuperclass();
                        }
                        fJMS_MQQueue_baseQueueName = jmsDestinationClass.getDeclaredField("baseQueueName");
                        fJMS_MQQueue_baseQueueName.setAccessible(true);
                    }
                    this.queuename = ((String)fJMS_MQQueue_baseQueueName.get(jmsDestination)).trim();
                }
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "CAMQQueueSession:getQueueName:Exception: " + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQQueueSession:getQueueName:Queue Name: " + this.queuename);
        return this.queuename;
    }
}

