/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery;

import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QueueManagerRepository;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QueueRepository;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QueueVO;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery.QueuePacket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class QueueRepositoryReader {
    private static List queuePacketsList = new ArrayList();
    private static Map<QueuePacket, Long> queuePackets = new ConcurrentHashMap<QueuePacket, Long>();
    private static long timestamp = 0L;

    private QueueRepositoryReader() {
    }

    public static synchronized Map getQueuePackets() {
        QueueRepositoryReader.getQueueVO(QueueRepository.getQueuevosList());
        QueueRepositoryReader.getQueueVO(QueueManagerRepository.getQueuevosList());
        return queuePackets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getQueueVO() {
        List list = QueueRepository.getQueuevosList();
        synchronized (list) {
            Iterator queueVOIterator = QueueRepository.getQueuevosList().iterator();
            while (queueVOIterator.hasNext()) {
                QueueVO queueVO = (QueueVO)queueVOIterator.next();
                queueVOIterator.remove();
                if (queueVO == null) continue;
                QueueRepositoryReader.createQueuePacket(queueVO);
            }
        }
    }

    private static void getQueueVO(List queueVOs) {
        for (QueueVO queueVO : queueVOs) {
            queueVOs.remove(queueVO);
            if (queueVO == null) continue;
            QueueRepositoryReader.createQueuePacket(queueVO);
        }
    }

    private static void createQueuePacket(QueueVO queueVO) {
        QueuePacket queuePacket = null;
        String hostName = queueVO.getHostName();
        int port = queueVO.getPort();
        String channelName = queueVO.getChannelName();
        String queueManagerName = queueVO.getQmName();
        int ccsid = queueVO.getCCSID();
        int queueType = queueVO.getQueueType();
        boolean qmgrAvailable = false;
        if (hostName != null && queueManagerName != null) {
            queuePacket = new QueuePacket(hostName, port, channelName, queueManagerName, queueVO.getQueueName());
        }
        if (ccsid != -1) {
            queuePacket.setCcsid(ccsid);
        }
        if (queueType != -1) {
            queuePacket.setQueueType(queueType);
        }
        if (queuePacket != null && !queuePackets.containsKey(queuePacket)) {
            if (queueType == 1) {
                for (QueuePacket qPackect : queuePackets.keySet()) {
                    if (!qPackect.getHostName().equals(hostName) || !queueManagerName.equals(qPackect.getQMName()) || qPackect.getPort() != port) continue;
                    qmgrAvailable = true;
                    queuePacket = null;
                    break;
                }
            }
            if (!qmgrAvailable) {
                queuePackets.put(queuePacket, new Long(timestamp));
            }
        }
    }
}

