/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.appmap.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.activation.IOSGiPlugin;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.servlet.IServletRequestHelper;
import com.wily.introscope.agent.trace.servlet.ServletHelperFactory;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;

public class AppMapApplicationNameFormatter
implements INameFormatter,
IOSGiPlugin {
    private static final String kName = "hc2.AppMapApplicationNameFormatter";
    private static final Module kModule = new Module("hc2.AppMapApplicationNameFormatter");
    private IAgent fAgent;
    IModuleFeedbackChannel fFeedback;

    public AppMapApplicationNameFormatter() {
    }

    public AppMapApplicationNameFormatter(IAgent agent) {
        this.fAgent = agent;
        this.fFeedback = this.getModuleFeedback();
    }

    public String INameFormatter_format(String name, InvocationData data) {
        return AppMapApplicationNameFormatter.quickGetComponentName(this.fAgent, this.getModuleFeedback(), data);
    }

    public static final String quickGetComponentName(IAgent agent, IModuleFeedbackChannel feedback, InvocationData data) {
        try {
            if (data.hasServletSupport()) {
                return (String)data.getServletSupport().servletParametersMap.get((Object)"Application Name");
            }
            if (data.hasInvocationParametersAvailable() && data.getInvocationParameterCount() > 0) {
                Object request = data.getInvocationParameterAsObject(0);
                Object servlet = data.getInvocationObject();
                IServletRequestHelper helper = ServletHelperFactory.getServletHelper((Object)request, (ClassLoader)request.getClass().getClassLoader(), (IModuleFeedbackChannel)agent.IAgent_getModuleFeedback());
                return AppMapApplicationNameFormatter.getServletContextName(helper, request, servlet);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                feedback.verbose(t);
                feedback.error(kModule, "An error occurred getting the application name: " + t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return "UnknownApp";
    }

    private static String getServletContextName(IServletRequestHelper helper, Object request, Object servlet) {
        String result = helper.getApplicationName(request, servlet);
        if (result != null && result.equals("")) {
            result = "rootContext";
        }
        return result;
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.fAgent.IAgent_getModuleFeedback();
    }

    public Class getPluginClass() {
        return AppMapApplicationNameFormatter.class;
    }

    public String getName() {
        return this.getPluginClass().getName();
    }
}

