/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.classfile.java;

import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.ISlotSignature;
import com.wily.util.classfile.InvalidFieldDescriptorException;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.java.ClassFileFieldDescriptor;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ClassFileMethodDescriptor
implements IMethodSignature {
    private static final String kInitialTypeList = "(";
    private String fMethodDescriptor;
    private ClassFileFieldDescriptor[] fArguments;
    private ClassFileFieldDescriptor fReturnValue;

    public ClassFileMethodDescriptor() {
        this.fArguments = null;
        this.fReturnValue = ClassFileFieldDescriptor.getVoidDescriptor();
    }

    public ClassFileMethodDescriptor(String methodDescriptor) throws InvalidMethodDescriptorException {
        this.setMethodDescriptor(methodDescriptor);
    }

    protected void setMethodDescriptor(String methodDescriptor) throws InvalidMethodDescriptorException {
        this.fMethodDescriptor = methodDescriptor;
        this.parseDescriptor();
    }

    private void parseDescriptor() throws InvalidMethodDescriptorException {
        ArrayList<ClassFileFieldDescriptor> argList = new ArrayList<ClassFileFieldDescriptor>();
        this.fReturnValue = null;
        if (this.fMethodDescriptor == null) {
            throw new InvalidMethodDescriptorException(new SimpleLocalizableMessage("Class_File_Method_Descriptor_Empty"), "");
        }
        StringTokenizer tokenizer = new StringTokenizer(this.fMethodDescriptor, kInitialTypeList, true);
        if (!tokenizer.hasMoreTokens()) {
            throw new InvalidMethodDescriptorException(new SimpleLocalizableMessage("Class_File_Method_Descriptor_Empty"), this.fMethodDescriptor);
        }
        if (!tokenizer.nextToken().equals(kInitialTypeList)) {
            throw new InvalidMethodDescriptorException(new FormattedLocalizableMessage("Class_File_Method_Descriptor_Missing_Start_Parameter_List", this.fMethodDescriptor), this.fMethodDescriptor);
        }
        try {
            try {
                ClassFileFieldDescriptor field;
                while ((field = new ClassFileFieldDescriptor(tokenizer)).isValid()) {
                    argList.add(field);
                }
                if (argList.size() > 0) {
                    this.fArguments = argList.toArray(new ClassFileFieldDescriptor[argList.size()]);
                }
            }
            catch (InvalidFieldDescriptorException invalidFieldDescriptorException) {
                throw new InvalidMethodDescriptorException(new FormattedLocalizableMessage("Class_File_Method_Descriptor_Invalid_Parameter", this.fMethodDescriptor), this.fMethodDescriptor);
            }
            this.fReturnValue = new ClassFileFieldDescriptor(tokenizer, true);
            if (!this.fReturnValue.isValid()) {
                throw new InvalidMethodDescriptorException(new FormattedLocalizableMessage("Class_File_Method_Descriptor_Missing_Return_Type", this.fMethodDescriptor), this.fMethodDescriptor);
            }
        }
        catch (InvalidFieldDescriptorException invalidFieldDescriptorException) {
            throw new InvalidMethodDescriptorException(new FormattedLocalizableMessage("Class_File_Method_Descriptor_Invalid_Return_Type", this.fMethodDescriptor), this.fMethodDescriptor);
        }
    }

    public int getArgumentCount() {
        if (this.fArguments == null) {
            return 0;
        }
        return this.fArguments.length;
    }

    public ClassFileFieldDescriptor getArgumentAt(int index) {
        return this.fArguments[index];
    }

    public ClassFileFieldDescriptor getReturnType() {
        return this.fReturnValue;
    }

    @Override
    public int getParameterCount() {
        return this.getArgumentCount();
    }

    @Override
    public ISlotSignature getParameterSignatureByIndex(int index) {
        return this.getArgumentAt(index);
    }

    @Override
    public ISlotSignature getReturnSlotSignature() {
        return this.getReturnType();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassFileMethodDescriptor) {
            ClassFileMethodDescriptor desc = (ClassFileMethodDescriptor)obj;
            if (this.getArgumentCount() != desc.getArgumentCount()) {
                return false;
            }
            int i = 0;
            while (i < this.getArgumentCount()) {
                if (!this.getArgumentAt(i).equals(desc.getArgumentAt(i))) {
                    return false;
                }
                ++i;
            }
            return this.getReturnType().equals(desc.getReturnType());
        }
        return false;
    }

    public int hashCode() {
        return this.fMethodDescriptor.hashCode();
    }

    public String toString() {
        return this.fMethodDescriptor;
    }

    @Override
    public String getSignatureString() {
        int argumentCount = this.getArgumentCount();
        StringBuffer formatted = new StringBuffer(argumentCount * 30);
        formatted.append(kInitialTypeList);
        int i = 0;
        while (i < argumentCount) {
            ClassFileFieldDescriptor field = this.getArgumentAt(i);
            formatted.append(field.getSignatureString());
            if (i + 1 < argumentCount) {
                formatted.append(", ");
            }
            ++i;
        }
        formatted.append(")");
        return formatted.toString();
    }
}

