/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.MonitoredClasses.MonitoredClassFactory;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAMQUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAQueueUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.MQClassLoaderUtil;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.MQTransactionTracerConstants;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.MQTransactionTracerUtil;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery.MQDiscoveryDataProcessor;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.Reflection;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class JMSReceiveTransactionTracer
extends ASingleMetricTracerFactory
implements MQTransactionTracerConstants {
    private IModuleFeedbackChannel fLogger = MQPPLog.getLogger();
    public static final Module kModule = new Module("JMSReceiveTransactionTracer");

    static {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        MQClassLoaderUtil.initialize(classloader);
        Reflection.initialise(classloader);
        if (TraceProperties.shouldStartDiscovery()) {
            MQDiscoveryDataProcessor.getInstance();
        }
    }

    public JMSReceiveTransactionTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fLogger.debug(kModule, "Inside JMSReceiveTransactionTracer consutructor");
    }

    protected IDataAccumulator createDataAccumulator(String arg0) {
        return null;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        this.fLogger.debug(kModule, "Inside ITracer_startTrace");
    }

    public void ITracer_finishTrace(int arg0, InvocationData data) {
        this.fLogger.debug(kModule, "Inside ITracer_finishTrace");
        try {
            boolean traceOn = this.getAgent().IAgent_getComponentTracer().shouldCurrentTraceBePropagated();
            this.fLogger.debug(kModule, "traceOn..:" + traceOn);
            Object jmsMessageObject = data.getInvocationReturnValueAsObject();
            boolean isListener = false;
            if (jmsMessageObject == null && data.getProbeInformation().getProbeIdentification().getProbeMethodName().equals("onMessage")) {
                jmsMessageObject = data.getInvocationParameterAsObject(0);
                isListener = true;
            }
            if (jmsMessageObject != null) {
                int feedback;
                if (TraceProperties.shouldTraceMQSYSVIEW() && ((feedback = MQTransactionTracerUtil.getJMSMessageIntProperty(jmsMessageObject, "JMS_IBM_MQMD_Feedback")) == 99990001 || feedback == 99990000)) {
                    MQTransactionTracerUtil.setJMSMessageIntProperty(jmsMessageObject, "JMS_IBM_MQMD_Feedback", 0);
                }
                if (traceOn && MonitoredClassFactory.mqV7AppearsToBePresent()) {
                    Object jmsObject = data.getInvocationObject();
                    Object jmsDestinationObject = MQTransactionTracerUtil.getJMSDestinationObject(jmsObject);
                    if (isListener) {
                        jmsObject = MQTransactionTracerUtil.getJMSListenerParent(jmsObject);
                    }
                    String queueName = null;
                    String queueManagerName = null;
                    if (jmsDestinationObject != null) {
                        queueName = MQTransactionTracerUtil.getJMSDestinationName(jmsDestinationObject);
                        queueManagerName = CAMQUtils.getJMSObjectProperty(jmsObject, "XMSC_WMQ_QUEUE_MANAGER");
                    } else if (jmsObject != null) {
                        queueName = CAQueueUtils.getActivationSpecDestinationName(jmsObject);
                        queueManagerName = CAMQUtils.getJMSObjectProperty(jmsObject, "XMSC_WMQ_QUEUE_MANAGER");
                    } else {
                        Object sessionObject = CAMQUtils.getMessageSessionObject(jmsMessageObject);
                        if (sessionObject != null) {
                            queueManagerName = CAMQUtils.getJMSObjectProperty(sessionObject, "XMSC_WMQ_QUEUE_MANAGER");
                            if (queueManagerName == null || queueManagerName.equals("")) {
                                MQPPLog.getLogger().debug(kModule, "JMSReceiveTransactionTracerUnknown Queue Manager");
                            }
                            if ((queueName = CAQueueUtils.getListenerDestinationName(sessionObject)) == null || queueName.equals("")) {
                                MQPPLog.getLogger().debug(kModule, "JMSReceiveTransactionTracerUnknown Queue");
                            }
                        }
                    }
                    if (queueName != null && queueName.trim().length() != 0 && !MQTransactionTracerUtil.shouldExcludeQueue(queueManagerName, queueName)) {
                        String messageID = MQTransactionTracerUtil.getJMSMessageID(jmsMessageObject);
                        String correlationID = MQTransactionTracerUtil.getJMSCorrelationID(jmsMessageObject);
                        MQTransactionTracerUtil.addToCorrelation(this.getAgent(), messageID, correlationID);
                    }
                }
            }
        }
        catch (Exception e) {
            this.fLogger.debug(kModule, e.getMessage(), (Throwable)e);
        }
    }
}

