/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake;

import com.wily.powerpack.websphereMQ.agent.extensions.metrics.ActivityReportMetric;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeConstants;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeReader;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeWriter;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.MQMonitorAgentsMonitor;
import com.wily.util.feedback.IModuleFeedbackChannel;

public final class HandshakeManager
implements HandshakeConstants {
    private IModuleFeedbackChannel logger = null;
    private String agentName = null;
    private HandshakeReader reader = null;
    private HandshakeWriter writer = null;
    private ActivityReportMetric arMetric = ActivityReportMetric.getInstance();
    private static HandshakeManager hm = null;

    private HandshakeManager() {
        this.logger = MQPPLog.getLogger();
        this.logger.debug(handshakeModule, "Inside HandshakeManager constructor");
        this.agentName = TraceProperties.HANDSHAKE_MQAGENT_ID_MORPHED_VALUE;
        this.writer = HandshakeWriter.getInstance(this.agentName, "MQAgentsHandshakeWriterThread", this.logger);
        this.reader = new HandshakeReader(this.agentName, "MQAgentsHandshakeReaderThread", this.logger);
    }

    public static synchronized HandshakeManager getInstance() {
        if (hm == null) {
            hm = new HandshakeManager();
            new Thread(){

                @Override
                public void run() {
                    hm.execute();
                }
            }.start();
        }
        return hm;
    }

    private void execute() {
        if (TraceProperties.isValidMQAgentId) {
            this.logger.info(handshakeModule, "Agent name is : " + this.agentName);
            this.writer.start();
            this.reader.start();
        } else if (!MQMonitorAgentsMonitor.getInstance(this.logger).isAllMQMonitored()) {
            this.arMetric.setMetric(1, ActivityReportMetric.VALUE_STATUS_MESSAGE_MQAGENTID_NOT_SET);
            this.logger.warn(handshakeModule, "********************************************* handshake.mqagent.id value is not provided. This is mandatory property for MQ trace  for conditional MQ trace. Not connecting to handshake queue. the ALLMQMONITOR flag will remain FALSE. To use this, provide the valid value and restart this Agent. *********************************************");
            this.logger.info(handshakeModule, "The ALLMQMONITOR flag will remain FALSE.");
        }
    }

    public static void main(String[] args) {
        try {
            Thread.sleep(6000000L);
        }
        catch (InterruptedException interruptedException) {}
    }
}

