/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ctg.server;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.BlamePointTracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import com.wily.zos.tools.DebugController;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class ServerECIRequestTracer
extends BlamePointTracer {
    private static final String CLASS_NAME = "ServerECIRequestTracer";
    private static final int UNINITIALIZED_START_TIME = -1;
    private static Class classOfEciRequest = null;
    private String gatewayName;
    private String programName;
    private String err_detect_errMessage;
    private int reported_error_count;
    private int cics_RetCode;
    private final DebugController debugger;
    private static final String GLOBAL_STATS_NODE = "Backends|CTG_Global_Statistics";
    private static final String INDIVIDUAL_SERVERS_NODE = "Backends|CTG_Global_Statistics|Individual_Servers";
    private static final String GATEWAY_DAEMON_NODE = "Backends|CTG_Global_Statistics|Gateway Daemon";
    private static final String ECI_IPIC_NODE = "Backends|CTG_to_CICS_ECI_IPIC";
    public static final String kAggregate_CommArea_Request_Suffix = ":CommArea Aggregate Request Data";
    public static final String kAggregate_CommArea_Reply_Suffix = ":CommArea Aggregate Reply Data";
    public static final String kError_This_Program_Count_Suffix = ":Aggregate Errors";
    public static final String kAggregate_This_Program_ECI_Count_Suffix = ":Aggregate Program Count ECI";
    public static final String kAggregate_This_Program_IPIC_Count_Suffix = ":Aggregate Program Count IPIC";
    public static final String kAggregate_All_Programs_ECI_Count_Suffix = ":Program Aggregate Count ECI";
    public static final String kAggregate_All_Programs_IPIC_Count_Suffix = ":Program Aggregate Count IPIC";
    public static final String kAggregate_All_Programs_RspTime_Suffix = ":Program Average Response Time (ms)";
    public static final String kAggregate_All_Programs_Error_Count_Suffix = ":Program Aggregate Errors";
    public static final String kAggregate_All_Programs_Reqs_per_Interval_Suffix = ":Program Invocations Per Interval";
    public static final String kDetail_Program_RspTime_Suffix = ":Average Response Time (ms)";
    public static final String kDetail_Program_Concur_Invokes_Suffix = ":Concurrent Invocations";
    public static final String kDetail_Program_Error_Interval_Suffix = ":Errors Per Interval";
    public static final String kDetail_Program_Reqs_per_Interval_Suffix = ":Responses Per Interval";
    public static final String kDetail_Program_Stall_Count_Suffix = ":Stall Count";
    public static final int kError_ERR_NO_CICS = -3;
    public static final int kError_ERR_CICS_DIED = -4;
    public static final int kError_ERR_REQUEST_TIMEOUT = -5;
    public static final int kError_ERR_RESPONSE_TIMEOUT = -6;
    public static final int kError_ERR_TRANSACTION_ABEND = -7;
    public static final int kError_ERR_RESOURCE_SHORTAGE = -16;
    public static final int kError_ERR_NO_SESSIONS = -17;
    public static final int kError_ERR_UNKNOWN_SERVER = -22;
    public static final String kError_NO_CICS = ":Unable To Connect To CICS Errors ERR_NO_CICS";
    public static final String kError_CICS_DIED = ":CICS Terminated Errors ERR_CICS_DIED";
    public static final String kError_REQUEST_TIMEOUT = ":Request Timeout Errors ERR_REQUEST_TIMEOUT";
    public static final String kError_RESPONSE_TIMEOUT = ":Response Timeout Errors ERR_RESPONSE_TIMEOUT";
    public static final String kError_TRANSACTION_ABEND = ":Transaction Abend Errors ERR_TRANSACTION_ABEND";
    public static final String kError_RESOURCE_SHORTAGE = ":Resource Shortage Errors ERR_RESOURCE_SHORTAGE";
    public static final String kError_NO_SESSIONS = ":No Sessions Available Errors ERR_NO_SESSIONS";
    public static final String kError_UNKNOWN_SERVER = ":Unrecognized CICS Server Name Errors ERR_UNKNOWN_SERVER";
    public static final String kBackend_Release_Num_Wily = "10.7.0.359";
    public static final String kBackend_Build_Num_Wily = "998500";
    public static final String kAgent_Stats_ECI_Build = "Agent Stats:CTG PP Build and Release";
    public static final Long kFlag_Type_ON = new Long(1L);
    public static final String kComponentName_Key = "CTG_CompontName";
    public static final String kGlobalsName_Key = "CTG_GlobalsName";
    public static final String kProgramField = "Program";
    public static final String kServerField = "Server";
    private static ThreadLocal<Object> tls_Sent_Build_Version = new ThreadLocal<Object>(){

        @Override
        protected synchronized Object initialValue() {
            return new Long(0L);
        }
    };
    public static ThreadLocal<Object> eci_Server_Name = new ThreadLocal<Object>(){

        @Override
        protected synchronized Object initialValue() {
            return null;
        }
    };
    private static ThreadLocal<Boolean> ipicCallStatus = new ThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return false;
        }
    };

    public ServerECIRequestTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.debugger = new DebugController(agent);
        this.printDebugMessage("In constructor");
        agent.IAgent_getDataAccumulatorFactory();
        this.programName = null;
        this.gatewayName = null;
        this.reported_error_count = 0;
        this.cics_RetCode = 0;
        this.err_detect_errMessage = null;
        try {
            Long flag_valLONG = ServerECIRequestTracer.get_BuildVersion_Sent_Flag();
            long flag_val = flag_valLONG;
            if (flag_val == 0L) {
                String formattedMetricName = kAgent_Stats_ECI_Build;
                this.getDataAccumulatorFactory().safeGetStringConstantDataAccumulator(formattedMetricName, "10.7.0.359 (Build 998500)");
                ServerECIRequestTracer.set_BuildVersion_Sent_Flag(kFlag_Type_ON);
            }
        }
        catch (Exception ex) {
            this.printDebugMessage("Constructor exception", ex);
        }
    }

    protected final IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetLongAverageDataAccumulator(formattedMetricName);
    }

    private String extract_Server_Name_From_Rcvd_ClientRequest(Class classOfEciRequest, Object invokeObject) {
        Field serverField;
        String gatewayName;
        block8: {
            gatewayName = null;
            serverField = classOfEciRequest.getDeclaredField(kServerField);
            if (serverField != null) break block8;
            this.printDebugMessage(" ---WILY--- SrvECI_extractServerNameFromRcvdClientRequest() - got Server Field equals to null");
            return null;
        }
        try {
            gatewayName = (String)serverField.get(invokeObject);
            if (gatewayName == null) {
                this.printDebugMessage(" ---WILY--- SrvECI_extractServerNameFromRcvdClientRequest() - DID NOT find Server Name in \"Server\" field");
                gatewayName = null;
            }
            this.printDebugMessage(" ---WILY--- SrvECI_extractServerNameFromCommArea() - Found Server=" + gatewayName);
        }
        catch (Exception ex) {
            this.printDebugMessage(" ---WILY--- SrvECI_extractServerNameFromRcvdClientRequest - failed to extract server names from CommArea " + ex);
        }
        int url_Index = gatewayName.indexOf(":");
        if (url_Index > 0 && gatewayName.charAt(url_Index + 1) == '/') {
            int url_End = gatewayName.length();
            int port_Index = gatewayName.indexOf(":", url_Index + 1);
            if (port_Index > 0 && port_Index < url_End) {
                url_End = port_Index;
            }
            if (url_End > 0) {
                String portnum_str = gatewayName.substring(port_Index + 1, gatewayName.length());
                gatewayName = gatewayName.substring(url_Index + 3, url_End);
                gatewayName = String.valueOf(gatewayName) + "__" + portnum_str;
            } else {
                gatewayName = gatewayName.substring(url_Index + 3);
            }
        }
        return gatewayName;
    }

    private String extract_Program_Name_From_Rcvd_ClientRequest(Class classOfEciRequest, Object invokeObject) {
        Field progField;
        String programName;
        block4: {
            programName = null;
            progField = classOfEciRequest.getDeclaredField(kProgramField);
            if (progField != null) break block4;
            this.printDebugMessage(" ---WILY--- SrvECI_extractProgramNameFromRcvdClientRequest() - got Program Field equals to null");
            return null;
        }
        try {
            programName = (String)progField.get(invokeObject);
            if (programName == null) {
                this.printDebugMessage(" ---WILY--- SrvECI_extractProgramNameFromRcvdClientRequest() - DID NOT find Program Name in \"Program\" field");
                programName = null;
            }
        }
        catch (Exception ex) {
            this.getModuleFeedback().error(" ---WILY--- SrvECI_extractProgramNameFromRcvdClientRequest - failed to extract program names from CommArea " + ex);
        }
        return programName;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        Object invokeObject;
        switch (CallType.fromData(data)) {
            case ECI_OR_IPIC: {
                break;
            }
            case IPIC_ONLY: {
                ServerECIRequestTracer.rememberInnerIpicCall();
                break;
            }
            default: {
                return;
            }
        }
        try {
            invokeObject = data.getInvocationObject();
            if (invokeObject == null) {
                this.printDebugMessage(" ---WILY--- SrvECI_startTrace - got Invocation Object as NULL ");
                return;
            }
            if (classOfEciRequest == null) {
                Class<?> invoke_Class = invokeObject.getClass();
                if (invoke_Class == null) {
                    this.printDebugMessage(" ---WILY--- SrvECI_startTrace - got invokeObject.getClass() == null");
                    return;
                }
                classOfEciRequest = invoke_Class.getSuperclass();
                if (classOfEciRequest == null) {
                    this.printDebugMessage(" ---WILY--- SrvECI_startTrace - got invokeObject.getSuperclass() == null");
                    return;
                }
            }
        }
        catch (Exception ex) {
            this.printDebugMessage("  ---WILY--- startTrace exception1", ex);
            ex.printStackTrace();
            return;
        }
        try {
            String stack_gateway_name = this.extract_Server_Name_From_Rcvd_ClientRequest(classOfEciRequest, invokeObject);
            String stack_program_name = this.extract_Program_Name_From_Rcvd_ClientRequest(classOfEciRequest, invokeObject);
            if (stack_gateway_name == null || stack_program_name == null) {
                return;
            }
            ServerECIRequestTracer.set_eci_Server_Name(stack_gateway_name);
            String stack_eci_GlobalsName = "Backends|CTG_Global_Statistics|Individual_Servers|" + stack_gateway_name;
            String stack_eci_ComponentName = "Backends|CTG_to_CICS_ECI_IPIC|" + stack_gateway_name + "|" + stack_program_name;
            data.setComponentNameAt(stack_eci_ComponentName, tracerIndex);
            data.put(kComponentName_Key, (Object)stack_eci_ComponentName);
            data.put(kGlobalsName_Key, (Object)stack_eci_GlobalsName);
        }
        catch (Exception ex) {
            this.printDebugMessage("  ---WILY--- startTrace exception2", ex);
            ex.printStackTrace();
            return;
        }
        data.storeWallClockStartTime();
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String formattedMetricName;
        boolean error_reported = false;
        Object invokeObject = data.getInvocationObject();
        if (invokeObject == null) {
            Assertion.wilyAssert((String)"    ---WILY--- finishTrace_ServerECI unable to obtain InvocationObject");
            return;
        }
        if (!this.startTraceCompletedFor(data)) {
            return;
        }
        CallType callType = CallType.fromData(data);
        if (callType == CallType.ECI_OR_IPIC && ServerECIRequestTracer.innerIpicCallWasMade()) {
            ServerECIRequestTracer.forgetInnerIpicCall();
            return;
        }
        String stack_eci_ComponentName = (String)data.get(kComponentName_Key);
        String stack_eci_GlobalsName = (String)data.get(kGlobalsName_Key);
        boolean skip_global_stats = false;
        if (stack_eci_ComponentName == null) {
            return;
        }
        this.cics_RetCode = 0;
        long commareaRequestLength = 0L;
        long commareaReplyLength = 0L;
        IIntegerFluctuatingCounterDataAccumulator ciCounter = null;
        if (stack_eci_ComponentName.endsWith(":execute")) {
            ciCounter = data.getCounterAt(tracerIndex);
            if (ciCounter != null) {
                ciCounter.IIntegerFluctuatingCounterDataAccumulator_decrement();
            }
            return;
        }
        try {
            Class<?> invoke_Class = invokeObject.getClass();
            if (invoke_Class == null) {
                return;
            }
            Class<?> eci_SuperClass = invoke_Class.getSuperclass();
            if (eci_SuperClass == null) {
                return;
            }
            Field field1 = eci_SuperClass.getDeclaredField("Cics_Rc");
            if (field1 == null) {
                return;
            }
            Integer retCode = (Integer)field1.get(invokeObject);
            if (retCode == null) {
                return;
            }
            this.cics_RetCode = retCode;
            Method field1_method = eci_SuperClass.getDeclaredMethod("getCommareaOutboundLength", null);
            if (field1_method == null) {
                return;
            }
            Integer comm_Lng = (Integer)field1_method.invoke(invokeObject, null);
            if (comm_Lng != null) {
                commareaRequestLength = comm_Lng.intValue();
            }
            if ((field1_method = eci_SuperClass.getDeclaredMethod("getCommareaInboundLength", null)) == null) {
                return;
            }
            comm_Lng = (Integer)field1_method.invoke(invokeObject, null);
            if (comm_Lng != null) {
                commareaReplyLength = comm_Lng.intValue();
            }
            if (this.cics_RetCode < 0) {
                String cicsRcString = this.stringFromSuperclassMethod(invokeObject, "getCicsRcString");
                if (cicsRcString == null) {
                    return;
                }
                this.err_detect_errMessage = "Program invoke error: " + this.cics_RetCode + "  " + cicsRcString + "  Program=" + this.programName + "  Gateway=" + this.gatewayName;
                String cfr_ignored_0 = String.valueOf(this.getFormattedResource()) + ": " + this.err_detect_errMessage;
                if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)this.err_detect_errMessage)) {
                    String errorMetricName = String.valueOf(stack_eci_ComponentName) + kDetail_Program_Error_Interval_Suffix;
                    this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                    this.addRequestPerInterval(errorMetricName);
                    error_reported = true;
                }
                formattedMetricName = this.cics_RetCode == -3 ? "Backends|CTG_Global_Statistics|Gateway Daemon:Unable To Connect To CICS Errors ERR_NO_CICS" : (this.cics_RetCode == -4 ? "Backends|CTG_Global_Statistics|Gateway Daemon:CICS Terminated Errors ERR_CICS_DIED" : (this.cics_RetCode == -5 ? "Backends|CTG_Global_Statistics|Gateway Daemon:Request Timeout Errors ERR_REQUEST_TIMEOUT" : (this.cics_RetCode == -6 ? "Backends|CTG_Global_Statistics|Gateway Daemon:Response Timeout Errors ERR_RESPONSE_TIMEOUT" : (this.cics_RetCode == -7 ? "Backends|CTG_Global_Statistics|Gateway Daemon:Transaction Abend Errors ERR_TRANSACTION_ABEND" : (this.cics_RetCode == -16 ? "Backends|CTG_Global_Statistics|Gateway Daemon:Resource Shortage Errors ERR_RESOURCE_SHORTAGE" : (this.cics_RetCode == -17 ? "Backends|CTG_Global_Statistics|Gateway Daemon:No Sessions Available Errors ERR_NO_SESSIONS" : (this.cics_RetCode == -22 ? "Backends|CTG_Global_Statistics|Gateway Daemon:Unrecognized CICS Server Name Errors ERR_UNKNOWN_SERVER" : "Backends|CTG_Global_Statistics|Gateway Daemon:CICS Errors " + cicsRcString)))))));
                this.increment(formattedMetricName);
                formattedMetricName = String.valueOf(stack_eci_ComponentName) + kError_This_Program_Count_Suffix + " " + cicsRcString;
                this.increment(formattedMetricName);
            }
        }
        catch (Exception ex) {
            this.printDebugMessage("finishTrace exception1", ex);
            ex.printStackTrace();
            return;
        }
        try {
            String errorMetricName;
            if (!error_reported && data.hasInvocationThrownException()) {
                this.err_detect_errMessage = data.getInvocationThrownException().getMessage();
                this.err_detect_errMessage = String.valueOf(this.err_detect_errMessage) + "  Program=" + this.programName + "  Gateway=" + this.gatewayName;
                String cfr_ignored_1 = String.valueOf(this.getFormattedResource()) + ": " + this.err_detect_errMessage;
                if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)this.err_detect_errMessage)) {
                    errorMetricName = String.valueOf(stack_eci_ComponentName) + kDetail_Program_Error_Interval_Suffix;
                    this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                    this.addRequestPerInterval(errorMetricName);
                    error_reported = true;
                }
            }
            formattedMetricName = String.valueOf(stack_eci_ComponentName) + kDetail_Program_RspTime_Suffix;
            IIntegerAverageDataAccumulator average = this.getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(formattedMetricName);
            average.IIntegerAggregatingDataAccumulator_recordDataPoint(data.getWallClockElapsedTimeAsInt());
            formattedMetricName = String.valueOf(stack_eci_ComponentName) + kDetail_Program_Concur_Invokes_Suffix;
            ILongFluctuatingCounterDataAccumulator accumulator = this.getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(formattedMetricName);
            accumulator.ILongFluctuatingCounterDataAccumulator_add(0L);
            if (!error_reported) {
                errorMetricName = String.valueOf(stack_eci_ComponentName) + kDetail_Program_Error_Interval_Suffix;
                this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(errorMetricName).ILongIntervalCounterDataAccumulator_addBatchIncidents(0L);
            }
            formattedMetricName = String.valueOf(stack_eci_ComponentName) + kDetail_Program_Reqs_per_Interval_Suffix;
            this.addRequestPerInterval(formattedMetricName);
            formattedMetricName = String.valueOf(stack_eci_ComponentName) + kDetail_Program_Stall_Count_Suffix;
            accumulator = this.getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(formattedMetricName);
            accumulator.ILongFluctuatingCounterDataAccumulator_add(0L);
            String eciMetric = String.valueOf(stack_eci_ComponentName) + kAggregate_This_Program_ECI_Count_Suffix;
            String ipicMetric = String.valueOf(stack_eci_ComponentName) + kAggregate_This_Program_IPIC_Count_Suffix;
            this.adjustMetricForCallType(callType, eciMetric, ipicMetric);
            String serverCommareaRequestMetric = String.valueOf(stack_eci_ComponentName) + kAggregate_CommArea_Request_Suffix;
            String serverCommareaReplyMetric = String.valueOf(stack_eci_ComponentName) + kAggregate_CommArea_Reply_Suffix;
            this.addCommareaLength(serverCommareaRequestMetric, commareaRequestLength, null);
            this.addCommareaLength(serverCommareaReplyMetric, commareaReplyLength, null);
            formattedMetricName = "Backends|CTG_to_CICS_ECI_IPIC:Program Invocations Per Interval";
            this.addRequestPerInterval(formattedMetricName);
            if (error_reported) {
                formattedMetricName = "Backends|CTG_to_CICS_ECI_IPIC:Program Aggregate Errors";
                this.increment(formattedMetricName);
            }
            eciMetric = "Backends|CTG_to_CICS_ECI_IPIC:Program Aggregate Count ECI";
            ipicMetric = "Backends|CTG_to_CICS_ECI_IPIC:Program Aggregate Count IPIC";
            this.adjustMetricForCallType(callType, eciMetric, ipicMetric);
            formattedMetricName = "Backends|CTG_to_CICS_ECI_IPIC:Program Average Response Time (ms)";
            average = this.getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(formattedMetricName);
            average.IIntegerAggregatingDataAccumulator_recordDataPoint(data.getWallClockElapsedTimeAsInt());
            if (stack_eci_GlobalsName == null) {
                skip_global_stats = true;
            } else if (stack_eci_GlobalsName.endsWith(":execute")) {
                skip_global_stats = true;
            }
            if (!skip_global_stats) {
                eciMetric = String.valueOf(stack_eci_GlobalsName) + kAggregate_All_Programs_ECI_Count_Suffix;
                ipicMetric = String.valueOf(stack_eci_GlobalsName) + kAggregate_All_Programs_IPIC_Count_Suffix;
                this.adjustMetricForCallType(callType, eciMetric, ipicMetric);
                formattedMetricName = String.valueOf(stack_eci_GlobalsName) + kAggregate_All_Programs_RspTime_Suffix;
                average = this.getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(formattedMetricName);
                average.IIntegerAggregatingDataAccumulator_recordDataPoint(data.getWallClockElapsedTimeAsInt());
                formattedMetricName = String.valueOf(stack_eci_GlobalsName) + kAggregate_All_Programs_Reqs_per_Interval_Suffix;
                this.addRequestPerInterval(formattedMetricName);
                String globalCommareaRequestMetric = String.valueOf(stack_eci_GlobalsName) + kAggregate_CommArea_Request_Suffix;
                String globalCommareaReplyMetric = String.valueOf(stack_eci_GlobalsName) + kAggregate_CommArea_Reply_Suffix;
                this.addCommareaLength(globalCommareaRequestMetric, commareaRequestLength, null);
                this.addCommareaLength(globalCommareaReplyMetric, commareaReplyLength, null);
            }
        }
        catch (Exception ex) {
            this.printDebugMessage("finishTrace exception2", ex);
            ex.printStackTrace();
            return;
        }
    }

    private void adjustMetricForCallType(CallType callType, String eciMetric, String ipicMetric) {
        if (callType == CallType.ECI_OR_IPIC) {
            this.increment(eciMetric);
        } else if (callType == CallType.IPIC_ONLY) {
            this.increment(ipicMetric);
        }
    }

    private void increment(String metricName) {
        IIntegerFluctuatingCounterDataAccumulator accumulator = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(metricName);
        accumulator.IIntegerFluctuatingCounterDataAccumulator_increment();
    }

    private void addRequestPerInterval(String metricName) {
        try {
            ILongIntervalCounterDataAccumulator accumulator = this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(metricName);
            accumulator.ILongIntervalCounterDataAccumulator_addSingleIncident();
        }
        catch (Exception e) {
            this.printDebugMessage("addRequestPerInterval failed for metric name " + metricName);
            e.printStackTrace();
        }
    }

    public int getCicsRc() {
        return this.cics_RetCode;
    }

    public String getCicsRcString() {
        return null;
    }

    public String toString() {
        return this.err_detect_errMessage;
    }

    public static Long get_BuildVersion_Sent_Flag() {
        return (Long)tls_Sent_Build_Version.get();
    }

    public static void set_BuildVersion_Sent_Flag(Long on_flag) {
        tls_Sent_Build_Version.set(on_flag);
    }

    public static String get_eci_Server_Name() {
        return (String)eci_Server_Name.get();
    }

    public static void set_eci_Server_Name(String serverName) {
        eci_Server_Name.set(serverName);
    }

    protected static boolean innerIpicCallWasMade() {
        return ipicCallStatus.get();
    }

    protected static void rememberInnerIpicCall() {
        ipicCallStatus.set(true);
    }

    protected static void forgetInnerIpicCall() {
        ipicCallStatus.set(false);
    }

    private Integer integerFromSuperclassMethod(Object object, String methodName) throws Exception {
        return (Integer)this.objectFromSuperclassMethod(object, methodName);
    }

    private String stringFromSuperclassMethod(Object object, String methodName) throws Exception {
        return (String)this.objectFromSuperclassMethod(object, methodName);
    }

    private Object objectFromSuperclassMethod(Object object, String methodName) throws Exception {
        Class<?> cls = object.getClass();
        if (cls == null) {
            return null;
        }
        if (cls.getName() == null) {
            return null;
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass == null) {
            return null;
        }
        Method method = superclass.getDeclaredMethod(methodName, null);
        if (method == null) {
            return null;
        }
        return method.invoke(object, null);
    }

    private void addCommareaLength(String metricName, long dataLength, BlameStackSnapshot snapshot) {
        if (dataLength <= 0L) {
            return;
        }
        if (this.debugger.enabled()) {
            dataLength *= this.debugger.commareaScale();
        }
        ILongFluctuatingCounterDataAccumulator accumulator = this.getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(metricName);
        accumulator.ILongFluctuatingCounterDataAccumulator_add(dataLength);
    }

    private void printDebugMessage(String message) {
        this.debugger.printDetail("ServerECIRequestTracer : " + message);
    }

    private void printDebugMessage(String message, Exception e) {
        this.printDebugMessage(String.valueOf(message) + " : " + e.getMessage());
    }

    private boolean startTraceCompletedFor(InvocationData data) {
        return data.getWallClockStartTime() != -1L;
    }

    private static enum CallType {
        UNKNOWN,
        IPIC_ONLY,
        ECI_OR_IPIC;


        public static CallType fromData(InvocationData data) {
            String methodName = data.getProbeInformation().getProbeIdentification().getProbeMethodName();
            if (methodName.equals("executeECI")) {
                return ECI_OR_IPIC;
            }
            if (methodName.equals("executeISC")) {
                return IPIC_ONLY;
            }
            return UNKNOWN;
        }
    }
}

