/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerAggregatingDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class ApmCTGServerCorrIDTracer
extends ASingleMetricTracerFactory {
    private static Class<? extends Object> classOfEciRequest = null;
    public static final String kCommareaFieldKey = "Commarea";
    public static final String kCommareaLength = "Commarea_Length";
    public static final String kProgramField = "Program";
    public static final String kServerField = "Server";
    public static final String kServProgName = "ServerName";
    public static final String kProgramName = "ProgramName";
    public static final String kUserCorrelationID = "CorUserCorrelationID";
    public static final String kCorId = "Cor";
    public static final String IBM037 = "IBM037";
    public static final int kCTG_MATCH_NONE = 0;
    public static final int kCTG_MATCH_FULLNAME = 1;
    public static final int kCTG_MATCH_START = 2;
    public static final int kCTG_MATCH_END = 3;
    public static final String kDefault_ECI_IPIC_OMAR_Metrics_HLQ = "Backends|CTG_to_CICS_ECI_IPIC_Trace";
    public String Backend_Server_Metrics_HLQ = "Backends|CTG_to_CICS_ECI_IPIC_Trace";
    public boolean Properties_Read = false;
    public boolean PublishMetrics = true;
    public boolean PublishTranTrace = true;
    public boolean ScanCorrIdAtStartTrace = false;
    public boolean CorrId_Format = true;
    public boolean Debug_Tracer = false;
    public boolean CorrId_Parms_Flip = false;
    public boolean CorrId_Underscore_Strip = false;
    public boolean CorrId_SpecialChar_Strip = true;
    public int corridOffset = 147;
    public int corridLength = 100;
    public int RSPThreshHoldValue = 0;
    public int progNameMatchCriteria = 0;
    public String progNameMatch = null;
    public InvocationData myInvokeData = null;
    public static final String PROPERTY_PUBLISH_METRICS = "introscope.ctg.trantracer.publish.metrics";
    public static final String PROPERTY_PUBLISH_TRANTRACE = "introscope.ctg.trantracer.publish.trantrace";
    public static final String PROPERTY_CORRIDSCAN_OFFSET = "introscope.ctg.trantracer.corridscan.offset";
    public static final String PROPERTY_CORRIDSCAN_LENGTH = "introscope.ctg.trantracer.corridscan.length";
    public static final String PROPERTY_CORRID_FORMAT = "introscope.ctg.trantracer.corrid.format.id";
    public static final String PROPERTY_CORRIDSCAN_STARTTRACE = "introscope.ctg.trantracer.corridscan.starttrace";
    public static final String PROPERTY_RSPTHRESHHOLD_VALUE = "introscope.ctg.trantracer.rspthreshhold.value";
    public static final String PROPERTY_PROGRAM_NAME = "introscope.ctg.trantracer.program.name";
    public static final String PROPERTY_PROGRAM_MATCH_CRITERIA = "introscope.ctg.trantracer.program.match.criteria";
    public static final String PROPERTY_METRIC_HLQ_NAME = "introscope.ctg.trantracer.metric.HLQname";
    public static final String PROPERTY_DEBUG_ENABLE = "introscope.ctg.trantracer.debug";
    public static final String PROPERTY_CORRID_PARMS_FLIP = "introscope.ctg.trantracer.corrid.parmsflip";
    public static final String PROPERTY_CORRID_UNDERSCORE_STRIP = "introscope.ctg.trantracer.corrid.underscorestrip";
    public static final String PROPERTY_CORRID_SPECIALCHAR_STRIP = "introscope.ctg.trantracer.corrid.specialcharstrip";

    public ApmCTGServerCorrIDTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        if (!this.Properties_Read) {
            this.PublishMetrics = agent.IAgent_getIndexedProperties().getBooleanProperty(PROPERTY_PUBLISH_METRICS, true);
            this.PublishTranTrace = agent.IAgent_getIndexedProperties().getBooleanProperty(PROPERTY_PUBLISH_TRANTRACE, true);
            this.Debug_Tracer = agent.IAgent_getIndexedProperties().getBooleanProperty(PROPERTY_DEBUG_ENABLE, false);
            this.corridOffset = agent.IAgent_getIndexedProperties().getIntProperty(PROPERTY_CORRIDSCAN_OFFSET, 147);
            this.corridLength = agent.IAgent_getIndexedProperties().getIntProperty(PROPERTY_CORRIDSCAN_LENGTH, 100);
            this.CorrId_Format = agent.IAgent_getIndexedProperties().getBooleanProperty(PROPERTY_CORRID_FORMAT, true);
            this.ScanCorrIdAtStartTrace = agent.IAgent_getIndexedProperties().getBooleanProperty(PROPERTY_CORRIDSCAN_STARTTRACE, false);
            this.RSPThreshHoldValue = agent.IAgent_getIndexedProperties().getIntProperty(PROPERTY_RSPTHRESHHOLD_VALUE, 0);
            this.progNameMatch = agent.IAgent_getIndexedProperties().getProperty(PROPERTY_PROGRAM_NAME);
            this.progNameMatchCriteria = agent.IAgent_getIndexedProperties().getIntProperty(PROPERTY_PROGRAM_MATCH_CRITERIA, 0);
            this.Backend_Server_Metrics_HLQ = agent.IAgent_getIndexedProperties().getProperty(PROPERTY_METRIC_HLQ_NAME);
            if (this.Backend_Server_Metrics_HLQ == null) {
                this.Backend_Server_Metrics_HLQ = kDefault_ECI_IPIC_OMAR_Metrics_HLQ;
            }
            this.CorrId_Parms_Flip = agent.IAgent_getIndexedProperties().getBooleanProperty(PROPERTY_CORRID_PARMS_FLIP, false);
            this.CorrId_Underscore_Strip = agent.IAgent_getIndexedProperties().getBooleanProperty(PROPERTY_CORRID_UNDERSCORE_STRIP, false);
            this.CorrId_SpecialChar_Strip = agent.IAgent_getIndexedProperties().getBooleanProperty(PROPERTY_CORRID_SPECIALCHAR_STRIP, true);
            this.Properties_Read = true;
            if (this.Debug_Tracer) {
                this.getModuleFeedback().warn("CTG APMSrv: constructor completed startup");
            }
        }
    }

    public boolean getPublishMetricsEnable() {
        return this.PublishMetrics;
    }

    public boolean getPublishTranTraceEnable() {
        return this.PublishTranTrace;
    }

    public void setPublishMetricsEnable(boolean enable_it) {
        this.PublishMetrics = enable_it;
    }

    public void setPublishTranTraceEnable(boolean enable_it) {
        this.PublishTranTrace = enable_it;
    }

    public int getUserCorrIdOffset() {
        return this.corridOffset;
    }

    public int getUserCorrIdLength() {
        return this.corridLength;
    }

    public int getMatchProgramNameCriteria() {
        return this.progNameMatchCriteria;
    }

    public String getMatchProgramNameValue() {
        return this.progNameMatch;
    }

    public int getRSPTimeThreshhold() {
        return this.RSPThreshHoldValue;
    }

    public String getMetricHLQ() {
        return this.Backend_Server_Metrics_HLQ;
    }

    public boolean getScanCorrIdAtStartTrace() {
        return this.ScanCorrIdAtStartTrace;
    }

    public void setUserCorrIdOffset(int offsetVal) {
        this.corridOffset = offsetVal;
    }

    public void setUserCorrIdLength(int lengthVal) {
        this.corridLength = lengthVal;
    }

    public void setMatchProgramNameCriteria(int match_criteria) {
        this.progNameMatchCriteria = match_criteria;
    }

    public void setMatchProgramNameValue(String ProgName) {
        this.progNameMatch = ProgName;
    }

    public void setRSPTimeThreshhold(int rspTimeThreshhold) {
        this.RSPThreshHoldValue = rspTimeThreshhold;
    }

    public void setMetricHLQ(String HLQvalue) {
        this.Backend_Server_Metrics_HLQ = HLQvalue;
    }

    public void setScanCorrIdAtStartTrace(boolean scanvalue) {
        this.ScanCorrIdAtStartTrace = scanvalue;
    }

    public String getUserCorrId(InvocationData data) {
        return (String)data.get(kUserCorrelationID);
    }

    public String getProgramName(InvocationData data) {
        return (String)data.get(kProgramName);
    }

    public String getServerName(InvocationData data) {
        return (String)data.get(kServProgName);
    }

    public InvocationData getCTGInvocationData() {
        return this.myInvokeData;
    }

    public boolean programNameMatches(String rcvdProgName, int matchCriteria) {
        return matchCriteria == 1 ? rcvdProgName.equals(this.progNameMatch) : (matchCriteria == 2 ? rcvdProgName.startsWith(this.progNameMatch) : matchCriteria == 3 && rcvdProgName.endsWith(this.progNameMatch));
    }

    public String extractUserCorrId(InvocationData data, String programName) {
        String corrId;
        block8: {
            if (programName == null || programName.equals("")) {
                return null;
            }
            corrId = null;
            try {
                corrId = this.extractUserCORRIDFromCommArea(data, programName);
                if (this.Debug_Tracer) {
                    this.getModuleFeedback().info("CTG APMSrv: extractUserCorrId() - found in CommArea for Program=" + programName + "  CorrId=" + corrId);
                }
                if (corrId != null) break block8;
                return null;
            }
            catch (Exception exc) {
                if (this.Debug_Tracer) {
                    this.getModuleFeedback().error("CTG APMSrv: extractUserCorrId() FAILED to retrieve CORRID from COMMAREA for Program=" + programName + "  cause=", (Throwable)exc);
                }
                return null;
            }
        }
        if (this.CorrId_Format) {
            corrId = this.formatCorrelationId(corrId);
            if (this.Debug_Tracer) {
                this.getModuleFeedback().info("CTG APMSrv: extractUserCorrId() - new formatted CorrId=" + corrId);
            }
        }
        return corrId;
    }

    private String extractUserCORRIDFromCommArea(InvocationData data, String programName) throws Exception {
        Object eciRequest = data.getInvocationObject();
        if (eciRequest == null) {
            this.getModuleFeedback().error("CTG APMSrv: extractUserCORRIDFromCommArea() - got Invocation Object as NULL");
            return null;
        }
        if (classOfEciRequest == null) {
            this.getModuleFeedback().warn("CTG APMSrv: extractUserCORRIDFromCommArea() - found classOfEciRequest == null.....returning no corrId");
            return null;
        }
        Field commareaField = classOfEciRequest.getDeclaredField(kCommareaFieldKey);
        if (commareaField == null) {
            if (this.Debug_Tracer) {
                this.getModuleFeedback().error("CTG APMSrv: extractUserCORRIDFromCommArea() - rcvd commarea Field equals to null");
            }
            return null;
        }
        byte[] commarea = (byte[])commareaField.get(eciRequest);
        if (commarea == null) {
            if (this.Debug_Tracer) {
                this.getModuleFeedback().info("CTG APMSrv: extractUserCORRIDFromCommArea() - got NULL COMMAREA from \"Commarea\" field from Program=" + programName);
            }
            return null;
        }
        int eci_Commarea_Length = commarea.length;
        if (eci_Commarea_Length < this.corridOffset + this.corridLength) {
            if (this.Debug_Tracer) {
                this.getModuleFeedback().info("CTG APMSrv: extractUserCORRIDFromCommArea() - Total \"Commarea\" is too short from Program=" + programName + ". CommArea Length=" + eci_Commarea_Length + ". Configured CorrId_Offset=" + this.corridOffset + ". CorrId_Length=" + this.corridLength);
            }
            return null;
        }
        byte[] customer_corrid_bytes = new byte[this.corridLength];
        System.arraycopy(commarea, this.corridOffset, customer_corrid_bytes, 0, this.corridLength);
        String customer_correlation_id = new String(customer_corrid_bytes, IBM037);
        customer_corrid_bytes = null;
        commarea = null;
        return customer_correlation_id;
    }

    public String formatCorrelationId(String corId) {
        if (corId == null) {
            return null;
        }
        if (corId.equals("")) {
            return null;
        }
        if (this.Debug_Tracer) {
            this.getModuleFeedback().warn("CTG APMclnt: formatCorrelationId RAW input=" + corId);
        }
        int numOfTokens = 4;
        corId = corId.replace(':', '_');
        corId = corId.replace('-', '_');
        corId = corId.replace('+', '_');
        corId = corId.replace('(', '_');
        corId = corId.replace(')', '_');
        corId = corId.replace('[', '_');
        corId = corId.replace(']', '_');
        corId = corId.replace('*', '_');
        corId = corId.replace('\"', '_');
        corId = corId.replace('~', '_');
        corId = corId.replace('^', '_');
        corId = corId.replace('?', '_');
        if (this.CorrId_SpecialChar_Strip) {
            corId = corId.replace('\\', '_');
            corId = corId.replace('/', '_');
            corId = corId.replace('{', '_');
            corId = corId.replace('}', '_');
            corId = corId.replace('|', '_');
            corId = corId.replace(',', '_');
            corId = corId.replace('.', '_');
            corId = corId.replace(';', '_');
            corId = corId.replace('=', '_');
            corId = corId.replace('\'', '_');
            corId = corId.replace('<', '_');
            corId = corId.replace('>', '_');
        }
        if (!this.CorrId_Underscore_Strip) {
            if (this.Debug_Tracer) {
                this.getModuleFeedback().warn("CTG APMclnt1: formatCorrelationId final result=" + corId);
            }
            return corId;
        }
        if (this.Debug_Tracer) {
            this.getModuleFeedback().warn("CTG APMclnt: formatCorrelationId REPLACE results=" + corId);
        }
        StringTokenizer st = new StringTokenizer(corId, "_");
        ArrayList<String> listOfTokens = new ArrayList<String>();
        int i = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() <= 0) continue;
            listOfTokens.add(i++, token);
        }
        if (listOfTokens.size() < numOfTokens) {
            numOfTokens = listOfTokens.size();
        }
        StringBuffer stBuff = new StringBuffer();
        int j = 0;
        while (j < numOfTokens) {
            stBuff.append((String)listOfTokens.get(j)).append("_");
            ++j;
        }
        String newCorrId = null;
        if (stBuff.length() > 1) {
            newCorrId = stBuff.substring(0, stBuff.length() - 1);
        }
        if (this.Debug_Tracer) {
            this.getModuleFeedback().warn("CTG APMclnt2: formatCorrelationId final result=" + newCorrId);
        }
        st = null;
        listOfTokens = null;
        stBuff = null;
        return newCorrId;
    }

    private String extractProgramNameFromRcvdClientRequest(InvocationData data) {
        String programName;
        block11: {
            Field progField;
            Object invokeObject;
            block10: {
                invokeObject = data.getInvocationObject();
                if (invokeObject == null) {
                    this.getModuleFeedback().error("CTG APMSrv: extractProgramNameFromRcvdClientRequest() - got Invocation Object as NULL ");
                    return null;
                }
                if (classOfEciRequest == null) {
                    Class<?> invoke_Class = invokeObject.getClass();
                    if (invoke_Class == null) {
                        this.getModuleFeedback().error("CTG APMSrv: extractProgramNameFromRcvdClientRequest() - got invokeObject.getClass() == null");
                        return null;
                    }
                    classOfEciRequest = invoke_Class.getSuperclass();
                    if (classOfEciRequest == null) {
                        this.getModuleFeedback().error("CTG APMSrv: extractProgramNameFromRcvdClientRequest() - got invokeObject.getSuperclass() == null");
                        return null;
                    }
                }
                programName = null;
                progField = classOfEciRequest.getDeclaredField(kProgramField);
                if (progField != null) break block10;
                if (this.Debug_Tracer) {
                    this.getModuleFeedback().warn("CTG APMSrv: extractProgramNameFromRcvdClientRequest() - got Program Field equals to null");
                }
                return null;
            }
            try {
                programName = (String)progField.get(invokeObject);
                if (programName == null) {
                    this.getModuleFeedback().warn("CTG APMSrv: extractProgramNameFromRcvdClientRequest() - DID NOT find Program Name in \"Program\" field");
                    programName = null;
                }
                if (this.Debug_Tracer) {
                    this.getModuleFeedback().info("CTG APMSrv: extractProgramNameFromRcvdClientRequest() - Found  Program=" + programName);
                }
            }
            catch (Exception ex) {
                if (!this.Debug_Tracer) break block11;
                this.getModuleFeedback().error("CTG APMSrv: extractProgramNameFromRcvdClientRequest - failed to extract program names from CommArea " + ex);
            }
        }
        return programName;
    }

    private String extractServerNameFromRcvdClientRequest(InvocationData data) {
        Field serverField;
        String gatewayName;
        Class<?> invoke_Class;
        Object invokeObject;
        block12: {
            invokeObject = data.getInvocationObject();
            if (invokeObject == null) {
                this.getModuleFeedback().error("CTG APMSrv: extractServerNameFromRcvdClientRequest() - got Invocation Object as NULL");
                return null;
            }
            invoke_Class = invokeObject.getClass();
            if (classOfEciRequest == null) {
                if (invoke_Class == null) {
                    this.getModuleFeedback().error("CTG APMSrv: extractServerNameFromRcvdClientRequest() - got invokeObject.getClass() == null");
                    return null;
                }
                classOfEciRequest = invoke_Class.getSuperclass();
                if (classOfEciRequest == null) {
                    this.getModuleFeedback().error("CTG APMSrv: extractServerNameFromRcvdClientRequest() - got invokeObject.getSuperclass() == null");
                    return null;
                }
            }
            gatewayName = null;
            serverField = classOfEciRequest.getDeclaredField(kServerField);
            if (serverField != null) break block12;
            if (this.Debug_Tracer) {
                this.getModuleFeedback().warn("CTG APMSrv: extractServerNameFromRcvdClientRequest() - got Server Field equals to null");
            }
            return null;
        }
        try {
            gatewayName = (String)serverField.get(invokeObject);
            if (gatewayName == null) {
                if (this.Debug_Tracer) {
                    this.getModuleFeedback().warn("CTG APMSrv: extractServerNameFromRcvdClientRequest() - DID NOT find Server Name in \"Server\" field");
                }
                gatewayName = null;
            }
            if (this.Debug_Tracer) {
                this.getModuleFeedback().info("CTG APMSrv: extractServerNameFromCommArea() - Found Server=" + gatewayName);
            }
        }
        catch (Exception ex) {
            if (this.Debug_Tracer) {
                this.getModuleFeedback().error("CTG APMSrv: extractServerNameFromRcvdClientRequest - failed to extract server names from CommArea. invoke_class=" + invoke_Class + "  Cause=" + ex);
            }
            gatewayName = null;
        }
        return gatewayName;
    }

    protected final IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return null;
    }

    public IIntegerAggregatingDataAccumulator getAvgeDataAccumulator(String componentName) {
        String respTimeName = String.valueOf(componentName) + ":Average Response Time (ms)";
        return this.getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(respTimeName);
    }

    public ILongIntervalCounterDataAccumulator getCounterDataAccumulator(String componentName) {
        String counterName = String.valueOf(componentName) + ":Responses Per Interval";
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(counterName);
    }

    public ILongIntervalCounterDataAccumulator getThreshholdDataAccumulator(String componentName) {
        String counterName = String.valueOf(componentName) + ":Threshhold Exceeded Per Interval";
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(counterName);
    }

    public ILongIntervalCounterDataAccumulator getErrorDataAccumulator(String componentName) {
        String counterName = String.valueOf(componentName) + ":Errors Per Interval";
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(counterName);
    }

    public void publishMetricsToEM(String componentName, int elaspsedTime, boolean threshholdExceeded, boolean reportError, BlameStackSnapshot snapshot) {
        this.getAvgeDataAccumulator(componentName).IIntegerAggregatingDataAccumulator_recordDataPoint(elaspsedTime, snapshot);
        this.getCounterDataAccumulator(componentName).ILongIntervalCounterDataAccumulator_addSingleIncident(snapshot);
        if (threshholdExceeded) {
            this.getThreshholdDataAccumulator(componentName).ILongIntervalCounterDataAccumulator_addSingleIncident(snapshot);
        }
        if (reportError) {
            this.getErrorDataAccumulator(componentName).ILongIntervalCounterDataAccumulator_addSingleIncident(snapshot);
        }
    }

    public void writeTranTraceToEM(InvocationData data, String componentName, String serverName, String programName, String userCorrId, boolean foundError) {
        Throwable thr;
        long startTime = data.getWallClockStartTime();
        long duration = data.getWallClockFinishTime() - startTime;
        HashMap<String, String> eventData = new HashMap<String, String>();
        String parm_Name = "httpsession.attribute.ServerName";
        eventData.put(parm_Name, serverName);
        parm_Name = "httpsession.attribute.ProgramName";
        eventData.put(parm_Name, programName);
        if (userCorrId != null) {
            parm_Name = kUserCorrelationID;
            if (this.CorrId_Parms_Flip) {
                eventData.put(kCorId + userCorrId, parm_Name);
            } else {
                eventData.put(parm_Name, userCorrId);
            }
        }
        eventData.put("Trace Type", "Normal");
        if (foundError) {
            thr = data.getInvocationThrownException();
            eventData.put("Error Message", thr.getMessage());
        }
        TransactionComponentData tcData = new TransactionComponentData(componentName, startTime, duration, eventData);
        this.getAgent().IAgent_queueEvent(tcData);
        if (this.Debug_Tracer) {
            this.getModuleFeedback().info("CTG APMSrv: ITracer_finishTrace() - Completed TranTrace send to EM.  corrid=" + userCorrId);
        }
        eventData = null;
        tcData = null;
        thr = null;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        boolean continue_tracing;
        boolean name_matches;
        if (!this.PublishMetrics && !this.PublishTranTrace) {
            return;
        }
        this.myInvokeData = data;
        data.storeWallClockStartTime();
        String serverName = this.extractServerNameFromRcvdClientRequest(data);
        if (serverName == null) {
            return;
        }
        String programName = this.extractProgramNameFromRcvdClientRequest(data);
        if (programName == null) {
            return;
        }
        if (this.progNameMatchCriteria != 0 && this.progNameMatch != null && !(name_matches = this.programNameMatches(programName, this.progNameMatchCriteria))) {
            return;
        }
        String componentName = String.valueOf(this.Backend_Server_Metrics_HLQ) + "|" + serverName.replace("|", "_").replace(":", "_") + "|" + programName.replace("|", "_").replace(":", "_");
        String userCorrId = null;
        if (programName != null && this.corridLength > 0 && this.ScanCorrIdAtStartTrace) {
            userCorrId = this.extractUserCorrId(data, programName);
        }
        if (!(continue_tracing = this.startTrace_Extender(data, componentName, serverName, programName, userCorrId))) {
            userCorrId = null;
            return;
        }
        data.setComponentNameAt(componentName, tracerIndex);
        data.put(kServProgName, (Object)serverName);
        data.put(kProgramName, (Object)programName);
        if (userCorrId != null) {
            data.put(kUserCorrelationID, (Object)userCorrId);
        }
        userCorrId = null;
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        boolean sendStuff;
        if (!this.PublishMetrics && !this.PublishTranTrace) {
            return;
        }
        this.myInvokeData = data;
        if (data.getWallClockStartTime() == -1L) {
            return;
        }
        String serverName = (String)data.get(kServProgName);
        String programName = (String)data.get(kProgramName);
        if (programName == null) {
            return;
        }
        String userCorrId = null;
        if (programName != null && this.corridLength > 0) {
            userCorrId = this.ScanCorrIdAtStartTrace ? (String)data.get(kUserCorrelationID) : this.extractUserCorrId(data, programName);
        }
        boolean foundError = false;
        BlameStackSnapshot snapshot = BlameStackSnapshot.kEmptyBlameStackSnapshot;
        String componentName = data.getComponentNameAt(tracerIndex);
        int elaspseTime = data.getWallClockElapsedTimeAsInt();
        if (data.hasInvocationThrownException()) {
            foundError = true;
        }
        boolean threshholdExceeded = false;
        if (this.RSPThreshHoldValue > 0 && elaspseTime > this.RSPThreshHoldValue) {
            threshholdExceeded = true;
        }
        if (sendStuff = this.finishTrace_Extender(data, componentName, serverName, programName, userCorrId, elaspseTime, threshholdExceeded, foundError, snapshot)) {
            if (this.PublishMetrics) {
                this.publishMetricsToEM(componentName, elaspseTime, threshholdExceeded, foundError, snapshot);
            }
            if (this.PublishTranTrace && (this.RSPThreshHoldValue == 0 || threshholdExceeded)) {
                this.writeTranTraceToEM(data, componentName, serverName, programName, userCorrId, foundError);
            }
        }
        userCorrId = null;
    }

    public boolean startTrace_Extender(InvocationData data, String ComponentName, String ServerName, String ProgramName, String UserCorrId) {
        return true;
    }

    public boolean finishTrace_Extender(InvocationData data, String ComponentName, String ServerName, String ProgramName, String UserCorrId, int ElaspsedTime, boolean ThreshholdExceeded, boolean ReportError, BlameStackSnapshot Snapshot) {
        return true;
    }
}

