/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.exitpoint;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.detection.StackTraceRecorder;
import com.wily.introscope.agent.intelligent.exitpoint.ExitPointCandidateFinder;
import com.wily.introscope.agent.intelligent.exitpoint.stacktrace.TraceRecordingTicketMaster;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.util.StringUtils;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.IntegerConfigurationProperty;
import com.wily.util.properties.hot.StringSetConfigurationProperty;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ExitPointDetectionConfiguration {
    private static final Module MODULE = new Module("AutomaticBackendDetection");
    private static volatile Logger.ILoggingHandler logger = new Logger.NoOpLoggingHandler();
    private static volatile boolean initCompleted = false;
    private static volatile boolean isExitPointDetectionEnabled = false;
    private static volatile int candidateFinderInterval = 600;
    private static volatile boolean shouldLogStackTraces = true;
    private static volatile Set<String> essentialPackagesToSkip = ExitPointDetectionConfiguration.getDefaultEssentialPackagesToSkip();
    private static volatile Set<String> additionalPackagesToSkip = ExitPointDetectionConfiguration.getDefaultAdditionalPackagesToSkip();
    private static volatile boolean isCircuitBreakerEnabled = true;
    private static volatile int circuitBreakerInterval = 3600;
    private static volatile int cbMaxWaitIntervals = 128;

    static {
        try {
            ExitPointDetectionConfiguration.initLogger(AgentShim.getAgent());
        }
        catch (AgentNotAvailableException e) {
            AgentShim.handleError((String)"Error while getting Agent instance for Automatic Backend Detection Configuration", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(IAgent agent) {
        boolean result = initCompleted;
        if (result) return;
        Class<ExitPointDetectionConfiguration> clazz = ExitPointDetectionConfiguration.class;
        synchronized (ExitPointDetectionConfiguration.class) {
            result = initCompleted;
            if (result) return;
            ExitPointDetectionConfiguration.initializeCircuitBreakerMaxWaitIntervals(agent);
            ExitPointDetectionConfiguration.initializeExitPointDetectionEnabled(agent);
            ExitPointDetectionConfiguration.initializeStackTraceRecordingsMaxThreads(agent);
            ExitPointDetectionConfiguration.initializeStackTraceRecordingsLimitPerThread(agent);
            ExitPointDetectionConfiguration.initializeStackTracesRecordWaitIntervals(agent);
            ExitPointDetectionConfiguration.initializeCandidateFinderInterval(agent);
            ExitPointDetectionConfiguration.initializeEssentialPackagesToSkip(agent);
            ExitPointDetectionConfiguration.initializeAdditionalPackagesToSkip(agent);
            ExitPointDetectionConfiguration.initializeLogStackTraceEnabled(agent);
            ExitPointDetectionConfiguration.initializeSustainabilityMetricsEnabled(agent);
            ExitPointDetectionConfiguration.initializeCircuitBreakerEnabled(agent);
            ExitPointDetectionConfiguration.initializeCircuitBreakerInterval(agent);
            ExitPointCandidateFinder.init(agent);
            initCompleted = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static void initializeExitPointDetectionEnabled(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        BooleanConfigurationProperty entryPointDetectionEnabledProperty = new BooleanConfigurationProperty("introscope.agent.automatic.backend.detection.enabled", false, "Enables/Disables automatic backend detection feature", true, false, agent.IAgent_getModuleFeedback(), MODULE, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                boolean status = (Boolean)newValue;
                ExitPointDetectionConfiguration.setExitPointDetectionEnabledStatus(status);
            }
        };
        configManager.add((ConfigurationProperty)entryPointDetectionEnabledProperty, true);
    }

    private static void initializeStackTraceRecordingsMaxThreads(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        IntegerConfigurationProperty property = new IntegerConfigurationProperty("introscope.agent.automatic.backend.detection.stackTraces.record.threads.count.max", 2, "Automatic Backend Detection Feature - Maximim number of threads selected for stack trace recordings in an interval", "", true, false, agent.IAgent_getModuleFeedback(), MODULE, agent.IAgent_getStringLocalizer()){

            public boolean validate(Object value) {
                int intVal = (Integer)value;
                return intVal >= 0;
            }

            public void set(Object newValue) {
                super.set(newValue);
                int value = (Integer)newValue;
                TraceRecordingTicketMaster.getInstance().setTotalTickets(value);
            }
        };
        configManager.add((ConfigurationProperty)property, true);
    }

    private static void initializeStackTraceRecordingsLimitPerThread(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        IntegerConfigurationProperty property = new IntegerConfigurationProperty("introscope.agent.automatic.backend.detection.stackTraces.record.limitPerThread", 5, "Automatic Backend Detection Feature - Limits the number of consecutive stack traces to record for a single thread", "", true, false, agent.IAgent_getModuleFeedback(), MODULE, agent.IAgent_getStringLocalizer()){

            public boolean validate(Object value) {
                int intVal = (Integer)value;
                return intVal >= 2;
            }

            public void set(Object newValue) {
                super.set(newValue);
                int value = (Integer)newValue;
                StackTraceRecorder.getInstance().getExitPointStackTraceRecorder().getThreadSelector().setStackTracesLimitPerThread(value);
            }
        };
        configManager.add((ConfigurationProperty)property, true);
    }

    private static void initializeStackTracesRecordWaitIntervals(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        IntegerConfigurationProperty property = new IntegerConfigurationProperty("introscope.agent.automatic.backend.detection.stackTraces.record.waitIntervals.max", 5, "Automatic Backend Detection Feature - Maximum number of time intervals to elapse, before selecting previosly picked thread", "", true, false, agent.IAgent_getModuleFeedback(), MODULE, agent.IAgent_getStringLocalizer()){

            public boolean validate(Object value) {
                int intVal = (Integer)value;
                return intVal >= 0;
            }

            public void set(Object newValue) {
                super.set(newValue);
                int value = (Integer)newValue;
                ExitPointCandidateFinder.getInstance().setNumberIntervalsToElapse(value);
            }
        };
        configManager.add((ConfigurationProperty)property, true);
    }

    private static void initializeCandidateFinderInterval(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        IntegerConfigurationProperty property = new IntegerConfigurationProperty("introscope.agent.automatic.backend.detection.candidate.finder.intervalSeconds", 600, "Automatic Backend Detection Feature - Frequency at which automatic backend candidate finder will be executed", "seconds", false, false, agent.IAgent_getModuleFeedback(), MODULE, agent.IAgent_getStringLocalizer()){

            public boolean validate(Object value) {
                int intVal = (Integer)value;
                return intVal > 0;
            }

            public void set(Object newValue) {
                super.set(newValue);
                ExitPointDetectionConfiguration.setCandidateFinderInterval((Integer)newValue);
            }
        };
        configManager.add((ConfigurationProperty)property, true);
    }

    private static void initializeEssentialPackagesToSkip(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        StringSetConfigurationProperty skipPackagesProperty = new StringSetConfigurationProperty("introscope.agent.automatic.backend.detection.rules.skip.pkgs.essential", ExitPointDetectionConfiguration.getDefaultEssentialPackagesToSkip(), "Automatic Backend Detection Feature - Comma separated list of packages. Used for skipp agent classes to be selected as a backend", "", false, false, agent.IAgent_getModuleFeedback(), MODULE, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                ExitPointDetectionConfiguration.setEssentialPackgesToSkip((Set)newValue);
            }
        };
        configManager.add((ConfigurationProperty)skipPackagesProperty, true);
    }

    private static void initializeAdditionalPackagesToSkip(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        StringSetConfigurationProperty skipPackagesProperty = new StringSetConfigurationProperty("introscope.agent.automatic.backend.detection.skip.pkgs", ExitPointDetectionConfiguration.getDefaultAdditionalPackagesToSkip(), "Automatic Backend Detection Feature - Comma separated list of packages. A class#method belonging to any of listed packages is skipped as a backend candidate", "", false, false, agent.IAgent_getModuleFeedback(), MODULE, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                ExitPointDetectionConfiguration.setAdditionalPackagesToSkip((Set)newValue);
            }
        };
        configManager.add((ConfigurationProperty)skipPackagesProperty, true);
    }

    private static void initializeLogStackTraceEnabled(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        BooleanConfigurationProperty logStackTraceEnabledProperty = new BooleanConfigurationProperty("introscope.agent.automatic.backend.detection.log.stackTrace.enabled", true, "Automatic Backend Detection Feature - Enables/Disables logging of stack traces", true, false, agent.IAgent_getModuleFeedback(), MODULE, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                ExitPointDetectionConfiguration.setShouldLogStackTraces((Boolean)newValue);
            }
        };
        configManager.add((ConfigurationProperty)logStackTraceEnabledProperty, true);
    }

    private static void initializeSustainabilityMetricsEnabled(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        BooleanConfigurationProperty sustainabilityMetricsProperty = new BooleanConfigurationProperty("introscope.agent.automatic.backend.detection.sustainability.metrics.enabled", true, "Automatic Backend Detection Feature - Enables/Disables sustainability metrics", true, false, agent.IAgent_getModuleFeedback(), MODULE, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                SustainabilityMetricsHelper.setExitPointSustainabilityEnabled((boolean)((Boolean)newValue));
            }
        };
        configManager.add((ConfigurationProperty)sustainabilityMetricsProperty, true);
    }

    private static void initializeCircuitBreakerEnabled(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        BooleanConfigurationProperty property = new BooleanConfigurationProperty("introscope.agent.automatic.backend.detection.circuitBreaker.enabled", true, "Automatic Backend Detection Feature - Enables/Disables circuit breaker for automatic backend detection", true, false, agent.IAgent_getModuleFeedback(), MODULE, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                boolean status = (Boolean)newValue;
                ExitPointDetectionConfiguration.setCircuitBreakerEnabledStatus(status);
            }
        };
        configManager.add((ConfigurationProperty)property, true);
    }

    private static void initializeCircuitBreakerInterval(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        IntegerConfigurationProperty property = new IntegerConfigurationProperty("introscope.agent.automatic.backend.detection.circuitBreaker.intervalSeconds", 3600, "Automatic Backend Detection Feature - Frequency at which automatic backend detection circuit breaker will be executed", "seconds", false, false, agent.IAgent_getModuleFeedback(), MODULE, agent.IAgent_getStringLocalizer()){

            public boolean validate(Object value) {
                int intVal = (Integer)value;
                return intVal > 0;
            }

            public void set(Object newValue) {
                super.set(newValue);
                ExitPointDetectionConfiguration.setCircuitBreakerInterval((Integer)newValue);
            }
        };
        configManager.add((ConfigurationProperty)property, true);
    }

    private static void initializeCircuitBreakerMaxWaitIntervals(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        IntegerConfigurationProperty property = new IntegerConfigurationProperty("introscope.agent.automatic.backend.detection.circuitBreaker.waitIntervals.max", 128, "", "", true, false, agent.IAgent_getModuleFeedback(), MODULE, agent.IAgent_getStringLocalizer()){

            public boolean validate(Object value) {
                int intVal = (Integer)value;
                return intVal >= 0;
            }

            public void set(Object newValue) {
                super.set(newValue);
                cbMaxWaitIntervals = (Integer)newValue;
            }
        };
        configManager.add((ConfigurationProperty)property, true);
    }

    public static boolean isExitPointDetectionEnabled() {
        return isExitPointDetectionEnabled;
    }

    public static void setExitPointDetectionEnabledStatus(boolean status) {
        isExitPointDetectionEnabled = status;
        StackTraceRecorder.getExitPointRecorder().setRecordingStatus(status);
    }

    public static int getCandidateFinderInterval() {
        return candidateFinderInterval;
    }

    public static void setCandidateFinderInterval(int interval) {
        candidateFinderInterval = interval;
    }

    public static boolean shouldLogStackTraces() {
        return shouldLogStackTraces;
    }

    public static void setShouldLogStackTraces(boolean flag) {
        shouldLogStackTraces = flag;
    }

    public static Set<String> getEssentialPackagesToSkip() {
        return essentialPackagesToSkip;
    }

    public static Set<String> getDefaultEssentialPackagesToSkip() {
        return StringUtils.parseAndTrimListToSet((String)"com.ca,com.wily,java,javax,sun,com.sun", (String)",");
    }

    public static void setEssentialPackgesToSkip(Set<String> packages) {
        essentialPackagesToSkip = packages;
    }

    public static void setEssentialPackgesToSkip(String commaSeparatedPackages) {
        essentialPackagesToSkip = new HashSet<String>(Arrays.asList(commaSeparatedPackages.split(",")));
    }

    public static Set<String> getAdditionalPackagesToSkip() {
        return additionalPackagesToSkip;
    }

    public static Set<String> getDefaultAdditionalPackagesToSkip() {
        return StringUtils.parseAndTrimListToSet((String)"", (String)",");
    }

    public static void setAdditionalPackagesToSkip(Set<String> packages) {
        additionalPackagesToSkip = packages;
    }

    public static void setCircuitBreakerEnabledStatus(boolean status) {
        isCircuitBreakerEnabled = status;
    }

    public static boolean isCircuitBreakerEnabled() {
        return isCircuitBreakerEnabled;
    }

    public static void setCircuitBreakerInterval(int interval) {
        circuitBreakerInterval = interval;
    }

    public static int getCircuitBreakerInterval() {
        return circuitBreakerInterval;
    }

    public static int getCircuitBreakerMaxWaitIntervals() {
        return cbMaxWaitIntervals;
    }

    private static void initLogger(IAgent agent) {
        logger = new Logger.LoggingHandler(MODULE, agent);
    }

    public static Logger.ILoggingHandler getLogger() {
        return logger;
    }
}

