/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.exitpoint.stacktrace;

import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.StackTraceRepository;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class WrappedStackTrace {
    private final int invocationId;
    private final StackTraceElement[] trace;
    private Type type;

    public WrappedStackTrace(int invocationId, StackTraceElement[] trace) {
        this(invocationId, trace, null);
    }

    private WrappedStackTrace(int invocationId, StackTraceElement[] trace, Type type) {
        this.invocationId = invocationId;
        this.trace = trace;
        this.setType(type);
    }

    public int getInvocationId() {
        return this.invocationId;
    }

    public StackTraceElement[] getTrace() {
        return this.trace;
    }

    protected Type getType() {
        return this.type;
    }

    private void setType(Type type) {
        this.type = type;
    }

    public void findAndSetType() {
        if (this.getType() == null) {
            this.setType(WrappedStackTrace.findType(this.getTrace()));
        }
    }

    public Type findAndGetType() {
        this.findAndSetType();
        return this.getType();
    }

    public static Type findType(StackTraceElement[] trace) {
        StackTraceElement[] actualTrace = StackTraceRepository.getAgentElementsFilter().filter(trace);
        if (actualTrace != null && actualTrace.length > 0) {
            String topMethodName = actualTrace[0].getMethodName();
            for (Type type : EnumSet.allOf(Type.class)) {
                if (!type.isAffliatedMethod(topMethodName)) continue;
                return type;
            }
        }
        return Type.UNKNOWN;
    }

    public String description() {
        return String.format("[type:%s, invId:%d]", new Object[]{this.findAndGetType(), this.invocationId});
    }

    public String toString() {
        return String.format("[type:%s, invId:%d, elementsCount:%d]", new Object[]{this.findAndGetType(), this.invocationId, this.trace.length});
    }

    public static enum Type {
        READ("read", "receive"),
        WRITE("write", "send"),
        UNKNOWN(new String[0]);

        private Set<String> affliatedMethods = new HashSet<String>();

        private Type(String ... methods) {
            String[] stringArray = methods;
            int n2 = methods.length;
            int n3 = 0;
            while (n3 < n2) {
                String method = stringArray[n3];
                this.affliatedMethods.add(method);
                ++n3;
            }
        }

        public boolean isAffliatedMethod(String methodName) {
            return this.affliatedMethods.contains(methodName);
        }

        public boolean addAffliatedMethod(String methodName) {
            return this.affliatedMethods.add(methodName);
        }
    }
}

