/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.zos;

import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.File;

public final class LibraryLoader {
    private static final String BIT_MODE_PROPERTY = "com.ibm.vm.bitmode";
    private static boolean loaded = false;

    public static void loadLibrary(IAgent agent) {
        if (loaded) {
            return;
        }
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        String libraryFile = LibraryLoader.pathToLibraryFor(agent);
        try {
            System.load(libraryFile);
            loaded = true;
            feedback.info("z/OS Extension library loaded from " + libraryFile);
        }
        catch (Exception e) {
            feedback.error("Failed to load z/OS Extension library from " + libraryFile);
            throw new RuntimeException(e.getMessage());
        }
    }

    public static boolean libraryLoaded() {
        return loaded;
    }

    private static String pathToLibraryFor(IAgent agent) {
        String extDirectory = agent.IAgent_getExtensionAdministrator().getAgentExtensionDirectory().getAbsolutePath();
        String jvmBitMode = System.getProperty(BIT_MODE_PROPERTY);
        String libraryName = jvmBitMode.equals("64") ? "libsysinfo64.so" : "libsysinfo32.so";
        String fullPathName = String.valueOf(extDirectory) + File.separator + libraryName;
        File pathAsFile = new File(fullPathName);
        try {
            fullPathName = pathAsFile.getCanonicalPath();
        }
        catch (Exception exception) {}
        return fullPathName;
    }
}

