/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.zos;

import com.wily.powerpack.zos.SystemInfo;

public class TimerDeltaCalculator {
    private long currentSrbProcessorTime;
    private long newSrbProcessorTime;
    private long currentTcbProcessorTime;
    private long newTcbProcessorTime;
    private long currentTotalProcessorTime;
    private long newTotalProcessorTime;
    private long currentTotalZaapTime;
    private long newTotalZaapTime;
    private long currentTotalZiipTime;
    private long newTotalZiipTime;
    private boolean initialized;

    public long getSrbProcessorTime() {
        return this.newSrbProcessorTime;
    }

    public long getTcbProcessorTime() {
        return this.newTcbProcessorTime;
    }

    public long getTotalProcessorTime() {
        return this.newTotalProcessorTime;
    }

    public long getTotalZaapTime() {
        return this.newTotalZaapTime;
    }

    public long getTotalZiipTime() {
        return this.newTotalZiipTime;
    }

    public long getSrbProcessorTimeDelta() {
        return this.nonNegative(this.getTotalProcessorTimeDelta() - this.getTcbProcessorTimeDelta());
    }

    public long getTcbProcessorTimeDelta() {
        return this.nonNegative(this.newTcbProcessorTime - this.currentTcbProcessorTime);
    }

    public long getTotalProcessorTimeDelta() {
        return this.nonNegative(this.newTotalProcessorTime - this.currentTotalProcessorTime);
    }

    public long getTotalZaapTimeDelta() {
        return this.nonNegative(this.newTotalZaapTime - this.currentTotalZaapTime);
    }

    public long getTotalZiipTimeDelta() {
        return this.nonNegative(this.newTotalZiipTime - this.currentTotalZiipTime);
    }

    public void setFromInfo(SystemInfo info) {
        this.newTcbProcessorTime = info.getTcbTime();
        this.newSrbProcessorTime = info.getSrbTime();
        this.newTotalProcessorTime = info.getTotalTime();
        this.newTotalZaapTime = info.getZaapTime();
        this.newTotalZiipTime = info.getZiipTime();
        if (!this.initialized) {
            this.rememberValuesForNextPass();
            this.initialized = true;
        }
    }

    public void rememberValuesForNextPass() {
        this.currentSrbProcessorTime = this.newSrbProcessorTime;
        this.currentTcbProcessorTime = this.newTcbProcessorTime;
        this.currentTotalProcessorTime = this.newTotalProcessorTime;
        this.currentTotalZaapTime = this.newTotalZaapTime;
        this.currentTotalZiipTime = this.newTotalZiipTime;
    }

    private long nonNegative(long value) {
        return value < 0L ? 0L : value;
    }
}

