/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.MonitoredClasses.MonitoredClassFactory;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.MQClassLoaderUtil;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.Reflection;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JMSSendCorrelationTracer
extends ASingleMetricTracerFactory {
    private IModuleFeedbackChannel fLogger = MQPPLog.getLogger();
    private static boolean javaSecurityEnabled = false;
    public static final Module kModule = new Module("JMSSendCorrelationTracer");

    static {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        MQClassLoaderUtil.initialize(classloader);
        Reflection.initialise(classloader);
    }

    public JMSSendCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
        this.fLogger.debug(kModule, "Inside JMSSendCorrelationTracer consutructor");
    }

    protected IDataAccumulator createDataAccumulator(String arg0) {
        return null;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (TraceProperties.shouldInsertIntoMQHeader()) {
            this.fLogger.debug(kModule, "Invocation Object: " + data.getInvocationObject());
            Object messageObject = null;
            int parameterCount = data.getInvocationParameterCount();
            if (parameterCount == 1 || parameterCount == 4) {
                messageObject = data.getInvocationParameterAsObject(0);
            } else if (parameterCount == 2 || parameterCount == 5) {
                messageObject = data.getInvocationParameterAsObject(1);
            }
            if (messageObject != null) {
                String correlationString = new CorrelationId().getOutgoingCorrelationIdStrippedForHeader();
                Class<?> messageObjectClass = messageObject.getClass();
                String jmsMessageClassName = messageObjectClass.getName();
                String jmsMessageSuperClassName = messageObjectClass.getSuperclass().getName();
                String jmsMessageSuper2ClassName = messageObjectClass.getSuperclass().getSuperclass().getName();
                try {
                    boolean propertiesReadOnly = false;
                    Object delegateMessageObject = null;
                    try {
                        if (jmsMessageClassName.equals("com.ibm.jms.JMSMessage") || jmsMessageSuperClassName.equals("com.ibm.jms.JMSMessage") || jmsMessageSuper2ClassName.equals("com.ibm.jms.JMSMessage")) {
                            if (MonitoredClassFactory.mqV7AppearsToBePresent()) {
                                delegateMessageObject = MQClassLoaderUtil.fJMSMessage_delegateMsg.get(messageObject);
                                if (delegateMessageObject != null) {
                                    propertiesReadOnly = MQClassLoaderUtil.fJmsMessageImpl_propertiesReadOnly.getBoolean(delegateMessageObject);
                                }
                            } else {
                                propertiesReadOnly = MQClassLoaderUtil.fJMSMessage_propertiesReadOnly.getBoolean(messageObject);
                            }
                        } else if (jmsMessageClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl") || jmsMessageSuperClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl") || jmsMessageSuper2ClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl")) {
                            propertiesReadOnly = MQClassLoaderUtil.fJmsMessageImpl_propertiesReadOnly.getBoolean(messageObject);
                        }
                    }
                    catch (Exception e) {
                        this.fLogger.debug(kModule, "Keeping default value for propertiesReadOnly field due to " + e.getMessage());
                    }
                    if (!propertiesReadOnly || !javaSecurityEnabled) {
                        if (jmsMessageClassName.equals("com.ibm.jms.JMSMessage") || jmsMessageSuperClassName.equals("com.ibm.jms.JMSMessage") || jmsMessageSuper2ClassName.equals("com.ibm.jms.JMSMessage")) {
                            if (propertiesReadOnly) {
                                if (delegateMessageObject != null) {
                                    MQClassLoaderUtil.fJmsMessageImpl_propertiesReadOnly.setBoolean(delegateMessageObject, false);
                                } else {
                                    MQClassLoaderUtil.fJMSMessage_propertiesReadOnly.setBoolean(messageObject, false);
                                }
                            }
                            MQClassLoaderUtil.mJMSMessage_setStringProperty.invoke(messageObject, "CorIDForSOAPInvocation", correlationString);
                        } else if (jmsMessageClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl") || jmsMessageSuperClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl") || jmsMessageSuper2ClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl")) {
                            if (propertiesReadOnly) {
                                MQClassLoaderUtil.fJmsMessageImpl_propertiesReadOnly.setBoolean(messageObject, false);
                            }
                            MQClassLoaderUtil.mJmsMessageImpl_setStringProperty.invoke(messageObject, "CorIDForSOAPInvocation", correlationString);
                        } else {
                            Method mSetStringProperty = messageObjectClass.getMethod("setStringProperty", String.class, Integer.TYPE);
                            mSetStringProperty.invoke(messageObject, "CorIDForSOAPInvocation", correlationString);
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    javaSecurityEnabled = true;
                    this.fLogger.debug(kModule, "IllegalAccessException: Java Security might be set to TRUE. " + e.getMessage());
                }
                catch (SecurityException e) {
                    javaSecurityEnabled = true;
                    this.fLogger.debug(kModule, "SecurityException: Java Security might be set to TRUE. " + e.getMessage());
                }
                catch (InvocationTargetException e) {
                    javaSecurityEnabled = true;
                    this.fLogger.debug(kModule, "InvocationTargetException: Java Security might be set to TRUE. " + e.getMessage());
                }
                catch (Exception e) {
                    this.fLogger.debug(kModule, "Exception while setting Correaltion Property " + e.getMessage(), (Throwable)e);
                }
                this.fLogger.debug(kModule, "JMS Send CorrelationString = " + correlationString);
            }
        }
    }

    public void ITracer_finishTrace(int arg0, InvocationData data) {
    }
}

