/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake;

import com.wily.powerpack.websphereMQ.agent.extensions.metrics.ActivityReportMetric;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeConstants;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeMQMonitorAgent;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeNotifier;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;

public final class MQMonitorAgentsMonitor
implements HandshakeConstants,
Runnable {
    private IModuleFeedbackChannel logger = null;
    private HashMap mqMonitorAgentNamesMap = new HashMap();
    private static MQMonitorAgentsMonitor mqMonitorAgentsHolder = null;
    private boolean allMQMonitored = false;
    private static boolean no_mqMonitorAgent_configured = true;
    private Collection mqMonitorAgentObjCollection = null;
    private static ActivityReportMetric arMetric = null;

    private MQMonitorAgentsMonitor(IModuleFeedbackChannel logger) {
        this.logger = logger;
        arMetric = ActivityReportMetric.getInstance();
        this.loadMQMonitorAgentDetails();
    }

    public static synchronized MQMonitorAgentsMonitor getInstance(IModuleFeedbackChannel feedback) {
        if (mqMonitorAgentsHolder == null) {
            mqMonitorAgentsHolder = new MQMonitorAgentsMonitor(feedback);
        }
        return mqMonitorAgentsHolder;
    }

    @Override
    public void run() {
        while (true) {
            try {
                this.logger.debug(handshakeModule, "Reloading properties thread going to sleep for 1800000 milliseconds");
                Thread.sleep(1800000L);
                this.logger.debug(handshakeModule, "Reloading properties thread came out of sleep ");
            }
            catch (InterruptedException interruptedException) {}
            this.reloadMQMonitorAgentDetails();
        }
    }

    private void reloadMQMonitorAgentDetails() {
        TraceProperties.getInstance().reload();
        this.loadMQMonitorAgentDetails();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMQMonitorAgentDetails() {
        String mqMonitorAgentList = TraceProperties.HANDSHAKE_MQCLIENT_AGENT_NAMES_VALUE;
        ArrayList<String> mqMonitorAgentNames = null;
        if (mqMonitorAgentList != null && mqMonitorAgentList.length() > 0 && "" != mqMonitorAgentList) {
            this.logger.info(handshakeModule, "Loading MQMonitor agent names: " + mqMonitorAgentList);
            StringBuffer tempMsg = null;
            StringTokenizer st = new StringTokenizer(mqMonitorAgentList, ",");
            if (st != null && st.countTokens() > 0) {
                mqMonitorAgentNames = new ArrayList<String>();
                boolean duplicate = false;
                while (st.hasMoreTokens()) {
                    String id = st.nextToken().trim();
                    int size = mqMonitorAgentNames.size();
                    int k = 0;
                    while (k < size) {
                        if (id.equals(mqMonitorAgentNames.get(k))) {
                            if (tempMsg == null) {
                                tempMsg = new StringBuffer();
                            }
                            duplicate = true;
                            tempMsg.append(id).append(" ");
                        }
                        ++k;
                    }
                    if (duplicate) {
                        duplicate = false;
                        continue;
                    }
                    mqMonitorAgentNames.add(id);
                }
            }
            if (tempMsg != null) {
                this.logger.warn(handshakeModule, "Duplicate ids: " + tempMsg + ". Ensure that all ids are unique and all agent id(s) are given.");
            }
            if (mqMonitorAgentNames != null && mqMonitorAgentNames.size() > 0) {
                HashMap<String, HandshakeMQMonitorAgent> m = new HashMap<String, HandshakeMQMonitorAgent>();
                int i = 0;
                while (i < mqMonitorAgentNames.size()) {
                    String agentName = (String)mqMonitorAgentNames.get(i);
                    HandshakeMQMonitorAgent agentObj = null;
                    if (this.mqMonitorAgentNamesMap == null) {
                        this.mqMonitorAgentNamesMap = new HashMap();
                    }
                    if ((agentObj = (HandshakeMQMonitorAgent)this.mqMonitorAgentNamesMap.get(agentName)) == null) {
                        agentObj = new HandshakeMQMonitorAgent(agentName);
                        agentObj.setAllQMMonitoredFlag(false);
                    }
                    m.put(agentName, agentObj);
                    ++i;
                }
                this.mqMonitorAgentNamesMap = m;
                this.mqMonitorAgentObjCollection = this.mqMonitorAgentNamesMap.values();
                if (MQMonitorAgentsMonitor.isMQMonitorAgentNamesEmpty()) {
                    Integer n = HandshakeNotifier.LOCKOBJECT;
                    synchronized (n) {
                        MQMonitorAgentsMonitor.setMQMonitorAgent_Configured_Flag(false);
                        HandshakeNotifier.LOCKOBJECT.notifyAll();
                    }
                } else {
                    MQMonitorAgentsMonitor.setMQMonitorAgent_Configured_Flag(false);
                }
            }
        } else {
            this.logger.warn(handshakeModule, "\n***********************************************\nNo MQMonitor agent configured for property: mqmonitor.mqagent.id.list in MQAgent.properties. All MQMonitor agents name are required to prevent pilling up of Activity report in case they are not consumed by running MQMonitor agent(s). No value here means that all MQMonitors will always be able to consume activity reports and thus no need for handshake. Keep trace always on. Recommendation: For better control on MQ transaction trace provide MQMonitor(s) handshake.mqagent.id value. This property will be read and reloaded at interval of 1800000 milliseconds.\n***********************************************");
            MQMonitorAgentsMonitor.setMQMonitorAgent_Configured_Flag(true);
            this.logger.info(handshakeModule, "Setting the ALLMQMONITOR flag to True ");
            this.setAllMQMonitored(true, ActivityReportMetric.VALUE_STATUS_MESSAGE_MQMONITORLIST_NOT_SET);
        }
        if (mqMonitorAgentNames == null || mqMonitorAgentNames.size() <= 0) {
            this.mqMonitorAgentNamesMap = null;
            this.mqMonitorAgentObjCollection = null;
        }
    }

    public synchronized void setMQMonitorAgentStatus(String agentName, String statusMsg) {
        boolean newStatusFlag = this.getBooleanEquivalent(statusMsg);
        this.setMQMonitorAgentStatus(agentName, newStatusFlag);
    }

    public synchronized void setMQMonitorAgentStatus(String agentName, boolean newStatusFlag) {
        if (this.mqMonitorAgentNamesMap != null) {
            HandshakeMQMonitorAgent agentObj = (HandshakeMQMonitorAgent)this.mqMonitorAgentNamesMap.get(agentName);
            if (agentObj != null) {
                if (newStatusFlag != agentObj.isAllQMMonitored()) {
                    this.logger.debug(handshakeModule, "Status of MQMonitor agent: " + agentObj.getAgentName() + " was " + agentObj.isAllQMMonitored() + " and new status is " + newStatusFlag + ". So updating the status of MQMonitor agent " + agentObj.getAgentName() + " in the list.");
                    agentObj.setAllQMMonitoredFlagAndTimestamp(newStatusFlag);
                    this.mqMonitorAgentNamesMap.put(agentName, agentObj);
                    this.mqMonitorAgentObjCollection = this.mqMonitorAgentNamesMap.values();
                    this.computeAllQMMonitoredFlag(agentObj);
                } else {
                    this.logger.debug(handshakeModule, "Status of MQMonitor agent: " + agentObj.getAgentName() + " was " + agentObj.isAllQMMonitored() + " and new status is " + newStatusFlag + ". Since there is no change in status of MQMonitor agent " + agentObj.getAgentName() + " hence no point in changing the status in the list.");
                    agentObj.setTimestamp(System.currentTimeMillis());
                }
            } else {
                this.logger.debug(handshakeModule, "Skipping the handshake message received from a  MQMonitor agent: " + agentName + " since this is no more in the my list of MQMonitor agents.");
            }
        } else {
            this.logger.debug(handshakeModule, "Skipping the handshake message received from a  MQMonitor agent: " + agentName + " since this is no more in the my list of MQMonitor agents.");
        }
    }

    private void computeAllQMMonitoredFlag(HandshakeMQMonitorAgent agentObj) {
        boolean isAllQMMonitored = agentObj.isAllQMMonitored();
        if (this.allMQMonitored != isAllQMMonitored) {
            if (this.allMQMonitored && !isAllQMMonitored) {
                this.setAllMQMonitored(false, ActivityReportMetric.VALUE_STATUS_MESSAGE_ALL_QM_NOT_MONITORED);
                this.logger.debug(handshakeModule, "Setting ALLMQMONITOR flag to False ");
            } else {
                boolean allMQMonitoredNow = this.areAllQMsGettingMonitored();
                if (allMQMonitoredNow) {
                    this.setAllMQMonitored(true, ActivityReportMetric.VALUE_STATUS_MESSAGE_ALL_MQMONITOR_RUNNING);
                    this.logger.debug(handshakeModule, "Setting ALLMQMONITOR flag to True ");
                } else {
                    this.logger.debug(handshakeModule, "All MQMonitor Agent status is not True");
                }
            }
        }
    }

    public synchronized void computeAllQMMonitoredFlag() {
        HandshakeMQMonitorAgent[] agentObjs = this.getMQMonitorAgentsArray();
        if (agentObjs != null && agentObjs.length > 0) {
            int i = 0;
            while (i < agentObjs.length) {
                HandshakeMQMonitorAgent agentObj = agentObjs[i];
                if (!agentObj.isAllQMMonitored()) {
                    this.setAllMQMonitored(false, ActivityReportMetric.VALUE_STATUS_MESSAGE_ALL_QM_NOT_MONITORED);
                    return;
                }
                ++i;
            }
            this.setAllMQMonitored(true, ActivityReportMetric.VALUE_STATUS_MESSAGE_ALL_MQMONITOR_RUNNING);
        } else {
            this.setAllMQMonitored(true, ActivityReportMetric.VALUE_STATUS_MESSAGE_MQMONITORLIST_NOT_SET);
        }
    }

    public synchronized HandshakeMQMonitorAgent[] getMQMonitorAgentsArray() {
        if (this.mqMonitorAgentObjCollection != null && this.mqMonitorAgentObjCollection.size() > 0) {
            HandshakeMQMonitorAgent[] oarray;
            int size = this.mqMonitorAgentObjCollection.size();
            HandshakeMQMonitorAgent[] agents = oarray = this.mqMonitorAgentObjCollection.toArray(new HandshakeMQMonitorAgent[size]);
            return agents;
        }
        return null;
    }

    public boolean isAllMQMonitored() {
        return this.allMQMonitored;
    }

    public synchronized void setAllMQMonitored(boolean allQMMonitored, String statusMessage) {
        this.allMQMonitored = allQMMonitored;
        if (this.allMQMonitored) {
            arMetric.setMetric(0, statusMessage);
        } else {
            arMetric.setMetric(1, statusMessage);
        }
    }

    private boolean getBooleanEquivalent(String statusMsg) {
        if (statusMsg != null) {
            return "ALL_QM_MONITORED".equals(statusMsg);
        }
        return false;
    }

    private boolean areAllQMsGettingMonitored() {
        HandshakeMQMonitorAgent[] mqMonitorAgentsArray = this.getMQMonitorAgentsArray();
        if (mqMonitorAgentsArray != null) {
            int i = 0;
            while (i < mqMonitorAgentsArray.length) {
                HandshakeMQMonitorAgent agentObj = mqMonitorAgentsArray[i];
                if (!agentObj.isAllQMMonitored()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean isMQMonitorAgentNamesEmpty() {
        return no_mqMonitorAgent_configured;
    }

    public static void setMQMonitorAgent_Configured_Flag(boolean flag) {
        no_mqMonitorAgent_configured = flag;
    }
}

