/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.intelligent.instrumentation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transformer.TransformerAdministrator;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.probebuilder.intelligent.analysis.ExclusiveExecutionLock;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationConfig;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationProperties;
import com.wily.introscope.probebuilder.intelligent.instrumentation.LevelChangeChecker;
import com.wily.introscope.probebuilder.intelligent.instrumentation.LevelChangeExecutor;

public class IntelligentInstrumentationReloader
implements Runnable {
    IDynamicInstrumentationTransformer dit;
    int start_index;
    int end_index;
    IAgent fAgent;
    int previousInstrumentationLevelInt;
    int currentInstrumentationLevelInt;

    public IntelligentInstrumentationReloader(IAgent fAgent, int start_index, int end_index, int previousInstrumentationLevelInt, int currentInstrumentationLevelInt) {
        this.fAgent = fAgent;
        this.start_index = start_index;
        this.end_index = end_index;
        this.previousInstrumentationLevelInt = previousInstrumentationLevelInt;
        this.currentInstrumentationLevelInt = currentInstrumentationLevelInt;
    }

    @Override
    public void run() {
        TransformerAdministrator tAdm = this.fAgent.IAgent_getTransformerAdministrator();
        IDynamicInstrumentationTransformer dit = tAdm.getDynamicInstrumentationTransformer();
        int x = this.start_index;
        while (x <= this.end_index) {
            dit.getClassRedefinitionDelegate().IClassRedefinitionDelegate_redefine(LevelChangeChecker.allClassesToReload.get(x), null);
            ++x;
        }
        if (this.end_index == LevelChangeChecker.allClassesToReload.size() - 1) {
            LevelChangeChecker.numClassesToReload = 0;
            if (IntelligentInstrumentationConfig.INSTANCE.isDeepTraceSustainabilityMetricsEnabled()) {
                LevelChangeChecker.metricAccumulator.IIntegerCounterDataAccumulator_setValue(LevelChangeChecker.numClassesToReload);
            }
            LevelChangeChecker.batchInProgress = false;
            IntelligentInstrumentationConfig.INSTANCE.getModuleFeedbackChannel().info("Processing level change from " + IntelligentInstrumentationProperties.kInstrumentationLevelValidValues[this.previousInstrumentationLevelInt] + " to " + IntelligentInstrumentationProperties.kInstrumentationLevelValidValues[this.currentInstrumentationLevelInt] + " ended");
            ExclusiveExecutionLock.resetExclusive();
            if (LevelChangeChecker.levelChangedDuringBatching) {
                LevelChangeChecker.levelChangedDuringBatching = false;
                LevelChangeExecutor.scheduleExecutor(this.fAgent);
            }
        }
    }
}

