/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.NumberFormatter;
import com.wily.util.Range;
import com.wily.util.WilyMath;
import com.wily.util.xml.BadlyFormedXMLException;
import com.wily.util.xml.NodeListElementIterator;
import com.wily.util.xml.XMLAssistant;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Scale
implements Externalizable {
    private static final long serialVersionUID = 4648691300105478300L;
    private static final int kFriendlyDecimalPlaces = 1;
    private static final double kFriendlyHeadroom = 0.1;
    private static final String kScaleElementName = "Scale";
    private static final String kScaleMinElementName = "ScaleMin";
    private static final String kScaleMaxElementName = "ScaleMax";
    private static final String kScaleDefaultMinElementName = "ScaleDefaultMin";
    private static final String kScaleDefaultMaxElementName = "ScaleDefaultMax";
    private static final String kScaleAutoExpandMinElementName = "ScaleAutoExpandMin";
    private static final String kScaleAutoExpandMaxElementName = "ScaleAutoExpandMax";
    private static final String kScaleAutoCollapseMinElementName = "ScaleAutoCollapseMin";
    private static final String kScaleAutoCollapseMaxElementName = "ScaleAutoCollapseMax";
    private double fMin = 0.0;
    private double fMax = 10.0;
    private double fDefaultMin = 0.0;
    private double fDefaultMax = 10.0;
    private boolean fAutoExpandMax = true;
    private boolean fAutoExpandMin = true;
    private boolean fAutoCollapseMax = false;
    private boolean fAutoCollapseMin = false;

    public Scale() {
    }

    public Scale(double min, double max) {
        this.fMin = this.fDefaultMin = min;
        this.fMax = this.fDefaultMax = max;
        this.fAutoExpandMax = false;
        this.fAutoExpandMin = false;
        this.fAutoCollapseMax = false;
        this.fAutoCollapseMin = false;
    }

    public Scale(double min, double max, double defaultMin, double defaultMax, boolean autoExpandMin, boolean autoExpandMax, boolean autoCollapseMin, boolean autoCollapseMax) {
        this.fMin = min;
        this.fMax = max;
        this.fDefaultMin = defaultMin;
        this.fDefaultMax = defaultMax;
        this.fAutoExpandMax = autoExpandMax;
        this.fAutoExpandMin = autoExpandMin;
        this.fAutoCollapseMax = autoCollapseMax;
        this.fAutoCollapseMin = autoCollapseMin;
    }

    public Scale(Element element) throws BadlyFormedXMLException {
        NodeListElementIterator scaleElementIterator = new NodeListElementIterator(element);
        Element scaleMinElement = scaleElementIterator.nextXMLElement();
        this.fMin = XMLAssistant.parseDOMElementAsDouble(scaleMinElement, kScaleMinElementName);
        Element scaleMaxElement = scaleElementIterator.nextXMLElement();
        this.fMax = XMLAssistant.parseDOMElementAsDouble(scaleMaxElement, kScaleMaxElementName);
        Element scaleDefaultMinElement = scaleElementIterator.nextXMLElement();
        this.fDefaultMin = XMLAssistant.parseDOMElementAsDouble(scaleDefaultMinElement, kScaleDefaultMinElementName);
        Element scaleDefaultMaxElement = scaleElementIterator.nextXMLElement();
        this.fDefaultMax = XMLAssistant.parseDOMElementAsDouble(scaleDefaultMaxElement, kScaleDefaultMaxElementName);
        Element scaleAutoExpandMinElement = scaleElementIterator.nextXMLElement();
        this.fAutoExpandMin = XMLAssistant.parseDOMElementAsBoolean(scaleAutoExpandMinElement, kScaleAutoExpandMinElementName);
        Element scaleAutoExpandMaxElement = scaleElementIterator.nextXMLElement();
        this.fAutoExpandMax = XMLAssistant.parseDOMElementAsBoolean(scaleAutoExpandMaxElement, kScaleAutoExpandMaxElementName);
        Element scaleAutoCollapseMinElement = scaleElementIterator.nextXMLElement();
        this.fAutoCollapseMin = XMLAssistant.parseDOMElementAsBoolean(scaleAutoCollapseMinElement, kScaleAutoCollapseMinElementName);
        Element scaleAutoCollapseMaxElement = scaleElementIterator.nextXMLElement();
        this.fAutoCollapseMax = XMLAssistant.parseDOMElementAsBoolean(scaleAutoCollapseMaxElement, kScaleAutoCollapseMaxElementName);
    }

    public Object clone() {
        Scale scale = new Scale(this.fMin, this.fMax);
        scale.fDefaultMin = this.fDefaultMin;
        scale.fDefaultMax = this.fDefaultMax;
        scale.fAutoExpandMax = this.fAutoExpandMax;
        scale.fAutoExpandMin = this.fAutoExpandMin;
        scale.fAutoCollapseMax = this.fAutoCollapseMax;
        scale.fAutoCollapseMin = this.fAutoCollapseMin;
        return scale;
    }

    public boolean equals(Object objScale) {
        if (!(objScale instanceof Scale)) {
            return false;
        }
        Scale scale = (Scale)objScale;
        return scale.fMin == this.fMin && scale.fMax == this.fMax && scale.fDefaultMin == this.fDefaultMin && scale.fDefaultMax == this.fDefaultMax && scale.fAutoExpandMax == this.fAutoExpandMax && scale.fAutoExpandMin == this.fAutoExpandMin && scale.fAutoCollapseMax == this.fAutoCollapseMax && scale.fAutoCollapseMin == this.fAutoCollapseMin;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 37 + (this.fAutoExpandMax ? 34573 : 343460);
        hash = hash * 37 + (this.fAutoExpandMin ? 38457 : 340);
        hash = hash * 37 + (this.fAutoCollapseMax ? 47 : 3459);
        hash = hash * 37 + (this.fAutoCollapseMin ? 48762 : 12265);
        hash = hash * 37 + new Double(this.fMin).hashCode();
        hash = hash * 37 + new Double(this.fMax).hashCode();
        hash = hash * 37 + new Double(this.fDefaultMin).hashCode();
        hash = hash * 37 + new Double(this.fDefaultMax).hashCode();
        return hash;
    }

    public void setBounds(int min, int max) {
        this.fMin = min;
        this.fMax = max;
    }

    public void setMin(int min) {
        this.fMin = min;
    }

    public void setMax(int max) {
        this.fMax = max;
    }

    public void setMin(long min) {
        this.fMin = min;
    }

    public void setMax(long max) {
        this.fMax = max;
    }

    public double getMin() {
        return this.fMin;
    }

    public double getMax() {
        return this.fMax;
    }

    public double getBreadth() {
        return this.fMax - this.fMin;
    }

    public void setDefaultMin(int min) {
        this.fDefaultMin = min;
    }

    public void setDefaultMax(int max) {
        this.fDefaultMax = max;
    }

    public void setDefaultMin(long min) {
        this.fDefaultMin = min;
    }

    public void setDefaultMax(long max) {
        this.fDefaultMax = max;
    }

    public double getDefaultMin() {
        return this.fDefaultMin;
    }

    public double getDefaultMax() {
        return this.fDefaultMax;
    }

    public void resetMinToDefault() {
        this.fMin = this.fDefaultMin;
    }

    public void resetMaxToDefault() {
        this.fMax = this.fDefaultMax;
    }

    public void resetToDefault() {
        this.fMin = this.fDefaultMin;
        this.fMax = this.fDefaultMax;
    }

    public void setAutoExpand(boolean autoExpand) {
        this.fAutoExpandMax = this.fAutoExpandMin = autoExpand;
    }

    public void setAutoExpandMax(boolean autoExpandMax) {
        this.fAutoExpandMax = autoExpandMax;
    }

    public void setAutoExpandMin(boolean autoExpandMin) {
        this.fAutoExpandMin = autoExpandMin;
    }

    public void setAutoCollapse(boolean autoCollapse) {
        this.fAutoCollapseMax = this.fAutoCollapseMin = autoCollapse;
    }

    public void setAutoCollapseMax(boolean autoCollapseMax) {
        this.fAutoCollapseMax = autoCollapseMax;
    }

    public void setAutoCollapseMin(boolean autoCollapseMin) {
        this.fAutoCollapseMin = autoCollapseMin;
    }

    public void setAutoScaleMin(boolean autoScale) {
        this.setAutoExpandMin(autoScale);
        this.setAutoCollapseMin(autoScale);
    }

    public void setAutoScaleMax(boolean autoScale) {
        this.setAutoExpandMax(autoScale);
        this.setAutoCollapseMax(autoScale);
    }

    public boolean getAutoExpandMin() {
        return this.fAutoExpandMin;
    }

    public boolean getAutoExpandMax() {
        return this.fAutoExpandMax;
    }

    public boolean getAutoExpandMinDerived() {
        return this.fAutoExpandMin && !this.fAutoCollapseMin;
    }

    public boolean getAutoExpandMaxDerived() {
        return this.fAutoExpandMax && !this.fAutoCollapseMax;
    }

    public boolean getAutoScaleMin() {
        return this.fAutoExpandMin && this.fAutoCollapseMin;
    }

    public boolean getAutoScaleMax() {
        return this.fAutoExpandMax && this.fAutoCollapseMax;
    }

    public boolean getAutoCollapseMin() {
        return this.fAutoCollapseMin;
    }

    public boolean getAutoCollapseMax() {
        return this.fAutoCollapseMax;
    }

    public boolean withinBounds(double value) {
        return this.fMin <= value && this.fMax >= value;
    }

    public void expandScale(double value) {
        if (!this.withinBounds(value)) {
            this.rawExpandScale(value, 0.1);
            this.fMin = WilyMath.roundToDecimal(this.fMin, 1);
            this.fMax = WilyMath.roundToDecimal(this.fMax, 1);
        }
    }

    public void collapseScale(Range range) {
        if (this.rawCollapseScale(range, 0.1)) {
            this.fMin = WilyMath.roundToDecimal(this.fMin, 1);
            this.fMax = WilyMath.roundToDecimal(this.fMax, 1);
        }
    }

    public void rawExpandScale(double value, double headroom) {
        double max;
        double min = value < 0.0 ? value * (1.0 + headroom) : value * (1.0 - headroom);
        double d = max = value > 0.0 ? value * (1.0 + headroom) : value * (1.0 - headroom);
        if (this.fAutoExpandMin) {
            double d2 = this.fMin = this.fMin < min ? this.fMin : min;
        }
        if (this.fAutoExpandMax) {
            this.fMax = this.fMax > max ? this.fMax : max;
        }
    }

    public boolean rawCollapseScale(Range range, double headroom) {
        double min = range.getLowerBound();
        double max = range.getUpperBound();
        double scaleLength = max - min;
        if (scaleLength == 0.0) {
            scaleLength = 1.0 / headroom;
        }
        min -= scaleLength * headroom;
        max += scaleLength * headroom;
        boolean changed = false;
        if (this.fAutoCollapseMin && min > this.fMin) {
            this.fMin = min;
            changed = true;
        }
        if (this.fAutoCollapseMax && max < this.fMax) {
            this.fMax = max;
            changed = true;
        }
        double minimumSize = 2.0 * (scaleLength * headroom);
        if (changed && this.fMax - this.fMin < minimumSize) {
            if (this.fAutoCollapseMax) {
                this.fMax = this.fMin + minimumSize;
            } else {
                this.fMin = this.fMax - minimumSize;
            }
        }
        return changed;
    }

    public static String getNicelyFormattedString(double value) {
        return Scale.getNicelyFormattedString(value, true, Locale.getDefault());
    }

    public static String getNicelyFormattedString(double value, boolean shorten) {
        return Scale.getNicelyFormattedString(value, shorten, Locale.getDefault());
    }

    public static String getNicelyFormattedString(double value, boolean shorten, Locale locale) {
        if (shorten) {
            if ((double)((long)value) == value) {
                return NumberFormatter.getNumericalApproximationString((long)value, locale);
            }
            return NumberFormatter.getNumericalApproximationString(value, 1, locale);
        }
        if ((double)((long)value) == value) {
            return NumberFormatter.getNumericalString((long)value, locale);
        }
        return NumberFormatter.getNumericalString(value, locale);
    }

    public void doCreateDOMElement(Document doc, Element element) {
        Element scaleElement = doc.createElement(kScaleElementName);
        Element scaleMinElement = XMLAssistant.createDOMElementForDouble(doc, kScaleMinElementName, this.fMin);
        Element scaleMaxElement = XMLAssistant.createDOMElementForDouble(doc, kScaleMaxElementName, this.fMax);
        Element scaleDefaultMinElement = XMLAssistant.createDOMElementForDouble(doc, kScaleDefaultMinElementName, this.fDefaultMin);
        Element scaleDefaultMaxElement = XMLAssistant.createDOMElementForDouble(doc, kScaleDefaultMaxElementName, this.fDefaultMax);
        Element scaleAutoExpandMinElement = XMLAssistant.createDOMElementForBoolean(doc, kScaleAutoExpandMinElementName, this.fAutoExpandMin);
        Element scaleAutoExpandMaxElement = XMLAssistant.createDOMElementForBoolean(doc, kScaleAutoExpandMaxElementName, this.fAutoExpandMax);
        Element scaleAutoCollapseMinElement = XMLAssistant.createDOMElementForBoolean(doc, kScaleAutoCollapseMinElementName, this.fAutoCollapseMin);
        Element scaleAutoCollapseMaxElement = XMLAssistant.createDOMElementForBoolean(doc, kScaleAutoCollapseMaxElementName, this.fAutoCollapseMax);
        scaleElement.appendChild(scaleMinElement);
        scaleElement.appendChild(scaleMaxElement);
        scaleElement.appendChild(scaleDefaultMinElement);
        scaleElement.appendChild(scaleDefaultMaxElement);
        scaleElement.appendChild(scaleAutoExpandMinElement);
        scaleElement.appendChild(scaleAutoExpandMaxElement);
        scaleElement.appendChild(scaleAutoCollapseMinElement);
        scaleElement.appendChild(scaleAutoCollapseMaxElement);
        element.appendChild(scaleElement);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ", min: " + this.fMin + ", max: " + this.fMax + ", defaultMin: " + this.fDefaultMin + ", defaultMax: " + this.fDefaultMax + ", autoExpandMin: " + this.fAutoExpandMin + ", autoExpandMax: " + this.fAutoExpandMax + ", autoCollapseMin: " + this.fAutoCollapseMin + ", autoCollapseMax: " + this.fAutoCollapseMax;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.fMin);
        out.writeDouble(this.fMax);
        out.writeDouble(this.fDefaultMin);
        out.writeDouble(this.fDefaultMax);
        out.writeBoolean(this.fAutoExpandMax);
        out.writeBoolean(this.fAutoExpandMin);
        out.writeBoolean(this.fAutoCollapseMax);
        out.writeBoolean(this.fAutoCollapseMin);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fMin = in.readDouble();
        this.fMax = in.readDouble();
        this.fDefaultMin = in.readDouble();
        this.fDefaultMax = in.readDouble();
        this.fAutoExpandMax = in.readBoolean();
        this.fAutoExpandMin = in.readBoolean();
        this.fAutoCollapseMax = in.readBoolean();
        this.fAutoCollapseMin = in.readBoolean();
    }
}

