/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.io.InputStream;

public class CircularBuffer {
    private final CircularBufferInputStream fInputStream = new CircularBufferInputStream();
    private final int fMinBufferSize;
    private int fBufferSize;
    private int fRollingMaxNumBytesRead;
    private int fRollingTotalNumBytesRead;
    private int fSampleCycleCount;
    private byte[] fBuffer;
    private byte[] fTmpBuffer;
    private int fCurrentReadIndex;
    private int fCurrentWriteIndex;
    private int fStartWriteIndex;
    private int fNumBytesRead;

    public CircularBuffer(int minBufferSize) {
        this.fMinBufferSize = minBufferSize;
        this.fBufferSize = minBufferSize;
        this.fBuffer = new byte[this.fBufferSize];
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public synchronized void fillFromStream(InputStream source) throws IOException {
        int numBytesToRead = source.available();
        int currBufferSize = this.fBuffer.length;
        int numBytesRead = 0;
        if (this.fCurrentReadIndex < 0) {
            byte[] newTmpBuffer = new byte[this.fTmpBuffer.length + numBytesToRead];
            int oldTmpBufferSize = this.fTmpBuffer.length;
            System.arraycopy(this.fTmpBuffer, 0, newTmpBuffer, 0, oldTmpBufferSize);
            numBytesRead = source.read(newTmpBuffer, oldTmpBufferSize, newTmpBuffer.length - oldTmpBufferSize);
            this.fTmpBuffer = newTmpBuffer;
            this.fCurrentReadIndex = -this.fTmpBuffer.length;
        } else {
            boolean isCircularBufferFullFromOverflow = this.isCircularBufferFullFromOverflow(currBufferSize);
            int currWriteIndex = this.fCurrentWriteIndex;
            int numBytesPreviouslyRead = this.fNumBytesRead;
            while (numBytesRead < numBytesToRead) {
                int len;
                int lenToRead;
                if (numBytesRead + numBytesPreviouslyRead == currBufferSize || isCircularBufferFullFromOverflow) {
                    int tmpBufferSize = numBytesToRead - numBytesRead;
                    this.fTmpBuffer = new byte[tmpBufferSize];
                    numBytesRead += source.read(this.fTmpBuffer);
                    this.fCurrentReadIndex = -tmpBufferSize;
                    continue;
                }
                if (this.fCurrentReadIndex < currBufferSize) {
                    if (currWriteIndex <= this.fCurrentReadIndex) {
                        lenToRead = Math.min(currBufferSize - this.fCurrentReadIndex, numBytesToRead - numBytesRead);
                        len = source.read(this.fBuffer, this.fCurrentReadIndex, lenToRead);
                        this.fCurrentReadIndex += len;
                        numBytesRead += len;
                        continue;
                    }
                    lenToRead = Math.min(currWriteIndex - this.fCurrentReadIndex, numBytesToRead - numBytesRead);
                    len = source.read(this.fBuffer, this.fCurrentReadIndex, lenToRead);
                    this.fCurrentReadIndex += len;
                    numBytesRead += len;
                    continue;
                }
                lenToRead = Math.min(currWriteIndex, numBytesToRead - numBytesRead);
                this.fCurrentReadIndex = len = source.read(this.fBuffer, 0, lenToRead);
                numBytesRead += len;
            }
        }
        this.fNumBytesRead += numBytesRead;
    }

    public synchronized void prepare(int overflow) {
        this.fStartWriteIndex = this.fCurrentWriteIndex;
        this.fInputStream.update(overflow);
    }

    public synchronized void compact() {
        int startWriteIndex = this.fStartWriteIndex;
        int currBufferSize = this.fBuffer.length;
        int numOverflowBytes = 0;
        if (this.fCurrentReadIndex > 0 && this.fCurrentWriteIndex > 0) {
            numOverflowBytes = this.fCurrentReadIndex >= this.fCurrentWriteIndex ? this.fCurrentReadIndex - this.fCurrentWriteIndex : currBufferSize - this.fCurrentWriteIndex + this.fCurrentReadIndex;
            Assertion.wilyAssert(this.fTmpBuffer == null, "There should be no tmp buffer.");
            if (this.fSampleCycleCount == 0 && numOverflowBytes == 0 && this.fRollingMaxNumBytesRead > this.fMinBufferSize && 0.75 * (double)currBufferSize > (double)this.fRollingMaxNumBytesRead) {
                this.fBuffer = new byte[this.fRollingMaxNumBytesRead];
                this.fCurrentWriteIndex = 0;
                this.fCurrentReadIndex = 0;
            }
        } else if (this.fCurrentReadIndex < 0 && this.fCurrentWriteIndex < 0) {
            numOverflowBytes = -(this.fCurrentReadIndex - this.fCurrentWriteIndex);
            int newBufferSize = 0;
            newBufferSize = currBufferSize > this.fMinBufferSize && numOverflowBytes <= this.fMinBufferSize ? Math.max(this.fMinBufferSize, this.fRollingMaxNumBytesRead) : (numOverflowBytes > currBufferSize ? Math.max(numOverflowBytes, this.fRollingMaxNumBytesRead) : Math.max(this.fRollingMaxNumBytesRead, currBufferSize));
            if (newBufferSize != currBufferSize) {
                this.fBuffer = new byte[newBufferSize];
            }
            System.arraycopy(this.fTmpBuffer, -this.fCurrentWriteIndex, this.fBuffer, 0, numOverflowBytes);
            this.fTmpBuffer = null;
            this.fCurrentWriteIndex = 0;
            this.fCurrentReadIndex = numOverflowBytes;
        } else if (this.fCurrentReadIndex < 0 && this.fCurrentWriteIndex > 0) {
            boolean hasWrapAround = false;
            if (startWriteIndex < this.fCurrentWriteIndex) {
                numOverflowBytes = currBufferSize - this.fCurrentWriteIndex - this.fCurrentReadIndex;
                if (startWriteIndex > 0) {
                    hasWrapAround = true;
                    numOverflowBytes += startWriteIndex;
                }
            } else {
                numOverflowBytes = startWriteIndex - this.fCurrentWriteIndex - this.fCurrentReadIndex;
            }
            int newBufferSize = Math.max(this.fRollingMaxNumBytesRead, Math.max(numOverflowBytes, this.fMinBufferSize));
            byte[] newBuffer = new byte[newBufferSize];
            if (startWriteIndex < this.fCurrentWriteIndex) {
                int len = currBufferSize - this.fCurrentWriteIndex;
                System.arraycopy(this.fBuffer, this.fCurrentWriteIndex, newBuffer, 0, len);
                if (hasWrapAround) {
                    System.arraycopy(this.fBuffer, 0, newBuffer, len, startWriteIndex);
                    len += startWriteIndex;
                }
                System.arraycopy(this.fTmpBuffer, 0, newBuffer, len, -this.fCurrentReadIndex);
            } else {
                int len = startWriteIndex - this.fCurrentWriteIndex;
                System.arraycopy(this.fBuffer, this.fCurrentWriteIndex, newBuffer, 0, len);
                System.arraycopy(this.fTmpBuffer, 0, newBuffer, len, -this.fCurrentReadIndex);
            }
            this.fTmpBuffer = null;
            this.fBuffer = newBuffer;
            this.fCurrentWriteIndex = 0;
            this.fCurrentReadIndex = numOverflowBytes;
        } else {
            Assertion.wilyAssert(false, "read index cannot be in the circular buffer when write index is in the tmp buffer: fCurrentReadIndex=" + this.fCurrentReadIndex + ", fCurrentWriteIndex=" + this.fCurrentWriteIndex);
        }
        this.sampleNumBytesRead(this.fNumBytesRead);
        this.fNumBytesRead = numOverflowBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String dumpBufferState(int messageCount, int overflow) {
        StringBuffer buffer;
        StringBuffer stringBuffer = buffer = new StringBuffer(180);
        synchronized (stringBuffer) {
            buffer.append("Buffer size=").append(this.fBuffer.length);
            if (this.fTmpBuffer == null) {
                buffer.append(", Tmp Buffer is null");
            } else {
                buffer.append(", Tmp Buffer size=").append(this.fTmpBuffer.length);
            }
            buffer.append(", Current Write Index=").append(this.fCurrentWriteIndex);
            buffer.append(", Current Read Index=").append(this.fCurrentReadIndex);
            buffer.append(", Number of Bytes Read=").append(this.fNumBytesRead);
            buffer.append(", Number of Messages=").append(messageCount);
            buffer.append(", Number of Overflow Bytes=").append(overflow);
        }
        return buffer.toString();
    }

    private boolean isCircularBufferFullFromOverflow(int bufferSize) {
        int numOverFlowBytes = Math.abs(this.fCurrentReadIndex - this.fCurrentWriteIndex);
        return numOverFlowBytes == bufferSize;
    }

    private void sampleNumBytesRead(int currNumberBytesRead) {
        if (++this.fSampleCycleCount == 10) {
            this.fRollingMaxNumBytesRead = this.fRollingTotalNumBytesRead / 10;
            this.fRollingTotalNumBytesRead = 0;
            this.fSampleCycleCount = 0;
        }
        this.fRollingTotalNumBytesRead += currNumberBytesRead;
        this.fRollingMaxNumBytesRead = Math.max(currNumberBytesRead, this.fRollingMaxNumBytesRead);
    }

    public class CircularBufferInputStream
    extends InputStream {
        private int fCurrBufferSize;
        private int fNumBytesToWrite;
        private int fNumBytesWritten;

        public void update(int overflow) {
            this.fCurrBufferSize = CircularBuffer.this.fBuffer.length;
            this.fNumBytesToWrite = CircularBuffer.this.fNumBytesRead - overflow;
            this.fNumBytesWritten = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.fNumBytesWritten < this.fNumBytesToWrite) {
                if (this.fNumBytesWritten >= this.fCurrBufferSize) {
                    CircularBuffer.this.fCurrentWriteIndex = -(this.fNumBytesWritten - this.fCurrBufferSize);
                    ++this.fNumBytesWritten;
                    byte val = CircularBuffer.this.fTmpBuffer[-CircularBuffer.this.fCurrentWriteIndex];
                    CircularBuffer circularBuffer = CircularBuffer.this;
                    circularBuffer.fCurrentWriteIndex = circularBuffer.fCurrentWriteIndex - 1;
                    return val & 0xFF;
                }
                if (CircularBuffer.this.fCurrentWriteIndex == this.fCurrBufferSize) {
                    CircularBuffer.this.fCurrentWriteIndex = 0;
                }
                ++this.fNumBytesWritten;
                byte[] byArray = CircularBuffer.this.fBuffer;
                CircularBuffer circularBuffer = CircularBuffer.this;
                int n = circularBuffer.fCurrentWriteIndex;
                circularBuffer.fCurrentWriteIndex = n + 1;
                return byArray[n] & 0xFF;
            }
            return -1;
        }

        @Override
        public int available() throws IOException {
            return this.fNumBytesToWrite - this.fNumBytesWritten;
        }
    }
}

