/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.dns;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.IEventListener;
import com.wily.introscope.agent.dns.IDnsService;
import com.wily.introscope.agent.service.ASimpleService;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IpAddressDecorationTransactionTraceService
extends ASimpleService
implements IEventListener {
    private IAgent agent;
    private static final String SERVICE_NAME = "IpAddressDecorationTransactionTraceService";
    private Stack<TransactionComponentData> componentStack = new Stack();
    private static String kEnabledPropertyKey = "introscope.agent.transaction.trace.iplookup.enabled";
    private static String kTypePropertyKey = "introscope.agent.transaction.trace.iplookup.type";
    private static String kHostParamPropertyKey = "introscope.agent.transaction.trace.iplookup.hostkey";
    private static String kPatternPropertyKey = "introscope.agent.transaction.trace.iplookup.pattern";
    private static String kGroupNumPropertyKey = "introscope.agent.transaction.trace.iplookup.groupnum";
    private static String kIpParamPropertyKey = "introscope.agent.transaction.trace.iplookup.ipkey";
    private static String kIndexedPropertyKey = "introscope.agent.transaction.trace.iplookup.indexed";
    private static String kSourceIpPropertyKey = "introscope.agent.transaction.trace.iplookup.sourceIp";
    List<PatternEntry> patternList = new ArrayList<PatternEntry>();

    public IpAddressDecorationTransactionTraceService() {
        super(SERVICE_NAME);
        PatternEntry frontEndPattern = new PatternEntry();
        frontEndPattern.type = 1;
        frontEndPattern.indexed = false;
        frontEndPattern.hostParam = "Server Name";
        frontEndPattern.pattern = Pattern.compile(".*");
        frontEndPattern.group = 0;
        frontEndPattern.ipParam = "Server Host IP";
        this.patternList.add(frontEndPattern);
    }

    protected void doStartService(IAgent a, Map parameters) throws Exception {
        this.agent = a;
        boolean isEnabled = this.agent.IAgent_getIndexedProperties().getBooleanProperty(kEnabledPropertyKey, true);
        if (!isEnabled) {
            this.agent.IAgent_getModuleFeedback().info("IpAddressDecorationTransactionTraceService is disabled.");
            return;
        }
        String[] hostParams = this.agent.IAgent_getIndexedProperties().getIndexedProperties(kHostParamPropertyKey);
        int i = 0;
        while (i < hostParams.length) {
            PatternEntry entry = new PatternEntry();
            entry.hostParam = hostParams[i];
            entry.ipParam = this.agent.IAgent_getIndexedProperties().getIndexedProperty(kIpParamPropertyKey, i);
            entry.sourceIpParam = this.agent.IAgent_getIndexedProperties().getIndexedProperty(kSourceIpPropertyKey, i);
            String patternString = this.agent.IAgent_getIndexedProperties().getIndexedProperty(kPatternPropertyKey, i);
            if (!patternString.equals(".*")) {
                entry.pattern = Pattern.compile(patternString);
            }
            String groupString = this.agent.IAgent_getIndexedProperties().getIndexedProperty(kGroupNumPropertyKey, i);
            entry.group = Integer.parseInt(groupString);
            String typeString = this.agent.IAgent_getIndexedProperties().getIndexedProperty(kTypePropertyKey, i);
            entry.type = "frontend".equals(typeString) ? 1 : ("backend".equals(typeString) ? 2 : 0);
            String indexedString = this.agent.IAgent_getIndexedProperties().getIndexedProperty(kIndexedPropertyKey, i);
            if (indexedString != null) {
                entry.indexed = Boolean.parseBoolean(indexedString);
            }
            this.patternList.add(entry);
            ++i;
        }
        this.agent.addTransactionTraceEventPostProcessor(this);
        this.agent.IAgent_getModuleFeedback().info("IpAddressDecorationTransactionTraceService is started.");
    }

    private InetAddress getIPAddressByDnsHostName(String hostName) {
        IDnsService dnsService;
        InetAddress ip = null;
        if (hostName != null && hostName.length() > 0 && this.agent != null && (dnsService = this.agent.IAgent_getDnsService()) != null) {
            ip = dnsService.getIPAddressByDnsHostName(hostName);
        }
        return ip;
    }

    private void addIPAddressByDnsHostName(TransactionComponentData transaction) {
        this.componentStack.clear();
        this.componentStack.push(transaction);
        while (!this.componentStack.isEmpty()) {
            String resource;
            TransactionComponentData component = this.componentStack.pop();
            if (component.getSubNodeCount() > 0) {
                TransactionComponentData[] children;
                TransactionComponentData[] transactionComponentDataArray = children = component.getSubNodes();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    TransactionComponentData child = transactionComponentDataArray[n2];
                    this.componentStack.push(child);
                    ++n2;
                }
            }
            if ((resource = component.getResource()) == null) continue;
            int type = 0;
            type = resource.indexOf("Frontends") == 0 ? 1 : (resource.indexOf("Backends") == 0 ? 2 : 0);
            for (PatternEntry e : this.patternList) {
                if (type != e.type) continue;
                int currentIndex = 0;
                String currentIndexStr = "";
                if (e.indexed) {
                    currentIndex = 1;
                    currentIndexStr = Integer.toString(currentIndex);
                }
                String hostParamValue = component.getParameterValue(String.valueOf(e.hostParam) + currentIndexStr);
                while (hostParamValue != null) {
                    InetAddress ip;
                    String hostName = null;
                    if (e.pattern != null) {
                        Matcher m = e.pattern.matcher(hostParamValue);
                        if (m.matches()) {
                            hostName = m.group(e.group);
                        }
                    } else {
                        hostName = hostParamValue;
                    }
                    if (hostName != null && (ip = this.getIPAddressByDnsHostName(hostName)) != null) {
                        String existingValue = component.getParameterValue(String.valueOf(e.ipParam) + currentIndexStr);
                        if (existingValue == null) {
                            component.setParameterValue(String.valueOf(e.ipParam) + currentIndexStr, ip.getHostAddress());
                        }
                        if (e.sourceIpParam != null) {
                            try {
                                DatagramSocket s = new DatagramSocket();
                                s.connect(ip, 0);
                                existingValue = component.getParameterValue(String.valueOf(e.sourceIpParam) + currentIndexStr);
                                if (existingValue == null) {
                                    component.setParameterValue(String.valueOf(e.sourceIpParam) + currentIndexStr, s.getLocalAddress().getHostAddress());
                                }
                                s.close();
                            }
                            catch (SocketException socketException) {}
                        }
                    }
                    hostParamValue = null;
                    if (!e.indexed) continue;
                    currentIndexStr = Integer.toString(++currentIndex);
                    hostParamValue = component.getParameterValue(String.valueOf(e.hostParam) + currentIndexStr);
                }
            }
        }
    }

    public void noticeEvent(TransactionComponentData root) {
        this.addIPAddressByDnsHostName(root);
    }

    private static class PatternEntry {
        int type;
        String hostParam;
        Pattern pattern;
        int group;
        String ipParam;
        String sourceIpParam;
        boolean indexed;

        private PatternEntry() {
        }
    }
}

