/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.filter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.filter.FilterEncodeHelper;
import com.wily.introscope.agent.filter.FilterMaskEnablerUtil;
import com.wily.introscope.agent.filter.FirstNPerIntervalSampler;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.WrappedInvocationData;
import com.wily.introscope.agent.trace.cas.ITransactionCache;
import com.wily.introscope.agent.trace.hc2.WilyTransactionInstance;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.transactiontrace.FirstNPerIntervalSamplingFilter;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transactiontrace.TransactionCollectStatus;
import com.wily.introscope.agent.transactiontrace.URLSamplingTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.AFailFastTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.AFilterListTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.AndTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.IFailFastTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.IStatefulTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ITailParameterTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.OrTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.adt.SimpleEntry;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;

public class FilterController {
    private static final ConcurrentHashMap fFilters = new ConcurrentHashMap();
    private static final CopyOnWriteArraySet fFilterArray = new CopyOnWriteArraySet();
    private static volatile boolean sDynamicFilterPresence = false;
    private static volatile boolean sTailFilterPresence = false;
    private static volatile boolean sErrorFilterPresence = false;
    private static volatile boolean sTransientHeadFilterPresence = false;
    private static volatile int fComponentCountClamp;
    private static volatile int fHeadFilterClamp;
    private static volatile boolean fTailFilterPropagate;
    private static volatile boolean fSustainabilityMetricEnabled;
    private static volatile long lastFetchedPermanentFilters;
    private static DataAccumulatorFactory dataAccumulator;
    private static final String kTransactionTraceFilterDebugMetricsEnabledProperty = "com.wily.introscope.agent.trace.filter.metrics.enabled";
    private static String sFilterCountMetricName;
    private static volatile HashMap sPermanentFilters;
    private static AtomicInteger transientFilterCount;
    private static final HashMap emptyMap;
    private static final CopyOnWriteArrayList<ISupressTraceFilter> sSupressTraceFilters;

    static {
        fSustainabilityMetricEnabled = false;
        dataAccumulator = null;
        sFilterCountMetricName = "Agent Stats|Sustainability|Transaction Trace Filter:Transient Filter Count";
        sPermanentFilters = new HashMap();
        transientFilterCount = new AtomicInteger(0);
        emptyMap = new HashMap(0);
        sSupressTraceFilters = new CopyOnWriteArrayList();
    }

    public static void addSupressTraceFilter(ISupressTraceFilter filter) {
        sSupressTraceFilters.add(filter);
    }

    public static boolean isTraceSupressed(List<WilyTransactionInstance> trace, TransactionCollectStatus tcs) {
        for (ISupressTraceFilter filter : sSupressTraceFilters) {
            if (!filter.isTraceSupressed(trace, tcs)) continue;
            return true;
        }
        return false;
    }

    public static TransactionCollectStatus updateTransactionCollectStatus(IStackElement data, boolean stopTracingFlag, boolean stopCheckingFlag, int headComponentCount) {
        TransactionCollectStatus tcs = new TransactionCollectStatus();
        SharedCrossProcessData cache = null;
        if (data instanceof InvocationData) {
            cache = ((InvocationData)data).getSharedCrossProcessData();
        }
        if (data instanceof WrappedInvocationData) {
            cache = ((WrappedInvocationData)data).getInvocationData().getSharedCrossProcessData();
        }
        if (cache == null) {
            cache = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
        }
        tcs.cache = cache;
        FilterController.resetTransactionCollectStatusValues(tcs, stopTracingFlag, stopCheckingFlag, headComponentCount);
        data.setTransactionCollectStatus(tcs);
        return tcs;
    }

    public static void resetTransactionCollectStatusValues(TransactionCollectStatus tcs, boolean stopTracingFlag, boolean stopCheckingFlag, int headComponentCount) {
        tcs.stopCheckingFlag = stopCheckingFlag;
        tcs.startedTrackingOnStartTransaction = false;
        tcs.stopTracingFlag = stopTracingFlag;
        tcs.doTraceFlag = false;
        tcs.setSampled(false);
        tcs.setSamplingEvaluated(false);
        tcs.headComponentCount = headComponentCount;
        tcs.fComponentCountInTT = 0;
        tcs.fComponentClampAlreadyHitForTT = false;
        tcs.fTriggerHeadFilterPass = false;
        tcs.filterParameters = new HashMap();
    }

    public static void prepareFiltersForTransaction(TransactionCollectStatus status, IAgent agent) {
        status.stopCheckingFlag = false;
        status.stopTracingFlag = false;
        status.doTraceFlag = false;
        status.setSampled(false);
        status.setSamplingEvaluated(false);
        FilterController.updatePermanentFilters(agent);
        status.addPendingFilters(fFilterArray);
        FilterController.initializePendingFilterStatus(status);
    }

    public static void triggerTxnTraceCollectionAtHeadFilterTime() {
        VirtualStack.getTransactionCache().setfTriggerHeadFilterPass(true);
    }

    public static void resetTxnTraceCollectionAtHeadFilterTime() {
        VirtualStack.getTransactionCache().setfTriggerHeadFilterPass(false);
    }

    public static boolean shouldTraceTransactionInstances() {
        return FilterController.shouldTraceTransaction(VirtualStack.getTransactionCollectStatus());
    }

    public static boolean shouldTraceTransactionInstances(IStackElement data) {
        return FilterController.shouldTraceTransaction(data.getTransactionCollectionStatus());
    }

    public static boolean shouldTraceTransactionInstances(ITransactionCache cache) {
        return FilterController.shouldTraceTransaction(cache.getTransactionCollectionStatus());
    }

    private static boolean shouldTraceTransaction(TransactionCollectStatus tcs) {
        if (tcs == null) {
            tcs = VirtualStack.getTransactionCollectStatus();
        }
        if (tcs != null) {
            return !tcs.stopTracingFlag;
        }
        return true;
    }

    public static void supressTransactionTrace(IStackElement data) {
        FilterController.supressTransactionTrace(data.getTransactionCollectionStatus());
    }

    public static void supressTransactionTrace(ITransactionCache cache) {
        FilterController.supressTransactionTrace(cache.getTransactionCollectionStatus());
    }

    private static void supressTransactionTrace(TransactionCollectStatus tcs) {
        if (tcs == null) {
            tcs = VirtualStack.getTransactionCollectStatus();
        }
        if (tcs != null) {
            tcs.setDoTraceFlag(false);
            tcs.setStopTracingFlag(true);
            tcs.setStopCheckingFlag(true);
            tcs.setSampled(false);
            tcs.setSamplingEvaluated(true);
            tcs.fTriggerHeadFilterPass = false;
        }
    }

    public static final boolean canCurrentTransactionBeMarkedForCollection(ITransactionCache cache) {
        return FilterController.canTransactionBeMarkedForCollection(cache.getTransactionCollectionStatus());
    }

    public static final boolean canCurrentTransactionBeMarkedForCollection(IStackElement data) {
        return FilterController.canTransactionBeMarkedForCollection(data.getTransactionCollectionStatus());
    }

    public static final boolean isCurrentTransactionMarkedForCollection() {
        return FilterController.canTransactionBeMarkedForCollection(VirtualStack.getTransactionCollectStatus());
    }

    private static boolean canTransactionBeMarkedForCollection(TransactionCollectStatus tcs) {
        if (tcs == null) {
            tcs = VirtualStack.getTransactionCollectStatus();
        }
        if (tcs != null) {
            return tcs.getDoTraceFlag();
        }
        return false;
    }

    public static void addFilter(ITransactionTraceFilter filter) {
        FilterController.categorizeAndAddFilter(fFilters, filter);
        for (Map.Entry e : fFilters.entrySet()) {
            if (!fFilterArray.add(new SimpleEntry(e.getKey(), e.getValue()))) continue;
            transientFilterCount.incrementAndGet();
        }
        FilterController.updateHeadAndTailFilterPresenceStatus();
        FilterController.updateErrorFilterPresenceStatus();
        FilterController.updateTransientFilterSustainabilityMetric();
    }

    public static void removeFilter(ITransactionTraceFilter filter) {
        Object value = filter instanceof IFailFastTransactionTraceFilter ? fFilters.remove(filter) : fFilters.remove(new AFailFastTransactionTraceFilter(filter));
        fFilterArray.retainAll(fFilters.entrySet());
        fFilterArray.addAll(sPermanentFilters.entrySet());
        if (value != null) {
            transientFilterCount.decrementAndGet();
        }
        FilterController.updateHeadAndTailFilterPresenceStatus();
        FilterController.updateErrorFilterPresenceStatus();
        FilterController.updateTransientFilterSustainabilityMetric();
    }

    public static boolean shouldCurrentTraceBePropagated() {
        return FilterController.shouldTraceBePropagated(VirtualStack.getTransactionCollectStatus());
    }

    public static boolean shouldCurrentTraceBePropagated(IStackElement data) {
        return FilterController.shouldTraceBePropagated(data.getTransactionCollectionStatus());
    }

    public static boolean shouldCurrentTraceBePropagated(ITransactionCache cache) {
        return FilterController.shouldTraceBePropagated(cache.getTransactionCollectionStatus());
    }

    private static boolean shouldTraceBePropagated(TransactionCollectStatus tcs) {
        if (tcs == null) {
            tcs = VirtualStack.getTransactionCollectStatus();
        }
        if (tcs != null) {
            return tcs.getDoTraceFlag() || !tcs.getStopTracingFlag() && fTailFilterPropagate && FilterController.getTailFilterPresence();
        }
        return false;
    }

    private static void updateHeadAndTailFilterPresenceStatus() {
        sDynamicFilterPresence = false;
        sTailFilterPresence = false;
        sTransientHeadFilterPresence = false;
        Set filterEntries = fFilters.entrySet();
        Iterator itr = filterEntries.iterator();
        while (itr.hasNext()) {
            sDynamicFilterPresence = true;
            Map.Entry entry = itr.next();
            Object filter = entry.getKey();
            if (((ITransactionTraceFilter)filter).isHeadFilter()) {
                sTransientHeadFilterPresence = true;
            } else {
                sTailFilterPresence = true;
            }
            if (!sTransientHeadFilterPresence || !sTailFilterPresence) continue;
            return;
        }
    }

    private static void updateErrorFilterPresenceStatus() {
        Set filterEntries = fFilters.entrySet();
        for (Map.Entry entry : filterEntries) {
            Object filter = entry.getKey();
            int type = ((ITransactionTraceFilter)filter).ITransactionTraceFilter_getFilterType();
            if (type != 4) continue;
            sErrorFilterPresence = true;
            return;
        }
        sErrorFilterPresence = false;
    }

    public static boolean getDynamicFilterPresence() {
        return sDynamicFilterPresence;
    }

    public static boolean getTailFilterPresence() {
        return sTailFilterPresence;
    }

    public static boolean getPermanentFilterMayBePresent(IAgent agent) {
        long lastPermanentFiltersUpdated = agent.IAgent_getTransactionTraceController().getLastUpdatedPermanentFilters();
        return sPermanentFilters.size() > 0 || lastFetchedPermanentFilters < lastPermanentFiltersUpdated;
    }

    public static boolean getErrorFilterPresence() {
        return sErrorFilterPresence;
    }

    public static boolean getTransientHeadFilterPresence() {
        return sTransientHeadFilterPresence;
    }

    private static void categorizeAndAddFilter(Map filterMap, ITransactionTraceFilter filter) {
        long encoding = FilterEncodeHelper.getFilterEncoding(filter);
        if (filter instanceof IFailFastTransactionTraceFilter) {
            filterMap.put(filter, new Long(encoding));
        } else {
            filterMap.put(new AFailFastTransactionTraceFilter(filter), new Long(encoding));
        }
    }

    public static Boolean samplingExecute(long filterEnablerKey, IAgent agent) {
        if (FilterMaskEnablerUtil.checkIfFilterBitEnabledInField(4L, filterEnablerKey)) {
            return FirstNPerIntervalSampler.shouldSample();
        }
        return null;
    }

    public static boolean errorFilterExecute(TransactionComponentData root) {
        boolean ret = false;
        if (sErrorFilterPresence) {
            Set filterEntries = fFilters.entrySet();
            for (Map.Entry entry : filterEntries) {
                Object filter = entry.getKey();
                int type = ((ITransactionTraceFilter)filter).ITransactionTraceFilter_getFilterType();
                if (type != 4 || !((ITransactionTraceFilter)filter).ITransactionTraceFilter_passesFilter(root)) continue;
                return true;
            }
        }
        return ret;
    }

    public static boolean optimisticFilterExecute(long filterEnablerKey, TransactionCollectStatus tcs, IStackElement data, IAgent agent) {
        Map.Entry[] filterEntries = tcs.getPendingFilters();
        Object[] filterStatus = tcs.getPendingFilterStatus();
        if (!tcs.anyPendingHeadFilters()) {
            return false;
        }
        Map parameters = tcs.getParameters(data);
        VirtualStack.addParameterCallbacks(parameters, data);
        int i = 0;
        while (i < filterEntries.length) {
            Map.Entry entry = filterEntries[i];
            if (entry != null) {
                Boolean headFilterResult;
                IFailFastTransactionTraceFilter filter = (IFailFastTransactionTraceFilter)entry.getKey();
                Object filterEncodeObj = entry.getValue();
                long filterencoding = (Long)filterEncodeObj;
                if (!filter.isHeadFilter()) {
                    if (filter instanceof AndTransactionTraceFilter) {
                        if (FilterMaskEnablerUtil.checkIfFilterBitEnabledInField(filterencoding, filterEnablerKey) && (headFilterResult = FilterController.shouldCollectHead(filter, parameters, filterStatus[i])) != null) {
                            if (headFilterResult.booleanValue()) {
                                tcs.addFilterForTailCheck(filter);
                                tcs.removePendingHeadFilter(i);
                            } else {
                                tcs.removePendingHeadFilter(i);
                            }
                        }
                    } else if (filter instanceof OrTransactionTraceFilter) {
                        if (FilterMaskEnablerUtil.checkIfFilterBitEnabledInField(filterencoding, filterEnablerKey) && (headFilterResult = FilterController.shouldCollectHead(filter, parameters, filterStatus[i])) != null) {
                            if (headFilterResult.booleanValue()) {
                                return true;
                            }
                            tcs.addFilterForTailCheck(filter);
                            tcs.removePendingHeadFilter(i);
                        }
                    } else {
                        tcs.addFilterForTailCheck(filter);
                        tcs.removePendingHeadFilter(i);
                    }
                } else if (FilterMaskEnablerUtil.checkIfFilterBitEnabledInField(filterencoding, filterEnablerKey) && (headFilterResult = FilterController.shouldCollectHead(filter, parameters, filterStatus[i])) != null) {
                    if (headFilterResult.booleanValue()) {
                        return true;
                    }
                    tcs.removePendingHeadFilter(i);
                }
            }
            ++i;
        }
        return false;
    }

    private static boolean updatePermanentFilters(IAgent agent) {
        long lastPermanentFiltersUpdated = agent.IAgent_getTransactionTraceController().getLastUpdatedPermanentFilters();
        if (lastFetchedPermanentFilters < lastPermanentFiltersUpdated) {
            lastFetchedPermanentFilters = lastPermanentFiltersUpdated;
            Set permanentFiltersSet = agent.IAgent_getTransactionTraceController().getPermanentFilters();
            ArrayList permanentFiltersWeWantToConsider = new ArrayList();
            for (Object o : permanentFiltersSet) {
                if (o instanceof FirstNPerIntervalSamplingFilter || o instanceof URLSamplingTransactionTraceFilter) continue;
                permanentFiltersWeWantToConsider.add(o);
            }
            HashMap newPermanentFilters = new HashMap();
            int j = 0;
            while (j < permanentFiltersWeWantToConsider.size()) {
                FilterController.categorizeAndAddFilter(newPermanentFilters, (ITransactionTraceFilter)permanentFiltersWeWantToConsider.get(j));
                ++j;
            }
            sPermanentFilters = newPermanentFilters;
            fFilterArray.retainAll(fFilters.entrySet());
            fFilterArray.addAll(sPermanentFilters.entrySet());
        }
        return sPermanentFilters.size() > 0;
    }

    private static void initializePendingFilterStatus(TransactionCollectStatus tcs) {
        Map.Entry[] filterEntries = tcs.getPendingFilters();
        if (filterEntries == null) {
            return;
        }
        Object[] filterStatus = tcs.getPendingFilterStatus();
        int i = 0;
        while (i < filterEntries.length && i < filterStatus.length) {
            Object filter;
            Map.Entry filterEntry = filterEntries[i];
            if (filterEntry != null && (filter = filterEntries[i].getKey()) instanceof IStatefulTransactionTraceFilter) {
                filterStatus[i] = ((IStatefulTransactionTraceFilter)filter).initializeFilterState(filterStatus[i]);
            }
            ++i;
        }
    }

    private static Boolean shouldCollectHead(IFailFastTransactionTraceFilter filter, Map parameters, Object status) {
        if (filter instanceof IStatefulTransactionTraceFilter) {
            return ((IStatefulTransactionTraceFilter)((Object)filter)).shouldCollectHead(parameters, status);
        }
        return filter.shouldCollectHead(parameters);
    }

    private static boolean shouldCollectFinal(IFailFastTransactionTraceFilter filter, Object status) {
        if (filter instanceof IStatefulTransactionTraceFilter) {
            return ((IStatefulTransactionTraceFilter)((Object)filter)).shouldCollectFinal(status);
        }
        return filter.shouldCollectFinal();
    }

    public static boolean finalFiltersExecute(TransactionCollectStatus tcs) {
        Map.Entry[] filterEntries = tcs.getPendingFilters();
        Object[] filterStatus = tcs.getPendingFilterStatus();
        if (!tcs.anyPendingHeadFilters()) {
            return false;
        }
        int i = 0;
        while (i < filterEntries.length) {
            Map.Entry entry = filterEntries[i];
            if (entry != null) {
                boolean headFilterResult;
                IFailFastTransactionTraceFilter filter = (IFailFastTransactionTraceFilter)entry.getKey();
                if (!filter.isHeadFilter()) {
                    if (filter instanceof AndTransactionTraceFilter) {
                        headFilterResult = FilterController.shouldCollectFinal(filter, filterStatus[i]);
                        if (headFilterResult) {
                            tcs.addFilterForTailCheckIfMissing(filter);
                        }
                    } else if (filter instanceof OrTransactionTraceFilter) {
                        headFilterResult = FilterController.shouldCollectFinal(filter, filterStatus[i]);
                        if (headFilterResult) {
                            return true;
                        }
                        tcs.addFilterForTailCheckIfMissing(filter);
                    }
                } else {
                    headFilterResult = FilterController.shouldCollectFinal(filter, filterStatus[i]);
                    if (headFilterResult) {
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean pessimisticLegacyFiltersExecute(TransactionComponentData rootTcdData, TransactionCollectStatus tcs) {
        if (!tcs.anyPendingTailFilters()) {
            return false;
        }
        ITransactionTraceFilter[] filters = tcs.getFiltersForTailCheck();
        if (filters == null || filters.length == 0) {
            return false;
        }
        boolean filterResult = false;
        int i = 0;
        while (i < filters.length) {
            ITransactionTraceFilter filter = filters[i];
            if (filter != null && (filterResult = filter instanceof AFilterListTransactionTraceFilter ? ((AFilterListTransactionTraceFilter)filter).passesTailFilter(rootTcdData) : filter.ITransactionTraceFilter_passesFilter(rootTcdData))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean pessimisticFiltersExecute(TransactionCollectStatus tcs) {
        if (!tcs.anyPendingTailFilters()) {
            return false;
        }
        ITransactionTraceFilter[] filters = tcs.getFiltersForTailCheck();
        if (filters == null || filters.length == 0) {
            return false;
        }
        boolean filterResult = false;
        int i = 0;
        while (i < filters.length) {
            boolean isFilterProcessed = false;
            ITransactionTraceFilter filter = filters[i];
            if (filter != null) {
                if (filter instanceof AFilterListTransactionTraceFilter) {
                    if (!((AFilterListTransactionTraceFilter)filter).hasCustomLegacyTailFilter()) {
                        isFilterProcessed = true;
                        filterResult = ((ITailParameterTransactionTraceFilter)((Object)filter)).ITailParameterTransactionTraceFilter_passesFilter(tcs.getFilterParameters());
                    }
                } else if (filter instanceof AFailFastTransactionTraceFilter && !((AFailFastTransactionTraceFilter)filter).hasCustomLegacyTailFilter()) {
                    isFilterProcessed = true;
                    filterResult = ((AFailFastTransactionTraceFilter)filter).ITailParameterTransactionTraceFilter_passesFilter(tcs.getFilterParameters());
                }
                if (filterResult) {
                    return true;
                }
                if (isFilterProcessed) {
                    tcs.removePendingTailFilter(i);
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean pessimisticLegacyFiltersExecute(TransactionComponentData rootTcdData) {
        if (sDynamicFilterPresence) {
            Set filterEntries = fFilters.entrySet();
            for (Map.Entry entry : filterEntries) {
                ITransactionTraceFilter filter = (ITransactionTraceFilter)entry.getKey();
                boolean filterResult = filter.ITransactionTraceFilter_passesFilter(rootTcdData);
                if (!filterResult) continue;
                return true;
            }
        }
        return false;
    }

    public static int getComponentCountLimit() {
        return fComponentCountClamp;
    }

    public static int getHeadFilterComponentLimit() {
        return fHeadFilterClamp;
    }

    private static boolean isSustainabilityMetricsEnabled() {
        return fSustainabilityMetricEnabled;
    }

    private static void updateTransientFilterSustainabilityMetric() {
        if (dataAccumulator != null && FilterController.isSustainabilityMetricsEnabled()) {
            dataAccumulator.safeGetIntegerFluctuatingCounterDataAccumulator(sFilterCountMetricName).IIntegerCounterDataAccumulator_setValue(transientFilterCount.intValue());
        }
    }

    public static void init(IAgent agent) {
        ConfigurationManager cm = agent.IAgent_getConfigurationManager();
        if (cm != null) {
            FilterController.defineConfigurationProperties(cm, agent.IAgent_getModule(), agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
            if (dataAccumulator == null) {
                dataAccumulator = agent.IAgent_getDataAccumulatorFactory();
            }
        } else {
            agent.IAgent_getModuleFeedback().warn("Filter Controller properties could not be initialized because the configuration manager was not found");
        }
    }

    private static void defineConfigurationProperties(ConfigurationManager configManager, Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        configManager.add(new PositiveIntegerConfigurationProperty("introscope.agent.transactiontrace.componentCountClamp", new Integer(5000), "TT_Component_Count_Limit", feedback, module, localizer){

            @Override
            public void set(Object value) {
                fComponentCountClamp = (Integer)value;
            }
        });
        configManager.add(new PositiveIntegerConfigurationProperty("introscope.agent.transactiontrace.headFilterClamp", new Integer(30), "TT_Head_Filter_Limit", feedback, module, localizer){

            @Override
            public void set(Object value) {
                fHeadFilterClamp = (Integer)value;
                WilyTransactionStructure.fHeadFilterClampEventLogged = false;
            }
        });
        configManager.add(new BooleanConfigurationProperty("introscope.agent.transactiontracer.tailfilterPropagate.enable", new Boolean(true), feedback, module, localizer){

            @Override
            public void set(Object value) {
                fTailFilterPropagate = (Boolean)value;
            }
        });
        configManager.add(new BooleanConfigurationProperty(kTransactionTraceFilterDebugMetricsEnabledProperty, Boolean.FALSE, feedback, module, localizer){

            @Override
            public void set(Object value) {
                fSustainabilityMetricEnabled = (Boolean)value;
                FilterController.updateTransientFilterSustainabilityMetric();
            }
        });
    }

    public static interface ISupressTraceFilter {
        public boolean isTraceSupressed(List<WilyTransactionInstance> var1, TransactionCollectStatus var2);
    }
}

