/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.probe.net;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.BlameStackAnnotationHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.IBlameStackAnnotator;
import com.wily.introscope.agent.LazyMetricNameProvider;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.probe.net.DefaultBackendFeatureFactory;
import com.wily.introscope.agent.probe.net.ManagedSocketMapHelper;
import com.wily.introscope.agent.probe.net.ServerSocketMonitor;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.IndexedProperties;
import com.wily.wilyassert.Assertion;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SocketMonitor
implements LazyMetricNameProvider {
    private static final int kDefaultFlagForAppMap = 0;
    private static final String kPollerBehaviorName = "SocketMonitor";
    private static final SocketMonitorLock sLock = new SocketMonitorLock();
    private static final SocketMonitor[] kEmptySocketMonitorArray = new SocketMonitor[0];
    private static final IAgent sAgent = SocketMonitor.findAgent();
    private static final ComponentTracer sComponentTracer;
    private static final Map sMonitorCache;
    private static final boolean sReportRateMetrics;
    private static boolean shouldAnnotateTT;
    private static final IBlameStackAnnotator sDefaultBackendBlameStackAnnotator;
    private static boolean runsOnOldConfig;
    private final String fResourceName;
    private final String fBackendResource;
    private String fResourceMapFormat;
    private final IIntegerFluctuatingCounterDataAccumulator fConcurrentWriters;
    private final IIntegerFluctuatingCounterDataAccumulator fConcurrentReaders;
    private final ILongIntervalCounterDataAccumulator fOpensPerInterval;
    private final ILongIntervalCounterDataAccumulator fClosesPerInterval;
    private final IIntegerRateDataAccumulator fInputRate;
    private final IIntegerRateDataAccumulator fOutputRate;
    private int fConcurrentReadersCounter = 0;
    private int fConcurrentWritersCounter = 0;
    private final String fHost;
    private final InetAddress fAddress;
    private final InetAddress fLocalAddress;
    private final int fPort;
    private static final String kResourceHostPrefixForMap = "System ";
    private static final String kResourcePortPrefixForMap = " on port ";

    static {
        shouldAnnotateTT = sAgent == null ? false : sAgent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.sockets.reportInTT", true);
        sComponentTracer = sAgent == null ? null : sAgent.IAgent_getComponentTracer();
        runsOnOldConfig = sComponentTracer == null ? false : sComponentTracer.isAgentOldMode();
        sMonitorCache = new HashMap();
        sReportRateMetrics = SocketMonitor.calculateReportRateMetrics(sAgent);
        sDefaultBackendBlameStackAnnotator = BlameStackAnnotationHelper.getBlameStackAnnotator(BlameStackAnnotationHelper.kDefaultBackendBlameStackAnnotator);
        SocketMonitor.initializePoller(sAgent);
        ManagedSocketMapHelper.initializeIfNeccessary();
    }

    private static final IAgent findAgent() {
        try {
            return AgentShim.getAgent();
        }
        catch (AgentNotAvailableException anae) {
            try {
                AgentShim.handleError("Unable to gather socket data because the Agent is not available", anae);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {}
            return null;
        }
    }

    private static final boolean calculateReportRateMetrics(IAgent agent) {
        boolean result = false;
        if (agent != null) {
            IndexedProperties properties = agent.IAgent_getIndexedProperties();
            if (properties != null) {
                result = properties.safeGetBooleanProperty("introscope.agent.sockets.reportRateMetrics", agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
            }
            agent.IAgent_getModuleFeedback().debug("Report rate metrics configured to " + result);
        }
        return result;
    }

    private static final void initializePoller(IAgent agent) {
        if (agent != null) {
            agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)new ConcurrentMetricPoller(), kPollerBehaviorName, true, 7500L, false);
        }
    }

    private static final SocketMonitorLock getSocketMonitorLock() {
        return sLock;
    }

    private final synchronized void decrementConcurrentReadersCounter() {
        --this.fConcurrentReadersCounter;
    }

    private final synchronized void decrementConcurrentWritersCounter() {
        --this.fConcurrentWritersCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final SocketMonitor getClientSocketMonitor(String host, InetAddress addr, int port) {
        if (host == null || host.equals("")) {
            host = "Unknown Host";
        }
        SocketMonitorKey key = new SocketMonitorKey(host, port);
        SocketMonitor monitor = null;
        SocketMonitorLock socketMonitorLock = SocketMonitor.getSocketMonitorLock();
        synchronized (socketMonitorLock) {
            monitor = (SocketMonitor)sMonitorCache.get(key);
            if (monitor == null) {
                monitor = new SocketMonitor(host, addr, port);
                sMonitorCache.put(key, monitor);
            }
        }
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final ServerSocketMonitor getServerSocketMonitor(int port) {
        SocketMonitorKey key = new SocketMonitorKey(port);
        ServerSocketMonitor monitor = null;
        SocketMonitorLock socketMonitorLock = SocketMonitor.getSocketMonitorLock();
        synchronized (socketMonitorLock) {
            monitor = (ServerSocketMonitor)sMonitorCache.get(key);
            if (monitor == null) {
                monitor = new ServerSocketMonitor(port);
                sMonitorCache.put(key, monitor);
            }
        }
        return monitor;
    }

    public SocketMonitor(String host, int port) {
        this(host, null, port);
    }

    public SocketMonitor(String host, InetAddress addr, int port) {
        this(host, addr, null, port);
    }

    public SocketMonitor(String host, InetAddress addr, InetAddress local, int port) {
        this.fHost = host;
        this.fPort = port;
        this.fAddress = addr;
        this.fLocalAddress = local;
        this.fResourceName = this.calculateResourceName(host, port);
        this.fBackendResource = this.calculateBackendResource(host, port);
        DataAccumulatorFactory factory = this.getDataAccumulatorFactory();
        this.fConcurrentReaders = this.createConcurrentReadersAccumulator(factory);
        this.fConcurrentWriters = this.createConcurrentWritersAccumulator(factory);
        this.fOpensPerInterval = this.createOpensPerIntervalAccumulator(factory);
        this.fClosesPerInterval = this.createClosesPerIntervalAccumulator(factory);
        this.fInputRate = this.createInputRateAccumulator(factory);
        this.fOutputRate = this.createOutputRateAccumulator(factory);
        if (this.shouldAddToMap()) {
            this.fResourceMapFormat = this.calculateResourceMapFormat(host, port);
            ManagedSocketMapHelper.reEvaluateLogLevel();
        }
    }

    protected final DataAccumulatorFactory getDataAccumulatorFactory() {
        return sAgent == null ? null : sAgent.IAgent_getDataAccumulatorFactory();
    }

    protected final String getResourceName() {
        return this.fResourceName;
    }

    protected String getBackendResource() {
        return this.fBackendResource;
    }

    protected String getResourceMapFormat() {
        return this.fResourceMapFormat;
    }

    protected String calculateResourceMapFormat(String host, int port) {
        String hostName = host;
        if (host == null || host.equals("")) {
            hostName = "localhost";
        }
        return kResourceHostPrefixForMap + hostName + kResourcePortPrefixForMap + port;
    }

    protected String calculateResourceName(String host, int port) {
        int index = host.indexOf(58);
        if (index != -1) {
            host = host.replace(':', '-');
        }
        return "Sockets|Client|" + host + "|" + "Port" + " " + port;
    }

    protected String calculateBackendResource(String host, int port) {
        String hostName = host;
        if (host == null || host.equals("")) {
            hostName = "localhost";
        } else {
            int index = hostName.indexOf(58);
            if (index != -1) {
                hostName = hostName.replace(':', '-');
            }
        }
        return "Backends|System " + hostName + kResourcePortPrefixForMap + port;
    }

    private final IIntegerFluctuatingCounterDataAccumulator createConcurrentReadersAccumulator(DataAccumulatorFactory factory) {
        if (factory != null) {
            return factory.safeGetIntegerFluctuatingCounterDataAccumulator(String.valueOf(this.getResourceName()) + ":" + "Concurrent Readers");
        }
        return null;
    }

    private final IIntegerFluctuatingCounterDataAccumulator createConcurrentWritersAccumulator(DataAccumulatorFactory factory) {
        if (factory != null) {
            return factory.safeGetIntegerFluctuatingCounterDataAccumulator(String.valueOf(this.getResourceName()) + ":" + "Concurrent Writers");
        }
        return null;
    }

    private final ILongIntervalCounterDataAccumulator createOpensPerIntervalAccumulator(DataAccumulatorFactory factory) {
        if (factory != null) {
            return factory.safeGetLongIntervalCounterDataAccumulator(String.valueOf(this.getResourceName()) + ":" + "Opens Per Interval");
        }
        return null;
    }

    private final ILongIntervalCounterDataAccumulator createClosesPerIntervalAccumulator(DataAccumulatorFactory factory) {
        if (factory != null) {
            return factory.safeGetLongIntervalCounterDataAccumulator(String.valueOf(this.getResourceName()) + ":" + "Closes Per Interval");
        }
        return null;
    }

    private final IIntegerRateDataAccumulator createInputRateAccumulator(DataAccumulatorFactory factory) {
        if (factory != null && sReportRateMetrics) {
            return factory.safeGetIntegerRateDataAccumulator(String.valueOf(this.getResourceName()) + ":" + "Input Bandwidth (Bytes Per Second)");
        }
        return null;
    }

    private final IIntegerRateDataAccumulator createOutputRateAccumulator(DataAccumulatorFactory factory) {
        if (factory != null && sReportRateMetrics) {
            return factory.safeGetIntegerRateDataAccumulator(String.valueOf(this.getResourceName()) + ":" + "Output Bandwidth (Bytes Per Second)");
        }
        return null;
    }

    public final void eventOpen() {
        if (this.shouldMeter(this.fOpensPerInterval)) {
            this.fOpensPerInterval.ILongIntervalCounterDataAccumulator_addSingleIncident();
        }
    }

    public final void eventClose() {
        if (this.shouldMeter(this.fClosesPerInterval)) {
            this.fClosesPerInterval.ILongIntervalCounterDataAccumulator_addSingleIncident();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int eventStartRead(InvocationData data, boolean alsoDoAppMap) {
        int result = 0;
        this.annotateBlameStack("Socket read", data, alsoDoAppMap);
        String resourceName = this.getResourceMapFormat();
        if (resourceName != null && this.shouldAddToMap() && alsoDoAppMap) {
            result = ManagedSocketMapHelper.addToAppMapIfEnabled(resourceName);
        }
        SocketMonitor socketMonitor = this;
        synchronized (socketMonitor) {
            ++this.fConcurrentReadersCounter;
        }
        return result;
    }

    public final int eventStartRead() {
        return this.eventStartRead(null, true);
    }

    private void annotateBlameStack(String title, InvocationData data, boolean alsoDoAppMap) {
        if (runsOnOldConfig) {
            if (shouldAnnotateTT && !DefaultBackendFeatureFactory.getFeatureForCurrentThread().backendWasTouchedInMostRecentBlameFrame()) {
                sComponentTracer.addExtraParameter(title, this.getResourceName());
                String backendResource = this.getBackendResource();
                if (backendResource != null) {
                    DefaultBackendFeatureFactory.getFeatureForCurrentThread().setDefaultBackend(this.getBackendResource(), this.fHost, this.fPort);
                }
            }
        } else if (shouldAnnotateTT && sDefaultBackendBlameStackAnnotator != null) {
            this.delegateAnnotateBlameStack(this, this, data, alsoDoAppMap);
        }
    }

    protected void delegateAnnotateBlameStack(Object key, LazyMetricNameProvider lazyMetricNameProvider, InvocationData data, boolean alsoDoAppMap) {
        String address = this.fAddress == null ? null : this.fAddress.getHostAddress();
        String localAddress = this.fLocalAddress == null ? null : this.fLocalAddress.getHostAddress();
        sDefaultBackendBlameStackAnnotator.annotateBlameStack((Object)this, localAddress, this.fHost, address, this.fPort, this, data, alsoDoAppMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int eventStartWrite(InvocationData data, boolean alsoDoAppMap) {
        int result = 0;
        this.annotateBlameStack("Socket write", data, alsoDoAppMap);
        String resourceName = this.getResourceMapFormat();
        if (resourceName != null && this.shouldAddToMap() && alsoDoAppMap) {
            result = ManagedSocketMapHelper.addToAppMapIfEnabled(resourceName);
        }
        SocketMonitor socketMonitor = this;
        synchronized (socketMonitor) {
            ++this.fConcurrentWritersCounter;
        }
        return result;
    }

    public final int eventStartWrite() {
        return this.eventStartWrite(null, true);
    }

    public final void eventStopReadWithException(boolean alsoDoAppMap) {
        this.eventStopReadWithException(0, alsoDoAppMap);
    }

    public final void eventStopReadWithException(int addedComponentInfo) {
        this.eventStopReadWithException(addedComponentInfo, true);
    }

    public final void eventStopReadWithException(int addedComponentInfo, boolean alsoDoAppMap) {
        if (alsoDoAppMap) {
            String resourceName = this.getResourceMapFormat();
            ManagedSocketMapHelper.removeFromAppMapIfEnabled(addedComponentInfo, resourceName);
        }
        this.decrementConcurrentReadersCounter();
    }

    public final void eventStopWriteWithException(boolean alsoDoAppMap) {
        this.eventStopWriteWithException(0, alsoDoAppMap);
    }

    public final void eventStopWriteWithException(int addedComponentInfo) {
        this.eventStopWriteWithException(addedComponentInfo, true);
    }

    public final void eventStopWriteWithException(int addedComponentInfo, boolean alsoDoAppMap) {
        if (alsoDoAppMap) {
            String resourceName = this.getResourceMapFormat();
            ManagedSocketMapHelper.removeFromAppMapIfEnabled(addedComponentInfo, resourceName);
        }
        this.decrementConcurrentWritersCounter();
    }

    public final void eventStopRead(int i, boolean alsoDoAppMap) {
        this.eventStopRead(0, i, alsoDoAppMap);
    }

    public final void eventStopRead(int addedComponentInfo, int i) {
        this.eventStopRead(addedComponentInfo, i, true);
    }

    public final void eventStopRead(int addedComponentInfo, int i, boolean alsoDoAppMap) {
        if (alsoDoAppMap) {
            String resourceName = this.getResourceMapFormat();
            ManagedSocketMapHelper.removeFromAppMapIfEnabled(addedComponentInfo, resourceName);
        }
        this.decrementConcurrentReadersCounter();
        if (i > 0 && sReportRateMetrics && this.shouldMeter(this.fInputRate)) {
            BlameStackSnapshot blameStackSnapShot = BlameStackSnapshot.kEmptyBlameStackSnapshot;
            if (sComponentTracer != null) {
                blameStackSnapShot = sComponentTracer.getSnapshot(ComponentTracer.kNoComponent);
            }
            this.fInputRate.IIntegerRateDataAccumulator_addBatchIncidents(i, blameStackSnapShot);
        }
    }

    public final void eventStopWrite(int i, boolean alsoDoAppMap) {
        this.eventStopWrite(0, i, alsoDoAppMap);
    }

    public final void eventStopWrite(int addedComponentInfo, int i) {
        this.eventStopWrite(addedComponentInfo, i, true);
    }

    public final void eventStopWrite(int addedComponentInfo, int i, boolean alsoDoAppMap) {
        if (alsoDoAppMap) {
            String resourceName = this.getResourceMapFormat();
            ManagedSocketMapHelper.removeFromAppMapIfEnabled(addedComponentInfo, resourceName);
        }
        this.decrementConcurrentWritersCounter();
        if (i > 0 && sReportRateMetrics && this.shouldMeter(this.fOutputRate)) {
            BlameStackSnapshot blameStackSnapShot = BlameStackSnapshot.kEmptyBlameStackSnapshot;
            if (sComponentTracer != null) {
                blameStackSnapShot = sComponentTracer.getSnapshot(ComponentTracer.kNoComponent);
            }
            this.fOutputRate.IIntegerRateDataAccumulator_addBatchIncidents(i, blameStackSnapShot);
        }
    }

    private final void pollConcurrentMetrics() {
        if (this.shouldMeter(this.fConcurrentReaders)) {
            this.fConcurrentReaders.IIntegerCounterDataAccumulator_setValue(this.fConcurrentReadersCounter);
        }
        if (this.shouldMeter(this.fConcurrentWriters)) {
            this.fConcurrentWriters.IIntegerCounterDataAccumulator_setValue(this.fConcurrentWritersCounter);
        }
    }

    protected final boolean shouldMeter(IDataAccumulator accumulator) {
        boolean result = false;
        if (accumulator != null) {
            result = !accumulator.IDataAccumulator_isShutOff();
        }
        return result;
    }

    protected boolean shouldAddToMap() {
        return true;
    }

    public String getMetricName(IStackElement data) {
        return this.getBackendResource();
    }

    protected boolean isMonitoringClientSocket() {
        return this.getBackendResource() != null;
    }

    public final boolean suggestStackTraceRecording() {
        if (sAgent != null && sAgent.getBoundaryDetectionTraceRecorder() != null) {
            return sAgent.getBoundaryDetectionTraceRecorder().record();
        }
        return false;
    }

    private static final class ConcurrentMetricPoller
    implements ITimestampedRunnable {
        private ConcurrentMetricPoller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ITimestampedRunnable_execute(long nowInMillis) {
            SocketMonitor[] monitorSnapshot = null;
            try {
                SocketMonitorLock socketMonitorLock = SocketMonitor.getSocketMonitorLock();
                synchronized (socketMonitorLock) {
                    Collection values = sMonitorCache.values();
                    if (values == null) {
                        if (sAgent != null) {
                            sAgent.IAgent_getModuleFeedback().debug("Unable to snapshot SocketMonitor list (values == null)");
                        }
                        return;
                    }
                    monitorSnapshot = values.toArray(kEmptySocketMonitorArray);
                }
                int i = 0;
                while (i < monitorSnapshot.length) {
                    SocketMonitor monitor = monitorSnapshot[i];
                    if (monitor == null) {
                        if (sAgent != null) {
                            sAgent.IAgent_getModuleFeedback().debug("Unexpected null value in SocketMonitor list");
                        }
                    } else {
                        monitor.pollConcurrentMetrics();
                    }
                    ++i;
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    if (sAgent != null) {
                        sAgent.IAgent_safeReportError("A problem occurred while reporting concurrent socket metrics", t);
                    }
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static final class SocketMonitorKey {
        private final String fHost;
        private final int fPort;

        private SocketMonitorKey(int port) {
            this.fHost = null;
            this.fPort = port;
        }

        private SocketMonitorKey(String host, int port) {
            Assertion.wilyAssert(false);
            this.fHost = host;
            this.fPort = port;
        }

        public int hashCode() {
            return (this.fHost == null ? 0 : this.fHost.hashCode()) + this.fPort;
        }

        public boolean equals(Object o) {
            Assertion.wilyAssert(false);
            try {
                SocketMonitorKey key = (SocketMonitorKey)o;
                if (this.fHost == null) {
                    return this.fPort == key.fPort && key.fHost == null;
                }
                return this.fPort == key.fPort && this.fHost.equals(key.fHost);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
    }

    private static final class SocketMonitorLock {
        private SocketMonitorLock() {
        }
    }
}

