/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedMetricHolder;
import com.wily.introscope.agent.trace.cas.IUpdater;
import com.wily.introscope.agent.trace.cas.RepositoryFactory;
import com.wily.introscope.agent.trace.cas.UpdaterFactory;
import com.wily.introscope.agent.trace.hc2.ASingleMetricTracerFactory;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public class OverThresholdPerIntervalCounter
extends ASingleMetricTracerFactory {
    private final int fThresholdInMillis = this.getIntegerParameter("threshold", -1);
    private static final IUpdater kUpdater = UpdaterFactory.getIncreasingUpdater();

    public OverThresholdPerIntervalCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        Assertion.wilyAssert(false);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        data.storeWallClockStartTime();
        super.ITracer_startTrace(tracerIndex, data);
    }

    @Override
    protected IRepository getRepository(InvocationData data, ISharedMetricHolder holder) {
        RepositoryFactory rf = new RepositoryFactory(this.getAgent().IAgent_getDataAccumulatorFactory(), this.fHighConcurrency);
        IRepository rep = rf.safeGetLongIntervalCounterDataAccumulator(this.formatParameterizedName(data), holder);
        return rep;
    }

    @Override
    protected void doOnStartTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }

    @Override
    protected void doOnEndTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
        if (mh == null) {
            return;
        }
        if (data.getWallClockElapsedTime() > (long)this.fThresholdInMillis) {
            long startTime = data.getWallClockStartTime();
            int hashCode = data.hashCode();
            IRepository rep = mh.getRepository();
            if (rep != null) {
                rep.update(kUpdater, 1L, startTime, hashCode);
            }
        }
    }
}

