/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.AutoTracingClampHelper;
import com.wily.introscope.agent.trace.intelligent.AutotraceCrossprocessCacheStacksLimit;
import com.wily.introscope.agent.trace.intelligent.AutotraceCrossprocessDownstreamGuidClamp;
import com.wily.introscope.agent.trace.intelligent.AutotraceCrossprocessUpstreamTimeout;
import com.wily.introscope.agent.trace.intelligent.CrossCorrelationUpstreamGuidsProvider;
import com.wily.introscope.agent.trace.intelligent.CrossProcessAutoTracingConfiguration;
import com.wily.introscope.agent.trace.intelligent.CrossProcessLogger;
import com.wily.introscope.agent.trace.intelligent.DownStreamListenerExecutor;
import com.wily.introscope.agent.trace.intelligent.DownStreamListenerService;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.trace.intelligent.QueueMapCache;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.util.feedback.Module;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class HighPerformanceTransactionCache {
    public static String UPSTREAM_GUID_FILLER = "HighPerformanceTransactionCache.UPSTREAM_GUID_FILLER";
    private IAgent fAgent;
    final AtomicInteger cacheSize = new AtomicInteger(0);
    final AtomicBoolean diagnosticThreadActive = new AtomicBoolean(false);
    long failureCount = 0L;
    private Runnable fDiagnosticsWorker;
    private ScheduledExecutorService fDiagnosticsExecutor;
    private long fDiagnosticsWorkerWaitPeriod;
    private static final long kDefaultCacheDiagnosticsWaitPeriod = 60L;
    private static DownStreamListenerService downStreamListener;
    private static volatile HighPerformanceTransactionCache fInstance;
    ConcurrentLinkedQueue<HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack> fHighPerformanceStacks;
    ConcurrentHashMap<String, HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack> fGUIDToHighPerformanceStackMap;
    ConcurrentHashMap<String, AtomicInteger> fPerGuidCounter;
    ConcurrentLinkedQueue<String> fUpstreamTransactionGUIDs;
    AtomicBoolean fUpstreamQueueDirty = new AtomicBoolean(false);
    AtomicLong fUpstreamQueueTimestamp = new AtomicLong(0L);
    private List kEmptyList = new ArrayList();
    private QueueMapCache<String, Boolean> downtreamGUIDCache;

    static {
        fInstance = null;
    }

    public HighPerformanceTransactionCache(IAgent agent) {
        this.fAgent = agent;
        this.fHighPerformanceStacks = new ConcurrentLinkedQueue();
        this.fGUIDToHighPerformanceStackMap = new ConcurrentHashMap();
        this.fUpstreamTransactionGUIDs = new ConcurrentLinkedQueue();
        this.fPerGuidCounter = new ConcurrentHashMap();
        this.downtreamGUIDCache = new QueueMapCache();
        this.downtreamGUIDCache.initializeQueue(UPSTREAM_GUID_FILLER, AutotraceCrossprocessDownstreamGuidClamp.fValue);
        int i = 0;
        while (i < AutoTracingClampHelper.fClampLimit) {
            this.fUpstreamTransactionGUIDs.add(UPSTREAM_GUID_FILLER);
            ++i;
        }
        this.fDiagnosticsExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setDaemon(true);
                return thread;
            }
        });
        this.fDiagnosticsWorker = new TransactionCacheDiagnostics(this.fAgent);
        this.fDiagnosticsWorkerWaitPeriod = 60L;
    }

    private void init() {
        this.fHighPerformanceStacks.clear();
        this.fGUIDToHighPerformanceStackMap.clear();
        this.fPerGuidCounter.clear();
        this.fUpstreamTransactionGUIDs.clear();
        this.cacheSize.set(0);
        this.fUpstreamQueueDirty.set(false);
        this.fUpstreamQueueTimestamp.set(0L);
        this.downtreamGUIDCache.init();
        this.downtreamGUIDCache.initializeQueue(UPSTREAM_GUID_FILLER, AutotraceCrossprocessDownstreamGuidClamp.fValue);
        int i = 0;
        while (i < AutoTracingClampHelper.fClampLimit) {
            this.fUpstreamTransactionGUIDs.add(UPSTREAM_GUID_FILLER);
            ++i;
        }
    }

    public static HighPerformanceTransactionCache getInstance() {
        return fInstance;
    }

    public static void setInstance(HighPerformanceTransactionCache inst) {
        fInstance = inst;
        CrossCorrelationUpstreamGuidsProvider.setInstance(new CrossCorrelationUpstreamGuidsProvider(inst));
        fInstance.addCrossProcessUpstreamCallback();
    }

    private void addCrossProcessUpstreamCallback() {
        SharedCrossProcessData.addCrossProcessDataCallback(new SharedCrossProcessData.ICrossProcessDataCallBack(){

            @Override
            public void prepareOptionalParameters(SharedCrossProcessData data) {
                data.addParamOut("UpstreamGUIDCache", (ArrayList)CrossCorrelationUpstreamGuidsProvider.getInstance().getParam("UpstreamGUIDCache"));
            }
        });
    }

    public HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack checkout() {
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack stack = this.getNextFromQueue();
        boolean success = this.removeFromGuidCache(stack);
        if (success && CrossProcessLogger.isDebugEnabled()) {
            CrossProcessLogger.logDebugMessage("Downstream agent checked out the deepstack with GUID: " + stack.getTransactionGUID() + " from downstream deepstack cache at: " + System.currentTimeMillis());
        }
        stack.reinit();
        SustainabilityMetricsHelper.reportCheckoutSustainabilityMetrics(1);
        return stack;
    }

    boolean removeFromGuidCache(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack stack) {
        String guid = stack.getTransactionGUID();
        if (guid != null) {
            String key = String.valueOf(guid) + stack.getPerDeepStackGuidIndex();
            this.fGUIDToHighPerformanceStackMap.remove(key);
            this.fPerGuidCounter.remove(guid);
            return true;
        }
        return false;
    }

    public void checkin(String guid, HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack stack) {
        stack.setInUse(false);
        AtomicInteger index = new AtomicInteger(0);
        AtomicInteger existingIndex = this.fPerGuidCounter.putIfAbsent(guid, index);
        if (existingIndex != null) {
            index = existingIndex;
        }
        int i = index.incrementAndGet();
        stack.setPerDeepStackGuidIndex(i);
        stack.setPerGuidCounterRef(index);
        String key = String.valueOf(guid) + i;
        if (CrossProcessLogger.isDebugEnabled()) {
            CrossProcessLogger.logDebugMessage("Downstream agent added the GUID+counter " + key + " to downstream deepstack cache at: " + System.currentTimeMillis());
        }
        this.fGUIDToHighPerformanceStackMap.put(key, stack);
        this.fHighPerformanceStacks.add(stack);
        this.cacheSize.incrementAndGet();
        SustainabilityMetricsHelper.reportCachedTransactionCountSustainabilityMetrics(1);
    }

    public void addToQueue(List<String> listOfGuids) {
        if (listOfGuids != null) {
            for (String guid : listOfGuids) {
                boolean success = this.downtreamGUIDCache.addToQueue(guid, true);
                if (!success || !CrossProcessLogger.isDebugEnabled()) continue;
                CrossProcessLogger.logDebugMessage("Downstream agent added the GUID " + guid + " to downstream guid cache");
            }
        }
    }

    public QueueMapCache<String, Boolean> getDownStreamGUIDCache() {
        return this.downtreamGUIDCache;
    }

    public HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack[] getForTransactionTrace(String guid) {
        AtomicInteger counter;
        String key = String.valueOf(guid) + 1;
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack stack = this.fGUIDToHighPerformanceStackMap.get(key);
        if (stack != null && (counter = stack.getPerGuidCounterRef()) != null) {
            int count = counter.get();
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack[] stackArr = new HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack[count];
            int i = 0;
            while (i < count) {
                key = String.valueOf(guid) + (i + 1);
                stack = this.fGUIDToHighPerformanceStackMap.get(key);
                if (stack == null || !stack.trySetInUse(true)) {
                    int j = 0;
                    while (j < i) {
                        stackArr[j].trySetInUse(false);
                        ++j;
                    }
                    return null;
                }
                stackArr[i] = stack;
                ++i;
            }
            return stackArr;
        }
        return null;
    }

    public boolean GUIDToHighPerformanceStackMapContainsGUID(String guid) {
        return this.fGUIDToHighPerformanceStackMap.contains(guid);
    }

    public void resetStackUse(String guid, HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack stack) {
        if (stack != null) {
            stack.trySetInUse(false);
        }
    }

    private HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack getNextFromQueue() {
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack stack = null;
        boolean bSuccess = false;
        int i = 0;
        int j = this.cacheSize.get();
        int cacheLimit = AutotraceCrossprocessCacheStacksLimit.fValue;
        int cacheUseThreadhold = j * CrossProcessAutoTracingConfiguration.getCrossProcessCacheUsePercent() / 100;
        if (CrossProcessLogger.isDebugEnabled()) {
            CrossProcessLogger.logDebugMessage("HighPerformanceTransactionCache::getNextFromQueue() begins with fHighPerformanceStacks.size()=" + j);
        }
        while (!bSuccess) {
            if (stack != null) {
                this.fHighPerformanceStacks.add(stack);
                this.cacheSize.incrementAndGet();
            }
            if (this.cacheSize.get() < cacheLimit || i == j) {
                if (CrossProcessLogger.isDebugEnabled()) {
                    CrossProcessLogger.logDebugMessage("HighPerformanceTransactionCache::getNextFromQueue() creates a new stack when i=" + i + " j=" + j + " AutotraceCrossprocessCacheElementsLimit=" + AutotraceCrossprocessCacheStacksLimit.fValue);
                }
                stack.fTopStackElement.fStack = stack = new HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack();
                stack.fExceptionElement.fStack = stack;
                stack.prevElement.fStack = stack;
                stack.poppedElement.fStack = stack;
                stack.fMaxResponseTimeElement.fStack = stack;
                bSuccess = stack.trySetInUse(true);
                if (i != j) continue;
                if (CrossProcessLogger.isDebugEnabled()) {
                    CrossProcessLogger.logDebugMessage("Cache is fully in use!");
                }
                this.performCacheDiagnostics();
                continue;
            }
            if (i > cacheUseThreadhold) {
                if (CrossProcessLogger.isDebugEnabled()) {
                    CrossProcessLogger.logDebugMessage("Cache 50% percent or more in use for traces! ");
                }
                this.performCacheDiagnostics();
            }
            if ((stack = this.fHighPerformanceStacks.poll()) != null) {
                bSuccess = stack.trySetInUse(true);
                this.cacheSize.decrementAndGet();
            }
            ++i;
        }
        SustainabilityMetricsHelper.reportCacheQueuePolls(i);
        if (CrossProcessLogger.isDebugEnabled()) {
            CrossProcessLogger.logDebugMessage("HighPerformanceTransactionCache::getNextFromQueue() ends with (stack!=null)?" + (stack != null));
        }
        return stack;
    }

    private void performCacheDiagnostics() {
        if (CrossProcessLogger.isDebugEnabled()) {
            CrossProcessLogger.logDebugMessage("Cache size from counter: " + this.cacheSize.get() + ", actual: " + this.fHighPerformanceStacks.size());
        }
        if (this.diagnosticThreadActive.compareAndSet(false, true)) {
            CrossProcessAutoTracingConfiguration.setCrossProcessAutoTracingEnabled(false);
            ++this.failureCount;
            this.fDiagnosticsExecutor.schedule(this.fDiagnosticsWorker, this.fDiagnosticsWorkerWaitPeriod, TimeUnit.SECONDS);
            this.fAgent.IAgent_getModuleFeedback().debug("Cross Process Deep TT Disabled due very high concurrency. Diagnostics in progress. Feature will be enabled automatically once diagnostics are complete");
        }
    }

    public void addUpstreamGUID(String txGuid) {
        if (CrossProcessLogger.isDebugEnabled()) {
            CrossProcessLogger.logDebugMessage("Upstream agent added the GUID " + txGuid + " to upstream cache");
        }
        this.fUpstreamTransactionGUIDs.add(txGuid);
        this.fUpstreamTransactionGUIDs.poll();
        this.fUpstreamQueueDirty.set(true);
        this.fUpstreamQueueTimestamp.set(System.currentTimeMillis());
        SustainabilityMetricsHelper.reportUpstreamGuidCountSustainabilityMetrics(1);
    }

    public boolean isDirty() {
        return this.fUpstreamQueueDirty.get();
    }

    public List getUpstreamGuids() {
        if (this.isDirty()) {
            if (System.currentTimeMillis() - this.fUpstreamQueueTimestamp.get() > (long)AutotraceCrossprocessUpstreamTimeout.fValue || !CrossProcessAutoTracingConfiguration.isCrossProcessAutoTracingEnabled()) {
                int i = 0;
                while (i < AutoTracingClampHelper.fClampLimit) {
                    this.fUpstreamTransactionGUIDs.add(UPSTREAM_GUID_FILLER);
                    this.fUpstreamTransactionGUIDs.poll();
                    ++i;
                }
                this.fUpstreamQueueDirty.set(false);
                return this.kEmptyList;
            }
            ArrayList<String> list = new ArrayList<String>();
            String[] guids = this.fUpstreamTransactionGUIDs.toArray(new String[0]);
            StringBuffer strBuff = new StringBuffer();
            if (CrossProcessLogger.isDebugEnabled() && guids.length > AutoTracingClampHelper.fClampLimit) {
                CrossProcessLogger.logDebugMessage("Upstream agent GUID list exceeds clamp size :" + guids.length);
            }
            int count = 0;
            int i = guids.length - 1;
            while (i >= 0) {
                if (guids[i] != UPSTREAM_GUID_FILLER) {
                    if (CrossProcessLogger.isDebugEnabled()) {
                        strBuff.append(guids[i]);
                    }
                    if (++count > AutoTracingClampHelper.fClampLimit) break;
                    list.add(guids[i]);
                }
                --i;
            }
            if (CrossProcessLogger.isDebugEnabled()) {
                CrossProcessLogger.logDebugMessage("Upstream agent sending GUID list " + strBuff.toString() + " to downstream cache");
            }
            return list;
        }
        return this.kEmptyList;
    }

    public void clearAll() {
        this.fHighPerformanceStacks.clear();
        this.fGUIDToHighPerformanceStackMap.clear();
        this.cacheSize.set(0);
        this.fPerGuidCounter.clear();
        HighPerformanceIntelligenceStackElement.fCachedProbeInfoNames.clear();
    }

    private int getIncompleteTxnsCount() {
        int useCount = 0;
        for (HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack stack : this.fHighPerformanceStacks) {
            HighPerformanceIntelligenceStackElement elem = (HighPerformanceIntelligenceStackElement)stack.getElementAt(0);
            if (!elem.startedTransaction() || elem.getStartTime() <= elem.getEndTime()) continue;
            ++useCount;
        }
        return useCount;
    }

    public boolean isInDiagonsticsMode() {
        return this.diagnosticThreadActive.get();
    }

    public int getStacksInUseCount() {
        int useCount = 0;
        for (HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack stack : this.fHighPerformanceStacks) {
            if (!stack.isInUse()) continue;
            ++useCount;
        }
        return useCount;
    }

    public static void setDownStreamListenerWorker(DownStreamListenerService worker) {
        downStreamListener = worker;
    }

    public int getCurrentCacheSize() {
        return this.cacheSize.get();
    }

    public ConcurrentLinkedQueue<HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack> getDeepStacksQueue() {
        return this.fHighPerformanceStacks;
    }

    public class TransactionCacheDiagnostics
    implements Runnable {
        IAgent fAgent;
        Module fModule;

        public TransactionCacheDiagnostics(IAgent agent) {
            this.fAgent = agent;
            this.fModule = this.fAgent.IAgent_getModule();
        }

        @Override
        public void run() {
            try {
                this.fAgent.IAgent_getModuleFeedback().debug("Cache Diagnostics - started");
                if (HighPerformanceTransactionCache.this.getIncompleteTxnsCount() > 0) {
                    this.fAgent.IAgent_getModuleFeedback().debug("Transaction cache has deep stacks still incomplete in the cache");
                    return;
                }
                try {
                    if (downStreamListener == null) {
                        HighPerformanceTransactionCache.setDownStreamListenerWorker(DownStreamListenerExecutor.getDownStreamListenerWorker());
                    }
                    downStreamListener.abortHarvest();
                    if (this.fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                        int countInUse = HighPerformanceTransactionCache.this.getStacksInUseCount();
                        this.fAgent.IAgent_getModuleFeedback().debug("Cached Transactions 'in-use' count:" + countInUse);
                    }
                    HighPerformanceTransactionCache.this.init();
                    CrossProcessAutoTracingConfiguration.setCrossProcessAutoTracingEnabled(true);
                    this.fAgent.IAgent_getModuleFeedback().debug("Deep CPTT Cache enabled after diagnostics succeeded");
                }
                catch (Exception e) {
                    this.fAgent.IAgent_getModuleFeedback().debug("Cache Diagnostics Failed! Deep CPTT disabled", e);
                }
            }
            finally {
                HighPerformanceTransactionCache.this.diagnosticThreadActive.set(false);
            }
        }
    }
}

