/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transformer.dynamic;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.AbstractTimestampedCommand;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.spec.server.beans.agent.IAgentBridgeService;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.util.feedback.Module;

public class UpdateDIStatusBehavior
extends AbstractTimestampedCommand {
    private IDynamicInstrumentationTransformer fTransformer;
    private int fCode = Integer.MAX_VALUE;
    private static final String kDIStatusCheckedBehaviorName = "DIStatusCheckBehavior";
    private static final Module kModule = new Module("DIStatusCheckBehavior");

    public UpdateDIStatusBehavior(IAgent agent, IDynamicInstrumentationTransformer transformer) {
        super(agent);
        this.fTransformer = transformer;
    }

    protected void brodcastToAgentBridgeService(IAgentBridgeService service) throws ConnectionException {
        service.handleClientDynamicStatusChanged(this.fCode);
        if (this.getFeedback().isDebugEnabled(kModule)) {
            this.getFeedback().debug(kModule, "Success in broadcasting DI status: " + this.fCode);
        }
    }

    protected boolean checkExecuteCondition() {
        try {
            boolean result;
            boolean forceBroadcast = this.fTransformer.getDynamicInstrumentationService().isForcedBroadcast();
            int newStatus = this.fTransformer.getDynamicInstrumentationStatusCode(false);
            boolean bl = result = newStatus < 0 || forceBroadcast;
            if (this.getFeedback().isTraceEnabled(kModule)) {
                this.getFeedback().trace(kModule, "check if checking status: " + result + "; new status = " + newStatus + "; forceBroadcast = " + forceBroadcast);
            }
            if (forceBroadcast) {
                this.fTransformer.getDynamicInstrumentationService().forceBroadcast();
            }
            return result;
        }
        catch (Exception e) {
            if (this.getFeedback().isTraceEnabled(kModule)) {
                this.getFeedback().trace(kModule, "Exception when checking the DI status", e);
            }
            return false;
        }
    }

    protected boolean executeOnAgent(IAgent agent) {
        int newCode = this.fTransformer.getDynamicInstrumentationStatusCode(true);
        boolean forceBroadcast = this.fTransformer.getDynamicInstrumentationService().isForcedBroadcast();
        if (this.getFeedback().isTraceEnabled(kModule)) {
            this.getFeedback().trace(kModule, "new status: " + newCode + "; old status: " + this.fCode + "; Force broadcasting: " + forceBroadcast);
        }
        if (newCode != this.fCode || forceBroadcast) {
            this.fCode = newCode;
            return true;
        }
        return false;
    }

    protected boolean executeOnAgentWhenRegistered(IAgent agent) {
        int newStatus = this.fTransformer.getDynamicInstrumentationStatusCode(true);
        if (newStatus >= 0) {
            this.fCode = newStatus;
            return true;
        }
        return false;
    }

    protected void onBroadcastSuccess() {
        if (this.getFeedback().isDebugEnabled(kModule)) {
            this.getFeedback().debug(kModule, "Success in broadcasting DI status");
        }
    }

    protected void onRegister() {
        this.fCode = Integer.MAX_VALUE;
        if (this.getFeedback().isDebugEnabled(kModule)) {
            this.getFeedback().debug(kModule, "Registered DI status update behavior");
        }
    }

    protected void onUnregister() {
        this.fCode = Integer.MAX_VALUE;
        if (this.getFeedback().isDebugEnabled(kModule)) {
            this.getFeedback().debug(kModule, "Uunregistered DI status update behavior");
        }
    }

    protected String getName() {
        return kDIStatusCheckedBehaviorName;
    }

    protected void onBroadcastFailure() {
        if (this.getFeedback().isDebugEnabled(kModule)) {
            this.getFeedback().debug(kModule, "Unsuccess in broadcasting DI status");
        }
    }

    protected boolean forceRetry() {
        return true;
    }
}

