/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument.utils;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.wily.introscope.api.instrument.Exception.AgentAttachException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public final class AttachDetachUtilities {
    public static final String kAgentTurnOn = "com.wily.introscope.agentTurnOn";
    public static final String kAgentProfilePathKey = "com.wily.introscope.agentProfile";
    public static final String kDefaultAgentProfileFileName = "IntroscopeAgent.profile";
    public static final String kDefaultAgentProfilePathKey = "./IntroscopeAgent.profile";
    public static final String kAgentProfileResourceLocationKey = "com.wily.introscope.agentResource";
    public static final String kAgentPathKey = "com.wily.introscope.agentLocation";
    public static final String kAgentName = "Agent.jar";
    public static final String kDefaultAgentPathKey = "./Agent.jar";
    public static final String kDisplayVirtualMachines = "com.wily.introscope.displayVirtualMachines";
    public static final String kVirtualMachineDisplayName = "com.wily.introscope.virtualMachineDisplayName";
    public static final String kVirtualMachineId = "com.wily.introscope.virtualMachineId";
    public static final String kAgentDeactivated = "com.wily.introscope.agentDeactivated";
    public static final String kAgentAttach = "com.wily.introscope.agentAttach";
    public static final String kAgentRedefineClasses = "com.wily.introscope.agentRedefineClasses";
    public static final String kToolsJarPath = "com.wily.introscope.toolsLocation";
    public static final String kToolsName = "tools.jar";
    public static final String kArgumentPropertySplitter = ",";
    public static final String kArgumentPropertySeparator = "=";
    public static final String kVirtualMachineClassName = "com.sun.tools.attach.VirtualMachine";
    public static final String kVirtualMachineDescriptorClassName = "com.sun.tools.attach.VirtualMachineDescriptor";

    public static List getVMList() {
        return VirtualMachine.list();
    }

    public static VirtualMachineDescriptor getVMDescriptorByName(String vmDisplayName) {
        List list = AttachDetachUtilities.getVMList();
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                VirtualMachineDescriptor vmDescp = (VirtualMachineDescriptor)iter.next();
                if (vmDescp == null || !vmDescp.displayName().equals(vmDisplayName)) continue;
                return vmDescp;
            }
        }
        return null;
    }

    public static VirtualMachineDescriptor getVMDescriptorById(String vmId) {
        List list = AttachDetachUtilities.getVMList();
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                VirtualMachineDescriptor vmDescp = (VirtualMachineDescriptor)iter.next();
                if (vmDescp == null || !vmDescp.id().equals(vmId)) continue;
                return vmDescp;
            }
        }
        return null;
    }

    public static void printVMList() {
        List list = AttachDetachUtilities.getVMList();
        AttachDetachUtilities.printVMList(list);
    }

    private static void printVMList(List list) {
        if (list == null || list.isEmpty()) {
            System.out.println("*****No Java Virtual Machines are available to be attached*****");
        }
        System.out.println("*****Virtual Machine List*****");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            VirtualMachineDescriptor vmd = (VirtualMachineDescriptor)iter.next();
            if (vmd == null) continue;
            System.out.println("**********");
            if (vmd.displayName() == null || vmd.displayName().trim().equals("")) {
                System.out.println("*****VirtualMachine DisplayName is not available*****");
            } else {
                System.out.println("VirtualMachine DisplayName = " + vmd.displayName());
            }
            System.out.println("VirtualMachine Process ID = " + vmd.id());
            System.out.println("**********");
        }
    }

    public static void attach(String vmDisplayName, String vmId, String agentLocation, String agentProperty, boolean redefineClass, String agentOptions) throws AgentAttachException {
        block7: {
            try {
                if (vmId != null) {
                    AttachDetachUtilities.attachVMSynch(vmId, agentLocation, agentProperty, redefineClass, agentOptions);
                    break block7;
                }
                if (vmDisplayName != null) {
                    AttachDetachUtilities.attachVMSynch(AttachDetachUtilities.getVMDescriptorByName(vmDisplayName), agentLocation, agentProperty, redefineClass, agentOptions);
                    break block7;
                }
                throw new AgentAttachException("Agent Attach Needs a valid Virtual Machine ID or Display Name Specified to Attach");
            }
            catch (IOException ioe) {
                throw new AgentAttachException("IOException", ioe);
            }
            catch (AttachNotSupportedException anse) {
                throw new AgentAttachException("AttachNotSupportedException", anse);
            }
            catch (AgentInitializationException aie) {
                throw new AgentAttachException("AgentInitializationException", aie);
            }
            catch (AgentLoadException ale) {
                throw new AgentAttachException("AgentLoadException", ale);
            }
        }
        System.out.println("*****Agent Attaching Completed Successfully*****");
    }

    public static void attachVMSynch(VirtualMachineDescriptor vmd, String agentLocation, String agentProperty, boolean redefineClass, String agentOptions) throws IOException, AttachNotSupportedException, AgentInitializationException, AgentLoadException, AgentAttachException {
        if (vmd == null) {
            throw new AgentAttachException("Agent Attach Needs a valid Virtual Machine ID or Display Name Specified to Attach");
        }
        AttachDetachUtilities.attachVMSynch(vmd.id(), agentLocation, agentProperty, redefineClass, agentOptions);
    }

    public static void attachVMSynch(String id, String agentLocation, String agentProperty, boolean redefineClass, String agentOptions) throws IOException, AttachNotSupportedException, AgentInitializationException, AgentLoadException {
        VirtualMachine vm = VirtualMachine.attach(id);
        StringBuffer options = new StringBuffer();
        if (agentProperty != null) {
            options.append("com.wily.introscope.agentProfile=" + agentProperty + kArgumentPropertySplitter);
        }
        options.append("com.wily.introscope.agentRedefineClasses=" + redefineClass + kArgumentPropertySplitter);
        if (agentOptions != null) {
            options.append(agentOptions);
        }
        Properties p = vm.getSystemProperties();
        System.out.println("***** Props count " + p.size() + "********");
        String profile = p.getProperty(kAgentProfilePathKey);
        if (profile != null) {
            System.out.println("***** Agent already attatched, profile already set to " + profile + "********");
        } else {
            vm.loadAgent(agentLocation, options.toString());
        }
        vm.detach();
    }

    public static void deactivateVMSynch(VirtualMachineDescriptor vmd, String agentLocation, String agentOptions) {
        AttachDetachUtilities.deactivateVMSynch(vmd.id(), agentLocation, agentOptions);
    }

    public static void deactivateVMSynch(String id, String agentLocation, String agentOptions) {
    }
}

