/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.threaddump.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class TDFileInfo
implements Externalizable {
    public String fFilename;
    public String fHostName;
    public int fPortName;
    public int fCollectorID;
    public boolean hasCollectorInfo;

    public TDFileInfo() {
    }

    public TDFileInfo(String filename, String hostName, int portName, int collectorID, boolean hasCollectorInfo) {
        this.fFilename = filename;
        this.fHostName = hostName;
        this.fPortName = portName;
        this.fCollectorID = collectorID;
        this.hasCollectorInfo = hasCollectorInfo;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fFilename = in.readUTF();
        this.hasCollectorInfo = in.readBoolean();
        if (this.hasCollectorInfo) {
            this.fHostName = in.readUTF();
            this.fPortName = in.readInt();
            this.fCollectorID = in.readInt();
        }
    }

    public void setCollectorInfo(String hostName, int portName, int collectorID) {
        this.fHostName = hostName;
        this.fPortName = portName;
        this.fCollectorID = collectorID;
        this.hasCollectorInfo = true;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.fFilename);
        out.writeBoolean(this.hasCollectorInfo);
        if (this.hasCollectorInfo) {
            out.writeUTF(this.fHostName);
            out.writeInt(this.fPortName);
            out.writeInt(this.fCollectorID);
        }
    }

    public String getFFilename() {
        return this.fFilename;
    }
}

