/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;

public class ExtendedJLabel
extends JLabel {
    private static final long serialVersionUID = -4930888242326971145L;
    private boolean fShouldValidate = true;
    private FontMetrics fFontMetrics;
    private int fMaxWidth;

    public ExtendedJLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.initialize();
    }

    public ExtendedJLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.initialize();
    }

    public ExtendedJLabel(String text) {
        super(text);
        this.initialize();
    }

    public ExtendedJLabel(Icon icon, int horizontalAlignment) {
        super(icon, horizontalAlignment);
        this.initialize();
    }

    public ExtendedJLabel(Icon icon) {
        super(icon);
        this.initialize();
    }

    public ExtendedJLabel() {
        this.initialize();
    }

    private void initialize() {
    }

    public void setText(String text) {
        this.fShouldValidate = this.newTextIsWider(text);
        super.setText(text);
        this.fShouldValidate = true;
    }

    public void setFont(Font f) {
        this.fFontMetrics = null;
        super.setFont(f);
    }

    private boolean newTextIsWider(String newText) {
        int newWidth;
        if (this.fFontMetrics == null) {
            Graphics g = this.getGraphics();
            if (g == null) {
                return true;
            }
            Font font = this.getFont();
            if (font == null) {
                return true;
            }
            this.fFontMetrics = g.getFontMetrics(this.getFont());
            if (this.fFontMetrics == null) {
                return true;
            }
        }
        if ((newWidth = this.fFontMetrics.stringWidth(newText)) > this.fMaxWidth) {
            this.fMaxWidth = newWidth;
            return true;
        }
        return false;
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (w < this.fMaxWidth) {
            this.fMaxWidth = w;
        }
    }

    public void revalidate() {
        if (this.fShouldValidate) {
            super.revalidate();
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }
}

