/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import com.wily.util.io.FastArrayCopy;
import com.wily.wilyassert.Assertion;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public class NonSyncBufferedRandomAccessFile
implements DataOutput,
DataInput {
    private static int kReadBufferSize = 16384;
    private static int kWriteBufferSize = 131072;
    private RandomAccessFile fFile;
    private long fPos;
    private long fReadBufferPosition;
    private long fReadBufferEndPosition;
    private byte[] fReadBuffer;
    private int fWriteBufferLength;
    private byte[] fWriteBuffer;
    private DataOutput fDataOut;
    private DataInput fDataIn;
    private byte[] fTempBuffer = new byte[1];

    public NonSyncBufferedRandomAccessFile(File file, String mode) throws FileNotFoundException {
        this.initialize();
        this.fFile = new RandomAccessFile(file, mode);
    }

    public NonSyncBufferedRandomAccessFile(String name, String mode) throws FileNotFoundException {
        this.initialize();
        this.fFile = new RandomAccessFile(name, mode);
    }

    public int getBufferSize() {
        return kReadBufferSize;
    }

    private void initialize() {
        this.fReadBuffer = new byte[kReadBufferSize];
        this.fReadBufferPosition = 0L;
        this.fReadBufferEndPosition = 0L;
        this.fWriteBuffer = new byte[kWriteBufferSize];
        this.fWriteBufferLength = 0;
        this.fDataOut = new LocalDataOutput();
        this.fDataIn = new LocalDataInput();
    }

    private int readFromDisk(byte[] b, int off, int len) throws IOException {
        this.fFile.seek(this.fPos);
        int num = this.fFile.read(b, off, len);
        if (num > 0) {
            this.fPos += (long)num;
        }
        return num;
    }

    private int fillFromBuffer(byte[] b, int offset, int len) {
        int index = (int)(this.fPos - this.fReadBufferPosition);
        FastArrayCopy.copy(this.fReadBuffer, index, b, offset, len);
        this.fPos += (long)len;
        return len;
    }

    private int attemptFillFromBuffer(byte[] b, int off, int len) {
        if (this.fPos >= this.fReadBufferPosition && this.fPos < this.fReadBufferEndPosition) {
            int numToRead = Math.min(len, (int)(this.fReadBufferEndPosition - this.fPos));
            return this.fillFromBuffer(b, off, numToRead);
        }
        return 0;
    }

    private int fillBufferAndRead(byte[] b, int off, int len) throws IOException {
        this.fFile.seek(this.fPos);
        this.fReadBufferPosition = this.fPos;
        this.fReadBufferEndPosition = this.fPos;
        int num = this.fFile.read(this.fReadBuffer, 0, this.fReadBuffer.length);
        if (num < 0) {
            this.fReadBufferPosition = 0L;
            this.fReadBufferEndPosition = 0L;
            return num;
        }
        this.fReadBufferEndPosition = this.fReadBufferPosition + (long)num;
        num = Math.min(num, len);
        System.arraycopy(this.fReadBuffer, 0, b, off, num);
        this.fPos += (long)num;
        return num;
    }

    public final int read() throws IOException {
        this.flushWriteCache();
        if (this.fPos >= this.fReadBufferPosition && this.fPos < this.fReadBufferEndPosition) {
            int value = this.fReadBuffer[(int)(this.fPos - this.fReadBufferPosition)] & 0xFF;
            ++this.fPos;
            return value;
        }
        int value = this.fillBufferAndRead(this.fTempBuffer, 0, 1);
        if (value < 0) {
            return -1;
        }
        return this.fTempBuffer[0] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.flushWriteCache();
        int numRead = this.attemptFillFromBuffer(b, off, len);
        if (numRead > 0) {
            return numRead;
        }
        if (len > this.fReadBuffer.length) {
            return this.readFromDisk(b, off, len);
        }
        return this.fillBufferAndRead(b, off, len);
    }

    public void seek(long pos) throws IOException {
        try {
            this.flushWriteCache();
            this.fFile.seek(pos);
            this.fPos = pos;
        }
        catch (IOException e) {
            this.fReadBufferPosition = 0L;
            this.fReadBufferEndPosition = 0L;
            throw e;
        }
    }

    public long getFilePointer() throws IOException {
        return this.fPos;
    }

    public FileChannel getChannel() {
        Assertion.unimplemented();
        return null;
    }

    public final FileDescriptor getFD() throws IOException {
        this.flushWriteCache();
        return this.fFile.getFD();
    }

    public long length() throws IOException {
        return this.fFile.length();
    }

    public void flushWriteCache() throws IOException {
        if (this.fWriteBufferLength > 0) {
            this.fFile.seek(this.fPos - (long)this.fWriteBufferLength);
            this.fFile.write(this.fWriteBuffer, 0, this.fWriteBufferLength);
            this.fWriteBufferLength = 0;
        }
    }

    private void writeToCache(int v) {
        this.fWriteBuffer[this.fWriteBufferLength++] = (byte)v;
    }

    private void writeToCache(byte[] b, int offset, int len) {
        if (len <= 8) {
            switch (len) {
                case 8: {
                    this.fWriteBuffer[this.fWriteBufferLength++] = b[offset++];
                }
                case 7: {
                    this.fWriteBuffer[this.fWriteBufferLength++] = b[offset++];
                }
                case 6: {
                    this.fWriteBuffer[this.fWriteBufferLength++] = b[offset++];
                }
                case 5: {
                    this.fWriteBuffer[this.fWriteBufferLength++] = b[offset++];
                }
                case 4: {
                    this.fWriteBuffer[this.fWriteBufferLength++] = b[offset++];
                }
                case 3: {
                    this.fWriteBuffer[this.fWriteBufferLength++] = b[offset++];
                }
                case 2: {
                    this.fWriteBuffer[this.fWriteBufferLength++] = b[offset++];
                }
                case 1: {
                    this.fWriteBuffer[this.fWriteBufferLength++] = b[offset++];
                }
            }
        } else {
            System.arraycopy(b, offset, this.fWriteBuffer, this.fWriteBufferLength, len);
            this.fWriteBufferLength += len;
        }
    }

    private boolean hasWriteSpace(int len) {
        return len <= this.fWriteBuffer.length - this.fWriteBufferLength;
    }

    public final void write(int b) throws IOException {
        if (this.fPos >= this.fReadBufferPosition && this.fPos < this.fReadBufferEndPosition) {
            this.fFile.seek(this.fPos);
            this.fReadBufferPosition = 0L;
            this.fReadBufferEndPosition = 0L;
        }
        if (!this.hasWriteSpace(1)) {
            this.flushWriteCache();
        }
        this.writeToCache(b);
        ++this.fPos;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.fPos >= this.fReadBufferPosition && this.fPos < this.fReadBufferEndPosition) {
            this.fFile.seek(this.fPos);
            this.fReadBufferPosition = 0L;
            this.fReadBufferEndPosition = 0L;
        }
        if (!this.hasWriteSpace(len)) {
            this.flushWriteCache();
        }
        if (this.hasWriteSpace(len)) {
            this.writeToCache(b, off, len);
        } else {
            this.fFile.write(b, off, len);
        }
        this.fPos += (long)len;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.fDataOut.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.fDataOut.writeByte(v);
    }

    public void writeShort(int v) throws IOException {
        this.fDataOut.writeShort(v);
    }

    public void writeChar(int v) throws IOException {
        this.fDataOut.writeChar(v);
    }

    public void writeInt(int v) throws IOException {
        this.fDataOut.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.fDataOut.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.fDataOut.writeFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this.fDataOut.writeDouble(v);
    }

    public void writeBytes(String s) throws IOException {
        this.fDataOut.writeBytes(s);
    }

    public void writeChars(String s) throws IOException {
        this.fDataOut.writeChars(s);
    }

    public void writeUTF(String str) throws IOException {
        this.fDataOut.writeUTF(str);
    }

    public void readFully(byte[] b) throws IOException {
        this.fDataIn.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.fDataIn.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return this.fDataIn.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.fDataIn.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.fDataIn.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.fDataIn.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.fDataIn.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.fDataIn.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.fDataIn.readChar();
    }

    public int readInt() throws IOException {
        return this.fDataIn.readInt();
    }

    public long readLong() throws IOException {
        return this.fDataIn.readLong();
    }

    public float readFloat() throws IOException {
        return this.fDataIn.readFloat();
    }

    public double readDouble() throws IOException {
        return this.fDataIn.readDouble();
    }

    public String readLine() throws IOException {
        return this.fDataIn.readLine();
    }

    public String readUTF() throws IOException {
        return this.fDataIn.readUTF();
    }

    public void close() throws IOException {
        this.flushWriteCache();
        this.fFile.close();
    }

    private class LocalInputStream
    extends InputStream {
        private LocalInputStream() {
        }

        public int read() throws IOException {
            return NonSyncBufferedRandomAccessFile.this.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return NonSyncBufferedRandomAccessFile.this.read(b, off, len);
        }

        public int read(byte[] b) throws IOException {
            return NonSyncBufferedRandomAccessFile.this.read(b);
        }

        public void close() throws IOException {
            Assertion.unimplemented();
        }

        public int available() throws IOException {
            Assertion.unimplemented();
            return 0;
        }

        public synchronized void mark(int readlimit) {
            Assertion.unimplemented();
        }

        public boolean markSupported() {
            Assertion.unimplemented();
            return super.markSupported();
        }

        public synchronized void reset() throws IOException {
            Assertion.unimplemented();
        }

        public long skip(long n) throws IOException {
            Assertion.unimplemented();
            return super.skip(n);
        }
    }

    private class LocalDataInput
    extends DataInputStream {
        public LocalDataInput() {
            super(new LocalInputStream());
        }
    }

    private class LocalOutputStream
    extends OutputStream {
        private LocalOutputStream() {
        }

        public void write(int b) throws IOException {
            NonSyncBufferedRandomAccessFile.this.write(b);
        }

        public void close() throws IOException {
            Assertion.unimplemented();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            NonSyncBufferedRandomAccessFile.this.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            NonSyncBufferedRandomAccessFile.this.write(b);
        }

        public void flush() throws IOException {
            Assertion.unimplemented();
        }
    }

    private class LocalDataOutput
    extends DataOutputStream {
        public LocalDataOutput() {
            super(new LocalOutputStream());
        }
    }
}

