/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.exception.UnexpectedExceptionError;
import com.wily.util.extension.InMemoryJarFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class InMemoryJarClassLoader
extends ClassLoader {
    private final InMemoryJarFile fJarFile;

    public InMemoryJarClassLoader(ClassLoader parent, InMemoryJarFile file) {
        super(parent);
        this.fJarFile = file;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String convertedName = name.replace('.', '/') + ".class";
        byte[] classData = this.fJarFile.getBytesForFile(convertedName);
        if (classData == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, classData, 0, classData.length);
    }

    public URL findResource(String name) {
        byte[] bytesForFile = this.fJarFile.getBytesForFile(name);
        if (bytesForFile == null) {
            return null;
        }
        try {
            return new URL("mem", null, 0, name, new InMemoryURLStream(bytesForFile));
        }
        catch (MalformedURLException e) {
            throw new UnexpectedExceptionError(e);
        }
    }

    private static class InMemoryURLConnection
    extends URLConnection {
        private final byte[] fBytes;

        public InMemoryURLConnection(URL url, byte[] bytes) {
            super(url);
            this.fBytes = bytes;
        }

        public void connect() throws IOException {
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.fBytes);
        }
    }

    private static class InMemoryURLStream
    extends URLStreamHandler {
        private byte[] fBytes;

        public InMemoryURLStream(byte[] bytes) {
            this.fBytes = bytes;
        }

        protected URLConnection openConnection(URL url) throws IOException {
            return new InMemoryURLConnection(url, this.fBytes);
        }
    }
}

