/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.axis2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.ANameFormatter;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class Axis2ClientOutIn1NameFormatter
extends ANameFormatter {
    protected IModuleFeedbackChannel logger = null;

    public Axis2ClientOutIn1NameFormatter(IAgent agent) {
        super(agent);
        this.logger = agent.IAgent_getModuleFeedback();
        WSMUtils.refreshLogLevels();
    }

    @Override
    public String getServiceName(InvocationData data) {
        String serviceURI = null;
        try {
            Object messageContext = data.getInvocationParameterAsObject(0);
            Object endpointReference = WSMUtils.invokeMethodOnObject(messageContext, "getTo");
            serviceURI = (String)WSMUtils.invokeMethodOnObject(endpointReference, "getAddress");
        }
        catch (Throwable bomb) {
            String message = Thread.currentThread() + " Caught unexpected exception while resolving service URI";
            WSMUtils.handleException(this.getAgent(), message, bomb);
        }
        return serviceURI;
    }

    public Object getChild(InvocationData data) throws Exception {
        Object messageContext = data.getInvocationParameterAsObject(0);
        Object soapEnvelope = WSMUtils.invokeMethodOnObject(messageContext, "getEnvelope");
        Object soapBody = WSMUtils.invokeMethodOnObject(soapEnvelope, "getBody");
        return WSMUtils.invokeMethodOnObject(soapBody, "getFirstOMChild");
    }

    @Override
    public String getNamespace(InvocationData data) {
        String namespaceURI = null;
        try {
            Object child = this.getChild(data);
            Object qName = WSMUtils.invokeMethodOnObject(child, "getQName");
            namespaceURI = (String)WSMUtils.invokeMethodOnObject(qName, "getNamespaceURI");
            this.logger.debug("Axis2ClientOutIn1NameFormatter:: namespaceURI= " + namespaceURI);
        }
        catch (Throwable bomb) {
            try {
                String message = Thread.currentThread() + " Caught unexpected exception while resolving web service operation namespace URI from " + data.getInvocationObject().getClass();
                WSMUtils.handleException(this.getAgent(), message, bomb);
            }
            catch (Exception exception) {
                WSMUtils.handleException(this.getAgent(), "Caught unexpected exception while resolving web service operation namespace URI", bomb);
            }
        }
        return namespaceURI;
    }

    @Override
    public String getOperationName(InvocationData data) {
        String operationName = null;
        try {
            operationName = (String)WSMUtils.invokeMethodOnObject(this.getChild(data), "getLocalName");
            this.logger.debug("Axis2ClientOutIn1NameFormatter:: getOperationName operationName= " + operationName);
        }
        catch (Throwable bomb) {
            try {
                String message = " Caught unexpected exception while resolving web service operation namespace URI from " + data.getInvocationObject().getClass();
                WSMUtils.handleException(this.getAgent(), message, bomb);
            }
            catch (Exception exception) {
                WSMUtils.handleException(this.getAgent(), "Caught unexpected exception while resolving web service operation name", bomb);
            }
        }
        return operationName;
    }
}

