/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile;

import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.cmp.directives.utility.CompilerSettingsUtility;
import com.wily.diagnos.personality.java.classfile.constants.DGClassConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.java.ClassName;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DGInterfaces {
    private DGConstantPool fConstantPool;
    private int[] fCPI_interfaces;
    private final String[] fCachedInterfaces;
    private final String[] fPossibleKeys;

    public DGInterfaces(DGConstantPool constantPool, DataInputStream in) throws IOException {
        this.fConstantPool = constantPool;
        int count = in.readUnsignedShort();
        this.fCPI_interfaces = new int[count];
        this.fCachedInterfaces = new String[count];
        String[] fetchedKeys = new String[count];
        boolean succeded = true;
        int i = 0;
        while (i < count) {
            this.fCPI_interfaces[i] = in.readUnsignedShort();
            DGClassConstant impl = (DGClassConstant)this.fConstantPool.getConstant(this.fCPI_interfaces[i]);
            this.fCachedInterfaces[i] = impl.getClassNameString();
            try {
                fetchedKeys[i] = CompilerSettingsUtility.getKeyFromString(ClassName.getClassName(this.fCachedInterfaces[i]).getPackageAndNameString());
            }
            catch (InvalidClassNameException invalidClassNameException) {
                succeded = false;
                break;
            }
            ++i;
        }
        this.fPossibleKeys = !succeded ? null : fetchedKeys;
    }

    public DGInterfaces(DGConstantPool constantPool, String[] interfaces) throws DGClassModificationException {
        this.fConstantPool = constantPool;
        if (interfaces == null) {
            this.fCPI_interfaces = new int[0];
            this.fCachedInterfaces = new String[0];
            this.fPossibleKeys = new String[0];
            return;
        }
        this.fCPI_interfaces = new int[interfaces.length];
        this.fCachedInterfaces = new String[interfaces.length];
        String[] fetchedKeys = new String[interfaces.length];
        boolean succeded = true;
        int i = 0;
        while (i < interfaces.length) {
            this.fCPI_interfaces[i] = this.fConstantPool.addClassReference(interfaces[i]);
            DGClassConstant impl = (DGClassConstant)this.fConstantPool.getConstant(this.fCPI_interfaces[i]);
            this.fCachedInterfaces[i] = impl.getClassNameString();
            try {
                fetchedKeys[i] = CompilerSettingsUtility.getKeyFromString(ClassName.getClassName(this.fCachedInterfaces[i]).getPackageAndNameString());
            }
            catch (InvalidClassNameException invalidClassNameException) {
                succeded = false;
                break;
            }
            ++i;
        }
        this.fPossibleKeys = !succeded ? null : fetchedKeys;
    }

    public String[] getInterfaceNames() {
        String[] results = new String[this.fCachedInterfaces.length];
        int i = 0;
        while (i < this.fCachedInterfaces.length) {
            results[i] = this.fCachedInterfaces[i];
            ++i;
        }
        return results;
    }

    public boolean inheritsFrom(String interfaceName) {
        int i = 0;
        while (i < this.fCachedInterfaces.length) {
            if (this.fCachedInterfaces[i].equals(interfaceName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.fCPI_interfaces.length);
        int i = 0;
        while (i < this.fCPI_interfaces.length) {
            out.writeShort(this.fCPI_interfaces[i]);
            ++i;
        }
    }

    public String[] getPossibleKeys() {
        return this.fPossibleKeys;
    }
}

