/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.probe.net;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;

public class ManagedDatagramSocket
extends DatagramSocket {
    private static final ManagedDatagramSocketLock sLock = new ManagedDatagramSocketLock();
    private static IIntegerRateDataAccumulator sUDPInputBandwidth = null;
    private static IIntegerRateDataAccumulator sUDPOutputBandwidth = null;
    private static final IAgent sAgent = ManagedDatagramSocket.findAgent();

    public ManagedDatagramSocket() throws SocketException {
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedDatagramSocket(int port) throws SocketException {
        super(port);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedDatagramSocket(int port, InetAddress laddr) throws SocketException {
        super(port, laddr);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    protected ManagedDatagramSocket(DatagramSocketImpl impl) throws SocketException {
        super(impl);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedDatagramSocket(SocketAddress addr) throws SocketException {
        super(addr);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void com_wily_initialize() {
        block15: {
            try {
                DataAccumulatorFactory factory;
                ManagedDatagramSocketLock managedDatagramSocketLock;
                if (sUDPInputBandwidth == null) {
                    managedDatagramSocketLock = ManagedDatagramSocket.com_wily_getManagedDatagramSocketLock();
                    synchronized (managedDatagramSocketLock) {
                        if (sUDPInputBandwidth == null) {
                            factory = AgentShim.getAgent().IAgent_getDataAccumulatorFactory();
                            sUDPInputBandwidth = factory.safeGetIntegerRateDataAccumulator("UDP:Input Bandwidth (Bytes Per Second)");
                        }
                    }
                }
                if (sUDPOutputBandwidth != null) break block15;
                managedDatagramSocketLock = ManagedDatagramSocket.com_wily_getManagedDatagramSocketLock();
                synchronized (managedDatagramSocketLock) {
                    if (sUDPOutputBandwidth == null) {
                        factory = AgentShim.getAgent().IAgent_getDataAccumulatorFactory();
                        sUDPOutputBandwidth = factory.safeGetIntegerRateDataAccumulator("UDP:Output Bandwidth (Bytes Per Second)");
                    }
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception initializing datagram socket", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static final ManagedDatagramSocketLock com_wily_getManagedDatagramSocketLock() {
        return sLock;
    }

    @Override
    public void send(DatagramPacket p) throws IOException {
        super.send(p);
        try {
            if (p != null && sUDPOutputBandwidth != null && this.com_wily_shouldMeter(sUDPOutputBandwidth)) {
                sUDPOutputBandwidth.IIntegerRateDataAccumulator_addBatchIncidents(p.getLength(), this.com_wily_getBlameStackSnapshot());
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception recording datagram send", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void receive(DatagramPacket p) throws IOException {
        super.receive(p);
        try {
            if (p != null && sUDPInputBandwidth != null && this.com_wily_shouldMeter(sUDPInputBandwidth)) {
                sUDPInputBandwidth.IIntegerRateDataAccumulator_addBatchIncidents(p.getLength(), this.com_wily_getBlameStackSnapshot());
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception recording datagram receive", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    private final BlameStackSnapshot com_wily_getBlameStackSnapshot() {
        try {
            ComponentTracer componentTracer = AgentShim.getAgent().IAgent_getComponentTracer();
            if (componentTracer != null) {
                return componentTracer.getSnapshot(ComponentTracer.kNoComponent);
            }
        }
        catch (AgentNotAvailableException anae) {
            AgentShim.handleError("Unable to access component tracer", anae);
        }
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    private final boolean com_wily_shouldMeter(IDataAccumulator accumulator) {
        boolean shouldMeter = false;
        AgentMetric metric = accumulator.IDataAccumulator_getMetric();
        shouldMeter = !AgentShim.getAgentShim().IAgentShim_isMetricShutOff(metric);
        return shouldMeter;
    }

    public final boolean suggestStackTraceRecording() {
        if (sAgent != null && sAgent.getBoundaryDetectionTraceRecorder() != null) {
            return sAgent.getBoundaryDetectionTraceRecorder().record();
        }
        return false;
    }

    private static final IAgent findAgent() {
        try {
            return AgentShim.getAgent();
        }
        catch (AgentNotAvailableException anae) {
            try {
                AgentShim.handleError("Unable to gather datagram socket data because the Agent is not available", anae);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {}
            return null;
        }
    }

    static class ManagedDatagramSocketLock {
        ManagedDatagramSocketLock() {
        }
    }
}

