/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transactiontrace.ABaseCorrelationId;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.isengard.util.SerializationUtils;
import com.wily.util.Base64;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.hot.EnumConfigurationProperty;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.wilyassert.Assertion;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class CorrelationId
extends ABaseCorrelationId {
    public static final String CORRELATION_ATTR_NAME = "CorID";
    public static final String SSOEXT_CORRELATION_ATTR_NAME = "x-wily-guid";
    private static volatile boolean sAgentInitialized = false;
    private static final String kCompressMinLimitCrossProcessData = "introscope.agent.crossprocess.compression.minlimit";
    private static final int kDefaultCompressMinLimit = 1024;
    private static final String kCompressCrossProcessData = "introscope.agent.crossprocess.compression";
    private static final String kCorrelationIdMaxLimitCrossProcessData = "introscope.agent.crossprocess.correlationid.maxlimit";
    private static final int kDefaultCorrelationIdMaxLimit = 2048;
    private static final String kCompressCrossProcessDataNone = "none";
    private static final String kCompressCrossProcessDataLzma = "lzma";
    private static final String kCompressCrossProcessDataGzip = "gzip";
    private static final String kCrossProcessDataTooLong = "DataTooLargeDropped";
    private static final String kNoOptionalParams = "NoOptionalParams";
    private static int sDataDroppedLogThrottle = 10;
    private static CompressCrossProcessDataProperty sCompressCrossProcessDataProperty = null;
    private static CompressMinLimitCrossProcessDataProperty sCompressMinLimitCrossProcessDataProperty = null;
    private static CorrelationIdMaxLimitCrossProcessDataProperty sCorrelationIdMaxLimitCrossProcessDataProperty = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initializeAgent() {
        try {
            Class<CorrelationId> clazz = CorrelationId.class;
            synchronized (CorrelationId.class) {
                super.initializeAgent();
                if (!sAgentInitialized) {
                    sCompressCrossProcessDataProperty = new CompressCrossProcessDataProperty(sAgent);
                    sAgent.IAgent_getConfigurationManager().add(sCompressCrossProcessDataProperty, true);
                    sCompressMinLimitCrossProcessDataProperty = new CompressMinLimitCrossProcessDataProperty(sAgent);
                    sAgent.IAgent_getConfigurationManager().add(sCompressMinLimitCrossProcessDataProperty, true);
                    sCorrelationIdMaxLimitCrossProcessDataProperty = new CorrelationIdMaxLimitCrossProcessDataProperty(sAgent);
                    sAgent.IAgent_getConfigurationManager().add(sCorrelationIdMaxLimitCrossProcessDataProperty, true);
                    sAgentInitialized = true;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.fIsDebugEnabled = this.getAgentLogger().isDebugEnabled(kModule);
                this.fIsVerboseEnabled = this.getAgentLogger().isVerboseEnabled(kModule);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public CorrelationId() {
        this.initializeAgent();
        this.initializeCache();
    }

    public CorrelationId(SharedCrossProcessData cache) {
        this.initializeAgent();
        this.cache = cache;
    }

    public CorrelationId(String initialValue) {
        this(initialValue, false);
    }

    public CorrelationId(String initialValue, boolean override) {
        this.initializeAgent();
        String optionalParam = null;
        optionalParam = this.resolveFixedParams(initialValue, override);
        this.resolveOptionalParams(optionalParam);
        this.cache.markIncomingCorrelation();
    }

    @Override
    protected void resolveOptionalParams(String optionalParam) {
        if (optionalParam != null) {
            if (optionalParam.equals(kCrossProcessDataTooLong)) {
                if (this.getAgentLogger() != null && this.getAgentLogger().isWarningEnabled(kModule) && sDataDroppedLogThrottle > 0) {
                    this.getAgentLogger().warn(kModule, "CorrelationId: Recevied data with dropped optional parameters. Parameters were too large to send.");
                    --sDataDroppedLogThrottle;
                }
            } else if (!optionalParam.equals(kNoOptionalParams)) {
                byte[] b = null;
                try {
                    b = Base64.decode(optionalParam, sCompressCrossProcessDataProperty.getBase64Options());
                }
                catch (Exception exception) {
                    Assertion.wilyAssert(false);
                }
                if (b != null && b.length > 0) {
                    HashMap params = null;
                    params = CorrelationId.readStream(b);
                    if (params != null) {
                        this.cache.copyOptionalParamsIn(params);
                    }
                }
            }
        }
    }

    private static HashMap readStream(byte[] b) {
        HashMap map = null;
        Object obj = null;
        IModuleFeedbackChannel feedback = null;
        try {
            obj = SerializationUtils.getSerializableObjectFromByteArray(b);
            feedback = AgentShim.getAgent().IAgent_getModuleFeedback();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
        }
        catch (IOException iOException) {}
        if (obj != null) {
            if (obj instanceof HashMap) {
                map = (HashMap)obj;
            } else if (feedback != null && feedback.isDebugEnabled(kModule)) {
                feedback.debug(kModule, "Received an older/incompatible cross process data on wire. Ignoring the optional params");
            }
        } else if (feedback != null && feedback.isDebugEnabled(kModule)) {
            feedback.debug(kModule, "Received null object from Correlation header");
        }
        return map;
    }

    private void writeStream(ByteArrayOutputStream stream) {
        try {
            SharedCrossProcessData.SerializableSharedCrossProcessData serObj = this.cache.getOutgoingSerializableInstance();
            if (serObj.optionalParams.size() == 0) {
                return;
            }
            try {
                byte[] b = SerializationUtils.serializableObjectToByteArray(serObj.optionalParams);
                stream.write(b);
            }
            catch (IOException iOException) {}
        }
        finally {
            this.cache.doPostCrossProcessCleanup();
        }
    }

    private String base64EncodeBytes(ByteArrayOutputStream s) {
        String result;
        byte[] b = s.toByteArray();
        int options = 0;
        if (b.length == 0) {
            return kNoOptionalParams;
        }
        int strlen = b.length * 4 / 3;
        if (strlen > sCompressMinLimitCrossProcessDataProperty.getIntValue()) {
            options = sCompressCrossProcessDataProperty.getBase64Options();
            if (this.fIsDebugEnabled) {
                this.getAgentLogger().debug(kModule, "Initial optional parameter encoding size is " + strlen + ", invoking compression.");
            }
        }
        if ((result = Base64.encodeBytes(b, options)).length() > sCorrelationIdMaxLimitCrossProcessDataProperty.getIntValue()) {
            if (this.fIsDebugEnabled) {
                this.getAgentLogger().debug(kModule, "Final optional parameter encoding size is " + result.length() + ". Over allowed limit, dropping it.");
            }
            return kCrossProcessDataTooLong;
        }
        return result;
    }

    public String getCorrelationId() {
        this.cache.setPropagationFlag(this.componentTracer.shouldCurrentTraceBePropagated() ? 1 : 0);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.writeStream(stream);
        String params = this.base64EncodeBytes(stream);
        String result = "CorIDForSOAPInvocation=" + this.getCurrentFixedParams() + "," + params;
        return result;
    }

    public String toString() {
        return this.getCorrelationId();
    }

    public String getOutgoingCorrelationIdStrippedForHeader() {
        this.cache.setPropagationFlag(this.componentTracer.shouldCurrentTraceBePropagated() ? 1 : 0);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.writeStream(stream);
        String params = this.base64EncodeBytes(stream);
        int correlationCount = this.cache.incrementCorrelationCount();
        String result = null;
        result = correlationCount == 0 ? String.valueOf(this.getOutGoingFixedParams()) + "," + params : String.valueOf(this.getCurrentOutGoingFixedParams()) + "," + params;
        if (this.fIsDebugEnabled) {
            this.getAgentLogger().debug(kModule, "getOutgoingCorrelationIdStrippedForHeader:: CorrelationData = " + result);
        }
        return result;
    }

    public String getCurrentOutgoingCorrelationIdStrippedForHeader() {
        this.cache.setPropagationFlag(this.componentTracer.shouldCurrentTraceBePropagated() ? 1 : 0);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.writeStream(stream);
        String params = this.base64EncodeBytes(stream);
        String result = null;
        result = String.valueOf(this.getCurrentOutGoingFixedParams()) + "," + params;
        if (this.fIsDebugEnabled) {
            this.getAgentLogger().debug(kModule, "getCurrentOutgoingCorrelationIdStrippedForHeader:: CorrelationData = " + result);
        }
        return result;
    }

    private static final class CompressCrossProcessDataProperty
    extends EnumConfigurationProperty {
        int fBase64Options = 64;

        private CompressCrossProcessDataProperty(IAgent agent) {
            super(CorrelationId.kCompressCrossProcessData, 0, new String[]{CorrelationId.kCompressCrossProcessDataLzma, CorrelationId.kCompressCrossProcessDataGzip, CorrelationId.kCompressCrossProcessDataNone}, agent.IAgent_getModuleFeedback(), agent.IAgent_getModule(), agent.IAgent_getStringLocalizer());
        }

        public int getBase64Options() {
            return this.fBase64Options;
        }

        @Override
        public void set(Object newValue) {
            int value = (Integer)newValue;
            this.fBase64Options = value == 0 ? 64 : (value == 1 ? 2 : 0);
        }
    }

    private static final class CompressMinLimitCrossProcessDataProperty
    extends PositiveIntegerConfigurationProperty {
        private CompressMinLimitCrossProcessDataProperty(IAgent agent) {
            super(CorrelationId.kCompressMinLimitCrossProcessData, 1024, agent.IAgent_getModuleFeedback(), agent.IAgent_getModule(), agent.IAgent_getStringLocalizer());
        }

        public int getIntValue() {
            return (Integer)this.getValue();
        }
    }

    private static final class CorrelationIdMaxLimitCrossProcessDataProperty
    extends PositiveIntegerConfigurationProperty {
        private CorrelationIdMaxLimitCrossProcessDataProperty(IAgent agent) {
            super(CorrelationId.kCorrelationIdMaxLimitCrossProcessData, 2048, agent.IAgent_getModuleFeedback(), agent.IAgent_getModule(), agent.IAgent_getStringLocalizer());
        }

        public int getIntValue() {
            return (Integer)this.getValue();
        }
    }
}

