/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.appmap.impl;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.ConnectedServer;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.runtime.java.environment.EnvironmentStatisticsHandler;
import com.wily.introscope.install.IntroscopeVersion;
import com.wily.introscope.spec.server.appmap.impl.JsonGenerator;
import com.wily.introscope.spec.server.appmap.remotehttp.RemoteHttpCallClient;
import com.wily.introscope.spec.server.appmap.remotehttp.RemoteHttpResponse;
import com.wily.util.text.IStringLocalizer;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class AgentInformationReporter {
    private static final int REPORT_INTERVAL = 1800000;
    private volatile IAgent agent;
    private long lastReport = 0L;

    void reportEnvironmentInformation() {
        block2: {
            try {
                this.reportEnvironmentInformationInner();
            }
            catch (Exception e) {
                if (this.agent == null) break block2;
                this.agent.IAgent_getModuleFeedback().error((Throwable)e);
            }
        }
    }

    private void reportEnvironmentInformationInner() throws IOException, AgentNotAvailableException {
        if (this.agent == null || !this.agent.IAgent_isIsengardEnabled()) {
            return;
        }
        IsengardServerConnectionManager connection = this.agent.IAgent_getIsengardServerConnection();
        if (connection == null) {
            return;
        }
        ConnectedServer server = connection.getConnectedServer();
        if (server != null && server.isConnected() && Math.abs(System.currentTimeMillis() - this.lastReport) > 1800000L) {
            JsonGenerator jg;
            block17: {
                List<String> arguments;
                this.lastReport = System.currentTimeMillis();
                jg = new JsonGenerator();
                jg.writeStartObject();
                jg.writeStringField("layer", "APM_INFRASTRUCTURE");
                jg.writeFieldName("graph");
                jg.writeStartObject();
                jg.writeFieldName("vertices");
                jg.writeStartArray();
                jg.writeStartObject();
                String[] agentTriplet = this.agent.IAgent_getHostProcessAgentTriplet();
                String qualifiedAgent = String.valueOf(agentTriplet[0]) + "|" + agentTriplet[1] + "|" + agentTriplet[2];
                jg.writeStringField("id", "AGENT:" + qualifiedAgent);
                jg.writeFieldName("attributes");
                jg.writeStartObject();
                IStringLocalizer localizer = this.agent.IAgent_getStringLocalizer();
                IntroscopeVersion version = new IntroscopeVersion(localizer);
                jg.writeStringField("version", version.IVersion_getReleaseAndBuildString(localizer));
                jg.writeStringField("type", "AGENT");
                jg.writeStringField("name", qualifiedAgent);
                jg.writeStringField("agentType", "java");
                jg.writeStringField("osName", EnvironmentStatisticsHandler.getOsName());
                jg.writeStringField("vmVendor", EnvironmentStatisticsHandler.getVmVendor());
                jg.writeStringField("vmVersion", EnvironmentStatisticsHandler.getVmVersion());
                jg.writeStringField("TTPlugin.sourceID", "agent");
                jg.writeLongField("maxMemory", Runtime.getRuntime().maxMemory());
                RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
                if (runtimeMxBean != null && (arguments = runtimeMxBean.getInputArguments()) != null) {
                    jg.writeFieldName("jvmOpts");
                    jg.writeStartArray();
                    for (String a : arguments) {
                        if (a == null || a.startsWith("-D")) continue;
                        jg.writeString(a);
                    }
                    jg.writeEndArray();
                }
                try {
                    jg.writeFieldName("networkInterfaces");
                    jg.writeStartArray();
                    Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                    while (interfaces.hasMoreElements()) {
                        String mac;
                        NetworkInterface ni = interfaces.nextElement();
                        Enumeration<InetAddress> addresses = ni.getInetAddresses();
                        if (!ni.isUp()) continue;
                        ArrayList<InetAddress> addresses2 = new ArrayList<InetAddress>();
                        if (addresses != null) {
                            while (addresses.hasMoreElements()) {
                                InetAddress address = addresses.nextElement();
                                if (address.isLoopbackAddress() || address.getHostAddress() == null || address.getHostAddress().isEmpty()) continue;
                                addresses2.add(address);
                            }
                        }
                        if (addresses2.isEmpty()) continue;
                        jg.writeStartObject();
                        jg.writeFieldName("inet");
                        jg.writeStartArray();
                        for (InetAddress address : addresses2) {
                            jg.writeStartObject();
                            String hostAddress = address.getHostAddress();
                            if (hostAddress.contains("%")) {
                                hostAddress = hostAddress.substring(0, hostAddress.indexOf("%"));
                            }
                            jg.writeStringField("addr", hostAddress);
                            jg.writeStringField("host", address.getCanonicalHostName());
                            jg.writeEndObject();
                        }
                        jg.writeEndArray();
                        if (ni.getHardwareAddress() != null && !(mac = AgentInformationReporter.formatMac(ni.getHardwareAddress())).isEmpty()) {
                            jg.writeStringField("mac", mac);
                        }
                        jg.writeEndObject();
                    }
                    jg.writeEndArray();
                }
                catch (SocketException socketException) {
                    if (!this.agent.IAgent_getModuleFeedback().isTraceEnabled()) break block17;
                    this.agent.IAgent_getModuleFeedback().trace("Unable to get list of network interfaces");
                }
            }
            jg.writeEndObject();
            jg.writeEndObject();
            jg.writeEndArray();
            jg.writeFieldName("edges");
            jg.writeStartArray();
            jg.writeEndArray();
            jg.writeEndObject();
            jg.writeEndObject();
            try {
                RemoteHttpResponse ret = new RemoteHttpCallClient(server.getPostOffice()).doPost("/apm/appmap/ats/graph/store", jg.toString(), null);
                if (ret.getHttpCode() / 100 != 2) {
                    this.agent.IAgent_getModuleFeedback().error("Unexpected respond from topology store: " + ret.getHttpCode() + " " + ret.getReasonPhrase() + " Body:" + (ret.getResponseBody() == null ? null : new String(ret.getResponseBody())));
                } else {
                    this.agent.IAgent_getModuleFeedback().info("Agent attributes sent to EM successfully");
                }
            }
            catch (Exception e) {
                this.agent.IAgent_getModuleFeedback().error((Throwable)e);
            }
        }
    }

    public static String formatMac(byte[] hardwareAddress) {
        StringBuilder sb = new StringBuilder(18);
        byte[] byArray = hardwareAddress;
        int n = hardwareAddress.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(String.format("%02x", b));
            ++n2;
        }
        return sb.toString();
    }

    public void setAgent(IAgent agent) {
        this.agent = agent;
    }
}

