/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.adt.ConcurrentThreadLocalHashMap;
import com.wily.util.adt.DatedValue;
import com.wily.util.adt.IListenerOnAging;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.heartbeat.WaitAndExecuteBehavior;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;

public class ConcurrentAgingThreadLocalHashMap<K, V>
extends ConcurrentThreadLocalHashMap<K, DatedValue<V>> {
    private final CopyOnWriteArraySet fListenersOnAging = new CopyOnWriteArraySet();
    private volatile long fAgingTime;
    private volatile long fUpdateAgingFrequency;
    private volatile IntervalHeartbeat fHeartbeat;
    private volatile long fLastCheckAged = System.currentTimeMillis();
    private static final Module kModule = new Module("ConcurrentAgingThreadLocalHashMap");
    private volatile WaitAndExecuteBehavior agingBehavior;
    private final Object behaviorKillLock = new Object();
    private static final long serialVersionUID = 1L;

    public ConcurrentAgingThreadLocalHashMap(IntervalHeartbeat beat, IModuleFeedbackChannel feedback, boolean useThreadLocal, int initialSize, int threadLocalSize, float loadFactor, long agingTime, long updateAgingFrequency, int numThreads) {
        super(feedback, useThreadLocal, useThreadLocal, initialSize, threadLocalSize, loadFactor, numThreads);
        this.startAging(beat, agingTime, updateAgingFrequency);
    }

    public ConcurrentAgingThreadLocalHashMap(IntervalHeartbeat beat, IModuleFeedbackChannel feedback, boolean useThreadLocal, long agingTime, long updateAgingFrequency) {
        this(beat, feedback, useThreadLocal, 750, 75, 0.75f, agingTime, updateAgingFrequency, 8);
    }

    public ConcurrentAgingThreadLocalHashMap(IModuleFeedbackChannel feedback, boolean useThreadLocal) {
        super(feedback, useThreadLocal, useThreadLocal);
    }

    public ConcurrentAgingThreadLocalHashMap(IModuleFeedbackChannel feedback, boolean useThreadLocal, int numberOfProcessors, int size) {
        super(feedback, useThreadLocal, useThreadLocal, numberOfProcessors * 2, size);
    }

    public ConcurrentAgingThreadLocalHashMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAging(IntervalHeartbeat heartbeat, long agingTime, long updateAgingFrequency) {
        if (heartbeat != null) {
            Object object = this.behaviorKillLock;
            synchronized (object) {
                if (this.agingBehavior != null) {
                    this.agingBehavior.kill();
                }
                this.fHeartbeat = heartbeat;
                this.fUpdateAgingFrequency = updateAgingFrequency;
                this.fAgingTime = agingTime;
                this.agingBehavior = new WaitAndExecuteBehavior(this.fHeartbeat, this.fUpdateAgingFrequency, "concurrentMapAging"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected boolean execute() {
                        long currentAging = ConcurrentAgingThreadLocalHashMap.this.getAging();
                        Object object = ConcurrentAgingThreadLocalHashMap.this.behaviorKillLock;
                        synchronized (object) {
                            ArrayList listOfListeners = new ArrayList();
                            listOfListeners.addAll(ConcurrentAgingThreadLocalHashMap.this.fListenersOnAging);
                            IListenerOnAging[] listenersAsArray = new IListenerOnAging[listOfListeners.size()];
                            listenersAsArray = listOfListeners.toArray(listenersAsArray);
                            int lengthOfListeners = listenersAsArray.length;
                            ConcurrentAgingThreadLocalHashMap.this.fLastCheckAged = System.currentTimeMillis();
                            if (ConcurrentAgingThreadLocalHashMap.this.getFeedback().isTraceEnabled(kModule)) {
                                ConcurrentAgingThreadLocalHashMap.this.getFeedback().trace(kModule, "Starting check for aging at " + new Date() + " on a map size of " + ConcurrentAgingThreadLocalHashMap.this.size());
                            }
                            Iterator iterator = ConcurrentAgingThreadLocalHashMap.this.entrySet().iterator();
                            long oldestValid = ConcurrentAgingThreadLocalHashMap.this.fLastCheckAged - currentAging;
                            while (iterator.hasNext()) {
                                Map.Entry entry = iterator.next();
                                if (oldestValid <= ((DatedValue)entry.getValue()).fDate) continue;
                                if (ConcurrentAgingThreadLocalHashMap.this.getFeedback().isTraceEnabled(kModule)) {
                                    ConcurrentAgingThreadLocalHashMap.this.getFeedback().trace(kModule, "Aging key " + entry.getKey());
                                }
                                if (lengthOfListeners > 0) {
                                    int i = 0;
                                    while (i < lengthOfListeners) {
                                        listenersAsArray[i].onAging(entry.getKey(), ((DatedValue)entry.getValue()).fObject, ((DatedValue)entry.getValue()).fDate, currentAging);
                                        ++i;
                                    }
                                }
                                iterator.remove();
                            }
                            if (ConcurrentAgingThreadLocalHashMap.this.getFeedback().isTraceEnabled()) {
                                ConcurrentAgingThreadLocalHashMap.this.getFeedback().trace(kModule, "End check for aging at " + new Date() + ": map size = " + ConcurrentAgingThreadLocalHashMap.this.size());
                            }
                            return false;
                        }
                    }
                };
            }
        } else if (this.getFeedback().isDebugEnabled(kModule)) {
            this.getFeedback().debug(kModule, "Cannot Start Aging: heartbeat supplied is null");
        }
    }

    @Override
    protected void onGet() {
        if (this.fUseThreadLocal && this.fLastCheckAged > this.getLocalMapCreationTime()) {
            this.setShouldFlushLocalMap();
        }
    }

    @Override
    protected void onPut() {
        if (this.fUseThreadLocal && this.fLastCheckAged > this.getLocalMapCreationTime()) {
            this.setShouldFlushLocalMap();
        }
    }

    public V putAged(K key, V value) {
        DatedValue<V> result = this.put(key, new DatedValue<V>(value));
        if (result != null) {
            return result.get();
        }
        return null;
    }

    public V putAgedIfAbsent(K key, V value) {
        DatedValue<V> result = this.putIfAbsent(key, new DatedValue<V>(value));
        if (result != null) {
            return result.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getAging() {
        Object object = this.behaviorKillLock;
        synchronized (object) {
            return this.fAgingTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAging(long newValue) {
        Object object = this.behaviorKillLock;
        synchronized (object) {
            this.fAgingTime = newValue;
        }
    }

    public void addListenerOnAging(IListenerOnAging listener) {
        this.fListenersOnAging.add(listener);
    }

    public void removeListenerOnAging(IListenerOnAging listener) {
        this.fListenersOnAging.remove(listener);
    }
}

