/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.gcmonitor.event;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.service.ASimpleService;
import com.wily.introscope.gcmonitor.event.GCNotificationListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.EnumConfigurationProperty;
import com.wily.util.properties.hot.PositiveLongConfigurationProperty;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationEmitter;

public class GCEventService
extends ASimpleService {
    private static IAgent fAgent;
    private static final String SERVICE_NAME = "GC Event Service";
    private static Module module;
    private static IModuleFeedbackChannel feedbackChannel;
    private static GCNotificationListener gcNotificationListener;
    private static long jvmStartTime;
    private static GarbageCollectorMXBean fMinorGarbageCollectorBean;
    private static GarbageCollectorMXBean fMajorGarbageCollectorBean;
    private static boolean isMajorGcSet;
    private static boolean isMinorGcSet;
    private static AtomicLong eventCountPerInterval;
    private static IRegisteredBehavior eventCountBehavior;
    private static String GCTHRESHOLD;
    private static long gcEventThresholdInMs;
    private static String GCCLAMP;
    private static long gcEventClamp;
    private static final String EventLevelKey = "introscope.agent.gcmonitor.event.level";
    private static int eventLevel;
    private static String[] eventLevelValidValues;

    static {
        module = new Module("GC Event");
        isMajorGcSet = false;
        isMinorGcSet = false;
        eventCountPerInterval = new AtomicLong(0L);
        GCTHRESHOLD = "introscope.agent.gcmonitor.event.threshold";
        gcEventThresholdInMs = 100L;
        GCCLAMP = "introscope.agent.gcmonitor.event.clamp.per.interval";
        gcEventClamp = 5L;
        eventLevel = 1;
        eventLevelValidValues = new String[]{"none", "major", "minor", "all"};
    }

    public GCEventService() {
        super(SERVICE_NAME);
    }

    protected void doStartService(IAgent agent, Map properties) {
        fAgent = agent;
        feedbackChannel = agent.IAgent_getModuleFeedback();
        Properties localProperties = System.getProperties();
        String javaVendorValue = (String)localProperties.get("java.vendor");
        String javaVersionValue = (String)localProperties.get("java.version");
        String javaVmNameValue = (String)localProperties.get("java.vm.name");
        feedbackChannel.info(module, "Java Vendor is '" + javaVendorValue + "'.");
        feedbackChannel.info(module, "Java Version is '" + javaVersionValue + "'.");
        feedbackChannel.info(module, "Java VM Name is '" + javaVmNameValue + "'.");
        if (GCEventService.loadGarbageCollectorMXBean()) {
            eventCountBehavior = agent.IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

                public void ITimestampedRunnable_execute(long nowInMillis) {
                    eventCountPerInterval.set(0L);
                }
            }, "Reset GC Event Count", true, 15000L, true);
            jvmStartTime = ManagementFactory.getRuntimeMXBean().getStartTime();
            gcNotificationListener = new GCNotificationListener(agent);
            agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new GCEventThresholdProperty(agent), true);
            agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new GCEventClampProperty(agent), true);
            agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new GCEventLevelProperty(agent), true);
            feedbackChannel.info(module, "GC Event Service is started.");
        } else {
            feedbackChannel.info(module, "GC Event Service is not supported.");
        }
    }

    private static synchronized boolean loadGarbageCollectorMXBean() {
        List<GarbageCollectorMXBean> gcbeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcbean : gcbeans) {
            if (!(gcbean instanceof NotificationEmitter)) continue;
            String gcName = gcbean.getName();
            if (gcName.equals("PS MarkSweep") || gcName.equals("G1 Old Generation") || gcName.equals("ConcurrentMarkSweep") || gcName.equals("MarkSweepCompact") || gcName.equals("global")) {
                fMajorGarbageCollectorBean = gcbean;
                continue;
            }
            if (!gcName.equals("PS Scavenge") && !gcName.equals("G1 Young Generation") && !gcName.equals("ParNew") && !gcName.equals("Copy") && !gcName.equals("scavenge") && !gcName.equals("partial")) continue;
            fMinorGarbageCollectorBean = gcbean;
        }
        return fMajorGarbageCollectorBean != null || fMinorGarbageCollectorBean != null;
    }

    public static void updateNotificationListener() {
        if (gcNotificationListener != null) {
            if (fMajorGarbageCollectorBean != null && isMajorGcSet) {
                try {
                    ((NotificationEmitter)((Object)fMajorGarbageCollectorBean)).removeNotificationListener(gcNotificationListener);
                    feedbackChannel.info(module, "Major GC Notification Listener is removed.");
                    isMajorGcSet = false;
                }
                catch (ListenerNotFoundException listenerNotFoundException) {}
            }
            if (fMinorGarbageCollectorBean != null && isMinorGcSet) {
                try {
                    ((NotificationEmitter)((Object)fMinorGarbageCollectorBean)).removeNotificationListener(gcNotificationListener);
                    feedbackChannel.info(module, "Minor GC Notification Listener is removed.");
                    isMinorGcSet = false;
                }
                catch (ListenerNotFoundException listenerNotFoundException) {}
            }
            if ((eventLevel == 2 || eventLevel == 3) && fMinorGarbageCollectorBean != null) {
                ((NotificationEmitter)((Object)fMinorGarbageCollectorBean)).addNotificationListener(gcNotificationListener, null, null);
                isMinorGcSet = true;
                feedbackChannel.info(module, "Minor GC Notification Listener is added.");
            }
            if ((eventLevel == 1 || eventLevel == 3) && fMajorGarbageCollectorBean != null) {
                ((NotificationEmitter)((Object)fMajorGarbageCollectorBean)).addNotificationListener(gcNotificationListener, null, null);
                isMajorGcSet = true;
                feedbackChannel.info(module, "Major GC Notification Listener is added.");
            }
        }
    }

    public static boolean isEventMonitorEnabled() {
        return eventLevel > 0;
    }

    public static boolean shouldSendGCEvent(long duration, long startTime) {
        return startTime >= 0L && duration >= 0L && duration >= gcEventThresholdInMs && eventCountPerInterval.incrementAndGet() < gcEventClamp;
    }

    public static long getJvmStartTime() {
        return jvmStartTime;
    }

    private final class GCEventClampProperty
    extends PositiveLongConfigurationProperty {
        private GCEventClampProperty(IAgent agent) {
            super(GCCLAMP, Long.valueOf(gcEventClamp), agent.IAgent_getModuleFeedback(), module, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            gcEventClamp = ((Long)newValue).intValue();
        }
    }

    private final class GCEventLevelProperty
    extends EnumConfigurationProperty {
        private GCEventLevelProperty(IAgent agent) {
            super(GCEventService.EventLevelKey, new Integer(eventLevel), eventLevelValidValues, agent.IAgent_getModuleFeedback(), module, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            eventLevel = (Integer)newValue;
            GCEventService.updateNotificationListener();
        }
    }

    private final class GCEventThresholdProperty
    extends PositiveLongConfigurationProperty {
        private GCEventThresholdProperty(IAgent agent) {
            super(GCTHRESHOLD, Long.valueOf(gcEventThresholdInMs), agent.IAgent_getModuleFeedback(), module, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            gcEventThresholdInMs = ((Long)newValue).intValue();
        }
    }
}

