/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.bytecode;

import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.personality.java.classfile.bytecode.MethodExitByteCode;
import com.wily.wilyassert.Assertion;
import java.io.IOException;

public class ParameterizedMethodExitByteCode
extends MethodExitByteCode {
    private final int fCpiForSetReturnValueCall;

    public ParameterizedMethodExitByteCode(int localVariableForThis, int cpiForSetInvocationObject, int localVariableIndexForTracer, int cpiForSetReturnValueCall) throws DGClassModificationException, IOException {
        super(localVariableForThis, cpiForSetInvocationObject, localVariableIndexForTracer);
        this.fCpiForSetReturnValueCall = cpiForSetReturnValueCall;
    }

    @Override
    public int getMaxStackSlotsUsed() {
        return super.getMaxStackSlotsUsed() + 2;
    }

    @Override
    protected void insertAdditionalMethodExitByteCode(int exitOpcode) throws DGClassModificationException, IOException {
        if (exitOpcode != 177) {
            int size = this.calculateReturnValueSize(exitOpcode);
            if (size == 1) {
                this.write(89);
                this.write_aload(this.fLocalTracerStorage);
                this.write(95);
            } else {
                this.write(92);
                this.write_aload(this.fLocalTracerStorage);
                this.write(91);
                this.write(87);
            }
            this.write_invokeinterface(this.fCpiForSetReturnValueCall, 1 + size);
        }
    }

    private int calculateReturnValueSize(int exitOpcode) {
        int result = 0;
        switch (exitOpcode) {
            case 177: {
                result = 0;
                break;
            }
            case 172: 
            case 174: 
            case 176: {
                result = 1;
                break;
            }
            case 173: 
            case 175: {
                result = 2;
                break;
            }
            default: {
                Assertion.wilyFail("unexpected exit opcode: " + exitOpcode);
            }
        }
        return result;
    }
}

