/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncFrontendTracer;
import com.wily.introscope.agent.async.AsyncTransactionContext;
import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class AsyncFrontendStartTracer
extends AsyncFrontendTracer {
    public static final String kFragmentsCategoryPrefix = "Fragments|";
    protected final IModuleFeedbackChannel feedback;
    protected static Module module = new Module("AsyncFrontendStartTracer");
    protected final AsyncVirtualStack asyncStack;
    protected final IAgent agent;

    public AsyncFrontendStartTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.feedback = agent.IAgent_getModuleFeedback();
        this.asyncStack = AsyncVirtualStack.getInstance(agent);
        this.agent = agent;
    }

    @Override
    protected String getFrontendNameForComponent(String rootName) {
        return kFragmentsCategoryPrefix + rootName;
    }

    protected String getFrontendNameForAsyncComponent(InvocationData data, String rootName) {
        return super.getFrontendNameForComponent(rootName);
    }

    protected boolean isAsyncStarted(InvocationData data) {
        return true;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        AsyncTransactionContext.AsyncComponentInvocation frontendInfo = this.asyncStack.getAsyncFrontendInfoFromTransactionCache(data);
        if (frontendInfo == null) {
            String name = super.formatParameterizedName(data);
            String component = this.getFrontendNameForAsyncComponent(data, name);
            frontendInfo = this.asyncStack.pushFrontend(component, data, this);
            this.asyncStack.putAsyncFrontendInfoToTransactionCache(data, frontendInfo);
            AsyncVirtualStack.putFrontendTransactionIdToTransactionCache(data, frontendInfo.transactionId);
        }
        super.ITracer_startTrace(tracerIndex, data);
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (!this.isAsyncStarted(data)) {
            AsyncTransactionContext.AsyncComponentInvocation frontendInfo = this.asyncStack.getAsyncFrontendInfoFromTransactionCache(data);
            if (frontendInfo == null) {
                if (this.feedback.isDebugEnabled(module)) {
                    this.feedback.debug(module, "Failed to find correlated frontend info. " + data.getProbeInformation().getProbeIdentification().getProbeClassName() + "." + data.getProbeInformation().getProbeIdentification().getProbeMethodName());
                }
            } else {
                this.asyncStack.pop(frontendInfo, data, this);
            }
        }
        super.ITracer_finishTrace(tracerIndex, data);
    }
}

