/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.exitpoint;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.detection.BasicRuleEngine;
import com.wily.introscope.agent.intelligent.detection.rules.InstrumentationCheck;
import com.wily.introscope.agent.intelligent.detection.rules.SkipMethodIfAlreadyInstrumentedRule;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.apis.Rule;
import com.wily.introscope.agent.intelligent.entrypoint.apis.RuleEngine;
import com.wily.introscope.agent.intelligent.entrypoint.common.Utils;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.StackTraceRepository;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.WrappedStackTraceElement;
import com.wily.introscope.agent.intelligent.exitpoint.ExitPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.exitpoint.ExitPointDetector;
import com.wily.introscope.agent.intelligent.exitpoint.RulesHelper;
import com.wily.introscope.agent.intelligent.exitpoint.stacktrace.LinkedIndexAwareStackTrace;
import com.wily.introscope.agent.intelligent.exitpoint.stacktrace.WrappedStackTrace;
import com.wily.introscope.agent.trace.intelligent.Logger;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class WriteReadPatternDetector
implements ExitPointDetector {
    private static final Logger.ILoggingHandler LOGGER = ExitPointDetectionConfiguration.getLogger();
    private final RuleEngine CANDIDATE_VALIDATION_ENGINE = new BasicRuleEngine(1, 1);
    private final InstrumentationCheck INSTR_CHECKER = SkipMethodIfAlreadyInstrumentedRule.getInstance();

    public WriteReadPatternDetector(Set<Rule> rules) {
        this.CANDIDATE_VALIDATION_ENGINE.registerRules(rules);
    }

    public WriteReadPatternDetector(IAgent agent) {
        this.CANDIDATE_VALIDATION_ENGINE.registerRules(RulesHelper.createDefaultRulesSet(agent));
    }

    @Override
    public Set<StackTraceElement> find(WrappedStackTrace[] traceBundle) {
        LinkedHashSet<StackTraceElement> candidates = new LinkedHashSet<StackTraceElement>();
        int size = traceBundle.length;
        int index = 0;
        this.logTraceTypePattern(traceBundle);
        while (index + 1 < size) {
            WrappedStackTrace trace1 = traceBundle[index];
            WrappedStackTrace trace2 = traceBundle[index + 1];
            LOGGER.logDebugMessage("Analyzing stack traces for WRITE-READ Pattern");
            this.logTracesIfEnabled(trace1, trace2);
            if (trace1.getInvocationId() == trace2.getInvocationId() && WrappedStackTrace.Type.WRITE == trace1.findAndGetType() && WrappedStackTrace.Type.READ == trace2.findAndGetType()) {
                IndexAwareTraceElement[] readTrace;
                IndexAwareTraceElement[] writeTrace = StackTraceRepository.wrapTraceElements(trace1.getTrace());
                IndexAwareTraceElement candidate = this.findCandidate(writeTrace, readTrace = StackTraceRepository.wrapTraceElements(trace2.getTrace()));
                if (candidate != null) {
                    LOGGER.logDebugMessage("WriteReadPatternDetector - Found Backend candidate: " + candidate);
                    candidates.add(candidate.getStackTraceElement());
                }
                index += 2;
                continue;
            }
            ++index;
        }
        return candidates;
    }

    IndexAwareTraceElement findCandidate(IndexAwareTraceElement[] trace1, IndexAwareTraceElement[] trace2) {
        Object[] selectedElements = this.findLowestCommonElements(trace1, trace2);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTraceMessage("Lowest common elements in traces: " + Arrays.toString(selectedElements));
        }
        LinkedIndexAwareStackTrace.LinkedStackElement element1 = selectedElements[0];
        Object element2 = selectedElements[1];
        while (element1 != null && element2 != null) {
            LOGGER.logTraceMessage("Validating element: " + element1);
            if (this.INSTR_CHECKER.isInstrumented(element1.getClassName(), element1.getMethodName())) {
                if (!LOGGER.isTraceEnabled()) break;
                LOGGER.logTraceMessage(String.format("Found already instrumented element: %s. Skipping analysis of rest of trace elements", element1.toString()));
                break;
            }
            if (this.areCalledBySameCallerFromSameLine(element1, (LinkedIndexAwareStackTrace.LinkedStackElement)element2) && this.passesRules((IndexAwareTraceElement)(element1.getSizeOfMyStackTrace() > ((WrappedStackTraceElement)element2).getSizeOfMyStackTrace() ? element1 : element2))) {
                return element1;
            }
            element1 = element1.parent();
            element2 = ((LinkedIndexAwareStackTrace.LinkedStackElement)element2).parent();
        }
        return null;
    }

    boolean passesRules(IndexAwareTraceElement candidate) {
        IndexAwareTraceElement[] trace = new IndexAwareTraceElement[]{candidate};
        List elements = this.CANDIDATE_VALIDATION_ENGINE.execute(trace);
        return elements.size() > 0;
    }

    LinkedIndexAwareStackTrace.LinkedStackElement[] findLowestCommonElements(IndexAwareTraceElement[] trace1, IndexAwareTraceElement[] trace2) {
        int length1 = trace1.length;
        int length2 = trace2.length;
        int len = length1 < length2 ? length1 : length2;
        int i = 1;
        int revIndex = -1;
        while (i <= len && this.representSameClassMethod(trace1[length1 - i], trace2[length2 - i])) {
            revIndex = i++;
        }
        if (revIndex != -1) {
            LinkedIndexAwareStackTrace.LinkedStackElement[] elements = new LinkedIndexAwareStackTrace.LinkedStackElement[]{new LinkedIndexAwareStackTrace(trace1).getElement(length1 - revIndex), new LinkedIndexAwareStackTrace(trace2).getElement(length2 - revIndex)};
            return elements;
        }
        return null;
    }

    boolean areCalledBySameCallerFromSameLine(LinkedIndexAwareStackTrace.LinkedStackElement element1, LinkedIndexAwareStackTrace.LinkedStackElement element2) {
        LinkedIndexAwareStackTrace.LinkedStackElement parent1 = element1.parent();
        LinkedIndexAwareStackTrace.LinkedStackElement parent2 = element2.parent();
        return parent1 != null && parent2 != null && parent1.getStackTraceElement().equals(parent2.getStackTraceElement());
    }

    private boolean representSameClassMethod(IndexAwareTraceElement element1, IndexAwareTraceElement element2) {
        return this.representValidClassMethod(element1) && element1.getClassName().equals(element2.getClassName()) && element1.getMethodName().equals(element2.getMethodName());
    }

    private boolean representValidClassMethod(IndexAwareTraceElement element) {
        return element.getClassName() != null && element.getMethodName() != null;
    }

    private void logTracesIfEnabled(WrappedStackTrace trace1, WrappedStackTrace trace2) {
        if (LOGGER.isTraceEnabled() && ExitPointDetectionConfiguration.shouldLogStackTraces()) {
            LOGGER.logTraceMessage("Wrapped Stack Trace1: \n" + Utils.getStringRepresentationOfTrace(trace1));
            LOGGER.logTraceMessage("Wrapped Stack Trace2: \n" + Utils.getStringRepresentationOfTrace(trace2));
        }
    }

    private void logTraceTypePattern(WrappedStackTrace[] traceBundle) {
        if (LOGGER.isTraceEnabled()) {
            int len = traceBundle.length;
            StringBuilder tracePatterns = new StringBuilder();
            tracePatterns.append("{");
            if (len > 0) {
                tracePatterns.append(traceBundle[0].description());
                int i = 1;
                while (i < len) {
                    tracePatterns.append(", " + traceBundle[i].description());
                    ++i;
                }
            }
            tracePatterns.append("}");
            LOGGER.logTraceMessage("Stack trace patterns noticed in given set of traces: " + tracePatterns);
        }
    }
}

