/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.async.InjectedFieldCorrelationHelper;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.hc2.FrontendTracer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class AsyncThreadFragmentCorrelationTracer
extends FrontendTracer {
    private static final String debugMethodPropertyKey = "introscope.agent.async.debug.method";
    private String debugMethodName;
    private final boolean debugFlag;
    private final InjectedFieldCorrelationHelper correlationHelper;
    private static final String kContextObjextIndexKey = "contextObject";
    private static final String kKeepContextKey = "keepContext";
    private static final int USE_THIS_AS_CONTEXT = -1;
    private static final int USE_RETVAL_AS_CONTEXT = 9999;
    private final int contextObjectIndex;
    private final boolean keepContext;
    protected final IModuleFeedbackChannel feedback;
    protected static Module module = new Module("AsyncThreadFragmentCorrelationTracer");
    public static final String kFragmentsCategoryPrefix = "Fragments|";

    public AsyncThreadFragmentCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.feedback = agent.IAgent_getModuleFeedback();
        this.correlationHelper = new InjectedFieldCorrelationHelper(agent, parameters, probe, sampleTracedObject);
        this.contextObjectIndex = this.calculateIntegerParameter(kContextObjextIndexKey, -1);
        this.keepContext = this.calculateBooleanParameter(kKeepContextKey, false);
        String debugMethod = agent.IAgent_getIndexedProperties().getProperty(debugMethodPropertyKey, null);
        if (debugMethod != null) {
            this.debugMethodName = String.valueOf(probe.getRuntimeFullClassName()) + "." + probe.getProbeMethodName();
            this.debugFlag = this.debugMethodName.startsWith(debugMethod);
        } else {
            this.debugFlag = false;
        }
    }

    private Object findContextObject(InvocationData data) {
        if (this.contextObjectIndex == -1) {
            return data.getInvocationObject();
        }
        if (this.contextObjectIndex == 9999) {
            return null;
        }
        return data.getInvocationParameterAsObject(this.contextObjectIndex);
    }

    @Override
    protected String getFrontendNameForComponent(String rootName) {
        return kFragmentsCategoryPrefix + rootName;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        boolean enabled;
        Object contextObject;
        if (this.debugFlag) {
            this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " start trace called for " + this.debugMethodName);
        }
        if ((contextObject = this.findContextObject(data)) != null && (enabled = this.correlationHelper.processContext(data, contextObject, this.keepContext))) {
            super.ITracer_startTrace(tracerIndex, data);
            data.put("asyn.thread.correlation.inserted", true);
            data.setParameterCallback(new IInvocationDataParameterCallback(){

                @Override
                public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
                    String frontendTxid = AsyncVirtualStack.getFrontendTransactionIdFromTransactionCache(data);
                    if (frontendTxid != null) {
                        parameters.put("FrontendTxnTraceId", frontendTxid);
                    }
                }
            });
        }
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (this.debugFlag) {
            this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " finish trace called for " + this.debugMethodName);
        }
        if (data.get("asyn.thread.correlation.inserted") != null) {
            super.ITracer_finishTrace(tracerIndex, data);
        }
    }
}

