/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import com.wily.introscope.api.instrument.DGRuntimeMethod;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.classfile.java.ClassName;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import sun.reflect.ReflectionFactory;

public class DGRuntimeClass
implements IModeledClass {
    private final Class fRuntimeClass;
    private ClassName className;
    private ClassName superClassName;
    private List<IModeledMethod> fModeledMethods;

    public DGRuntimeClass(Class cls) throws InvalidClassNameException {
        this.fRuntimeClass = cls;
        this.className = ClassName.getClassName(this.fRuntimeClass.getName());
        if (this.fRuntimeClass.getSuperclass() != null) {
            this.superClassName = ClassName.getClassName(this.fRuntimeClass.getSuperclass().getName());
        }
        this.fModeledMethods = null;
    }

    @Override
    public IClassName getClassName() {
        return this.className;
    }

    @Override
    public boolean hasSuperClass() {
        return this.superClassName != null;
    }

    @Override
    public IClassName getSuperClassName() {
        return this.superClassName;
    }

    @Override
    public boolean isInterface() {
        return this.fRuntimeClass.isInterface();
    }

    @Override
    public boolean isValueType() {
        return this.fRuntimeClass.isPrimitive();
    }

    @Override
    public boolean inheritsDirectlyFromInterface(IClassName iClassName) {
        Class<?>[] intfs = this.fRuntimeClass.getInterfaces();
        if (intfs == null) {
            return false;
        }
        Class<?>[] classArray = intfs;
        int n = intfs.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            if (intf.getName().equals(iClassName.getReflectionFriendlyQualifiedNameString())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isInstanceOf(IClassName iClassName) {
        try {
            Class<?> interfaceClass = Class.forName(iClassName.getReflectionFriendlyQualifiedNameString(), false, this.fRuntimeClass.getClassLoader());
            return interfaceClass.isAssignableFrom(this.fRuntimeClass);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public Iterator getAllDeclaredMethods() {
        if (this.fModeledMethods == null) {
            Method[] methods;
            this.fModeledMethods = new ArrayList<IModeledMethod>();
            Method[] methodArray = methods = this.fRuntimeClass.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                try {
                    this.fModeledMethods.add(new DGRuntimeMethod(this, m));
                }
                catch (InvalidMethodDescriptorException e) {
                    e.printStackTrace();
                }
                catch (InvalidMethodNameException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            Constructor<?>[] constructors = this.fRuntimeClass.getDeclaredConstructors();
            Method classConstructorMockedToFitBytecode = ReflectionFactory.getReflectionFactory().newMethod(this.fRuntimeClass, "<clinit>", new Class[0], Void.TYPE, new Class[0], 8, -1, "<clinit>", null, null, null);
            try {
                this.fModeledMethods.add(new DGRuntimeMethod(this, classConstructorMockedToFitBytecode));
            }
            catch (InvalidMethodDescriptorException e) {
                e.printStackTrace();
            }
            catch (InvalidMethodNameException e) {
                e.printStackTrace();
            }
            if (constructors.length == 0) {
                Method instanceConstructorMockedToFitBytecode = ReflectionFactory.getReflectionFactory().newMethod(this.fRuntimeClass, "<init>", new Class[0], Void.TYPE, new Class[0], 2, -1, "<init>", null, null, null);
                try {
                    this.fModeledMethods.add(new DGRuntimeMethod(this, instanceConstructorMockedToFitBytecode));
                }
                catch (InvalidMethodDescriptorException e) {
                    e.printStackTrace();
                }
                catch (InvalidMethodNameException e) {
                    e.printStackTrace();
                    return this.fModeledMethods.iterator();
                }
            }
            Constructor<?>[] constructorArray = constructors;
            int n3 = constructors.length;
            int n4 = 0;
            while (n4 < n3) {
                Constructor<?> c = constructorArray[n4];
                try {
                    Field f = c.getClass().getDeclaredField("slot");
                    f.setAccessible(true);
                    Integer slot = (Integer)f.get(c);
                    Method getSignature = c.getClass().getDeclaredMethod("getSignature", new Class[0]);
                    getSignature.setAccessible(true);
                    Method getRawAnnotations = c.getClass().getDeclaredMethod("getRawAnnotations", new Class[0]);
                    getRawAnnotations.setAccessible(true);
                    Method getRawParameterAnnotations = c.getClass().getDeclaredMethod("getRawParameterAnnotations", new Class[0]);
                    getRawParameterAnnotations.setAccessible(true);
                    Method instanceConstructorMockedToFitBytecode = ReflectionFactory.getReflectionFactory().newMethod(this.fRuntimeClass, "<init>", c.getParameterTypes(), Void.TYPE, c.getExceptionTypes(), c.getModifiers(), slot, (String)getSignature.invoke(c, new Object[0]), (byte[])getRawAnnotations.invoke(c, new Object[0]), (byte[])getRawParameterAnnotations.invoke(c, new Object[0]), null);
                    this.fModeledMethods.add(new DGRuntimeMethod(this, instanceConstructorMockedToFitBytecode));
                }
                catch (IllegalAccessException iae) {
                    iae.printStackTrace();
                }
                catch (NoSuchFieldException nsfe) {
                    nsfe.printStackTrace();
                }
                catch (NoSuchMethodException nsme) {
                    nsme.printStackTrace();
                }
                catch (InvocationTargetException ite) {
                    ite.printStackTrace();
                }
                catch (InvalidMethodDescriptorException imde) {
                    imde.printStackTrace();
                }
                catch (InvalidMethodNameException imne) {
                    imne.printStackTrace();
                }
                ++n4;
            }
        }
        return this.fModeledMethods.iterator();
    }

    @Override
    public boolean containsAnnotation(IClassName iClassName) {
        HashSet<Annotation> annotations = new HashSet<Annotation>(Arrays.asList(this.fRuntimeClass.getAnnotations()));
        annotations.addAll(Arrays.asList(this.fRuntimeClass.getDeclaredAnnotations()));
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().getName().equals(iClassName.getReflectionFriendlyQualifiedNameString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean referencesClass(IClassName iClassName) {
        int n;
        if (this.isInstanceOf(iClassName)) {
            return true;
        }
        String reflectionName = iClassName.getReflectionFriendlyQualifiedNameString();
        HashSet classes = new HashSet(Arrays.asList(this.fRuntimeClass.getClasses()));
        classes.addAll(Arrays.asList(this.fRuntimeClass.getDeclaredClasses()));
        for (Class<?> clazz : classes) {
            if (!clazz.getName().equals(reflectionName)) continue;
            return true;
        }
        classes.clear();
        HashSet<Field> fields = new HashSet<Field>(Arrays.asList(this.fRuntimeClass.getFields()));
        fields.addAll(Arrays.asList(this.fRuntimeClass.getDeclaredFields()));
        for (Field field : fields) {
            if (!field.getType().getName().equals(reflectionName)) continue;
            return true;
        }
        fields.clear();
        HashSet<Method> methods = new HashSet<Method>(Arrays.asList(this.fRuntimeClass.getMethods()));
        methods.addAll(Arrays.asList(this.fRuntimeClass.getDeclaredMethods()));
        for (Method method : methods) {
            if (method.getReturnType().getName().equals(reflectionName)) {
                return true;
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes == null) continue;
            Class<?>[] classArray = parameterTypes;
            n = parameterTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> parameter = classArray[n2];
                if (parameter.getName().equals(reflectionName)) {
                    return true;
                }
                ++n2;
            }
        }
        methods.clear();
        HashSet constructors = new HashSet(Arrays.asList(this.fRuntimeClass.getConstructors()));
        constructors.addAll(Arrays.asList(this.fRuntimeClass.getDeclaredConstructors()));
        for (Constructor<?> constructor : constructors) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes == null) continue;
            Class<?>[] classArray = parameterTypes;
            int n3 = parameterTypes.length;
            n = 0;
            while (n < n3) {
                Class<?> parameter = classArray[n];
                if (parameter.getName().equals(reflectionName)) {
                    return true;
                }
                ++n;
            }
        }
        constructors.clear();
        return this.containsAnnotation(iClassName);
    }

    @Override
    public void debugDump(PrintWriter printWriter) {
    }
}

