/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import java.net.URI;

public class NexusLocator {
    private String fNexusHostName;
    private int fNexusPort;
    private String fAutofillEnable;
    private String fNexusProxy;
    private String fNexusTenant;

    public NexusLocator() {
    }

    public NexusLocator(String nexusHostName, int nexusHostPort) {
        this.setNexusHostName(nexusHostName);
        this.setNexusPort(nexusHostPort);
    }

    public NexusLocator(String nexusHostName, String nexusHostPortString) {
        this.setNexusHostName(nexusHostName);
        this.setNexusPort(nexusHostPortString);
    }

    public NexusLocator(String nexusHostName, int nexusHostPort, String autofillEnable) {
        this.setNexusHostName(nexusHostName);
        this.setNexusPort(nexusHostPort);
        this.setNexusAutofillEnabled(autofillEnable);
    }

    public NexusLocator(String nexusHostName, String nexusHostPortString, String autofillEnable) {
        this.setNexusHostName(nexusHostName);
        this.setNexusPort(nexusHostPortString);
        this.setNexusAutofillEnabled(autofillEnable);
    }

    public String getNexusHostName() {
        return this.fNexusHostName;
    }

    public void setNexusHostName(String nexusHostName) {
        this.fNexusHostName = nexusHostName;
    }

    public String getNexusProxy() {
        return this.fNexusProxy;
    }

    public void setNexusProxy(String nexusProxy) {
        this.fNexusProxy = nexusProxy;
    }

    public String getNexusTenant() {
        return this.fNexusTenant;
    }

    public void setNexusTenant(String nexusTenant) {
        this.fNexusTenant = nexusTenant;
    }

    public int getNexusPort() {
        return this.fNexusPort;
    }

    public String getNexusPortString() {
        return Integer.toString(this.getNexusPort());
    }

    public void setNexusPort(String nexusPortName) {
        this.fNexusPort = Integer.parseInt(nexusPortName);
    }

    public void setNexusPort(int nexusPort) {
        this.fNexusPort = nexusPort;
    }

    public void setNexusAutofillEnabled(String autofillEnable) {
        this.fAutofillEnable = autofillEnable;
    }

    public String getNexusAutofillEnabled() {
        return this.fAutofillEnable;
    }

    public String toString() {
        if (this.fNexusProxy != null) {
            return "NexusLocator: proxy=" + this.getNexusProxy();
        }
        return "NexusLocator: host=" + this.getNexusHostName() + " port=" + this.getNexusPortString();
    }

    public String getNexusUiHostName() {
        if (this.fNexusHostName != null) {
            return this.fNexusHostName;
        }
        if (this.fNexusProxy != null) {
            try {
                URI uri = URI.create(this.fNexusProxy);
                if (uri.getHost() != null) {
                    return uri.getHost();
                }
            }
            catch (Exception exception) {}
            return this.fNexusProxy;
        }
        return "";
    }

    public String getNexusUiPortString() {
        if (this.fNexusProxy != null) {
            try {
                URI uri = URI.create(this.fNexusProxy);
                if (uri.getPort() != -1) {
                    return Integer.toString(uri.getPort());
                }
            }
            catch (Exception exception) {}
        }
        return this.getNexusPortString();
    }
}

