/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.correlation.http;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.correlation.http.HttpInsertionCorrelationEnabledChecker;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class ApacheHttpComponentsClientCorrelationTracer
extends HttpInsertionCorrelationEnabledChecker {
    private static Module sModule = new Module("ApacheHttpComponentClientCorrelationTracer");
    private ReentrancyLevel fReEntryLeveL = this.calculateReentrancyLevel(ReentrancyLevel.kNone);

    public ApacheHttpComponentsClientCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
    }

    public void ITracer_startTrace(int index, InvocationData data) {
        try {
            Object reqObj = data.getInvocationParameterAsObject(0);
            if (reqObj == null || reqObj.getClass().getName().equals("org.apache.http.HttpHost")) {
                reqObj = data.getInvocationParameterAsObject(1);
            }
            String correlationString = new CorrelationId().getOutgoingCorrelationIdStrippedForHeader();
            ReflectionUtils.invokeMethodOnObject((Object)reqObj, (String)"setHeader", (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"CorID", correlationString});
        }
        catch (Exception ex) {
            this.getAgent().IAgent_getModuleFeedback().error(sModule, "ITracer_startTrace unable to execute addHeader : " + ex);
        }
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        new CorrelationId().decrementCorrelationCount();
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReEntryLeveL;
    }
}

