/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.probe.io;

import com.wily.introscope.agent.ACommonAgent;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.wilyassert.Assertion;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;

public class ManagedFileOutputStream
extends FileOutputStream {
    private static final Object sLock = new Object();
    private static volatile IIntegerRateDataAccumulator sFileOutputRate = null;
    private static volatile IAgent sAgent;
    private static volatile boolean sHasNewConfiguration;
    private ThreadLocal fIsWriting;
    private static final ThreadLocal fIsInWilyCall;

    static {
        fIsInWilyCall = new ThreadLocal();
    }

    public ManagedFileOutputStream(FileDescriptor fd) {
        super(fd);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedFileOutputStream(String file) throws IOException {
        super(file);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedFileOutputStream(File file) throws IOException {
        super(file);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedFileOutputStream(String file, boolean append) throws IOException {
        super(file, append);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedFileOutputStream(File file, boolean append) throws IOException {
        super(file, append);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void com_wily_initialize() {
        block15: {
            Object tl = AgentShim.getAgentShimThreadLocal();
            if (AgentShim.isThreadInAgentCode(tl)) {
                return;
            }
            try {
                try {
                    AgentShim.setThreadInAgentCode(tl);
                    this.fIsWriting = new ThreadLocal();
                    if (sFileOutputRate != null) break block15;
                    Object object = sLock;
                    synchronized (object) {
                        if (sFileOutputRate == null && (sAgent = AgentShim.getAgent()) != null) {
                            sFileOutputRate = ManagedFileOutputStream.createAccumulator(sAgent);
                            if (sAgent instanceof ACommonAgent) {
                                sHasNewConfiguration = (Boolean)((ACommonAgent)ManagedFileOutputStream.sAgent).fAgentBlameConfigurationOldProperty.getValue();
                            }
                        }
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        AgentShim.handleError("Exception initializing ManagedFileOutputStream", t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                    AgentShim.clearThreadInAgentCode(tl);
                }
            }
            finally {
                AgentShim.clearThreadInAgentCode(tl);
            }
        }
    }

    private static IIntegerRateDataAccumulator createAccumulator(IAgent agent) {
        DataAccumulatorFactory factory = sAgent.IAgent_getDataAccumulatorFactory();
        return factory.safeGetIntegerRateDataAccumulator("File System:File Output Rate (Bytes Per Second)");
    }

    @Override
    public void write(int b) throws IOException {
        boolean shouldMeter;
        Object tl;
        block34: {
            tl = AgentShim.getAgentShimThreadLocal();
            if (AgentShim.isThreadInAgentCode(tl)) {
                super.write(b);
                return;
            }
            shouldMeter = false;
            try {
                try {
                    AgentShim.setThreadInAgentCode(tl);
                    shouldMeter = this.com_wily_shouldMeterThisCall();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        AgentShim.handleError("Exception recording write(int) to file output stream", t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                    AgentShim.clearThreadInAgentCode(tl);
                    break block34;
                }
            }
            catch (Throwable throwable) {
                AgentShim.clearThreadInAgentCode(tl);
                throw throwable;
            }
            AgentShim.clearThreadInAgentCode(tl);
        }
        try {
            super.write(b);
            AgentShim.setThreadInAgentCode(tl);
            try {
                if (shouldMeter) {
                    sFileOutputRate.IIntegerRateDataAccumulator_addSingleIncident(this.com_wily_getBlameStackSnapshot());
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception recording write(int) to file output stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable throwable) {
            try {
                if (shouldMeter) {
                    this.com_wily_doneMeteringThisCall();
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception recording write(int) to file output stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable2) {}
            }
            AgentShim.clearThreadInAgentCode(tl);
            throw throwable;
        }
        try {
            if (shouldMeter) {
                this.com_wily_doneMeteringThisCall();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception recording write(int) to file output stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        AgentShim.clearThreadInAgentCode(tl);
    }

    @Override
    public void write(byte[] b) throws IOException {
        boolean shouldMeter;
        Object tl;
        block34: {
            tl = AgentShim.getAgentShimThreadLocal();
            if (AgentShim.isThreadInAgentCode(tl)) {
                super.write(b);
                return;
            }
            shouldMeter = false;
            try {
                try {
                    AgentShim.setThreadInAgentCode(tl);
                    shouldMeter = this.com_wily_shouldMeterThisCall();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        AgentShim.handleError("Exception recording write(byte[]) to file output stream", t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                    AgentShim.clearThreadInAgentCode(tl);
                    break block34;
                }
            }
            catch (Throwable throwable) {
                AgentShim.clearThreadInAgentCode(tl);
                throw throwable;
            }
            AgentShim.clearThreadInAgentCode(tl);
        }
        try {
            super.write(b);
            AgentShim.setThreadInAgentCode(tl);
            try {
                if (shouldMeter) {
                    sFileOutputRate.IIntegerRateDataAccumulator_addBatchIncidents(b.length, this.com_wily_getBlameStackSnapshot());
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception recording write(byte[]) to file output stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable throwable) {
            try {
                if (shouldMeter) {
                    this.com_wily_doneMeteringThisCall();
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception recording write(byte[]) to file output stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable2) {}
            }
            AgentShim.clearThreadInAgentCode(tl);
            throw throwable;
        }
        try {
            if (shouldMeter) {
                this.com_wily_doneMeteringThisCall();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception recording write(byte[]) to file output stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        AgentShim.clearThreadInAgentCode(tl);
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        boolean shouldMeter;
        Object tl;
        block34: {
            tl = AgentShim.getAgentShimThreadLocal();
            if (AgentShim.isThreadInAgentCode(tl)) {
                super.write(b, offset, len);
                return;
            }
            shouldMeter = false;
            try {
                try {
                    AgentShim.setThreadInAgentCode(tl);
                    shouldMeter = this.com_wily_shouldMeterThisCall();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        AgentShim.handleError("Exception recording write(byte[],int,int) to file output stream", t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                    AgentShim.clearThreadInAgentCode(tl);
                    break block34;
                }
            }
            catch (Throwable throwable) {
                AgentShim.clearThreadInAgentCode(tl);
                throw throwable;
            }
            AgentShim.clearThreadInAgentCode(tl);
        }
        try {
            super.write(b, offset, len);
            AgentShim.setThreadInAgentCode(tl);
            try {
                if (shouldMeter) {
                    sFileOutputRate.IIntegerRateDataAccumulator_addBatchIncidents(len, this.com_wily_getBlameStackSnapshot());
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception recording write(byte[],int,int) to file output stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable throwable) {
            try {
                if (shouldMeter) {
                    this.com_wily_doneMeteringThisCall();
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception recording write(byte[],int,int) to file output stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable2) {}
            }
            AgentShim.clearThreadInAgentCode(tl);
            throw throwable;
        }
        try {
            if (shouldMeter) {
                this.com_wily_doneMeteringThisCall();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception recording write(byte[],int,int) to file output stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        AgentShim.clearThreadInAgentCode(tl);
    }

    private final BlameStackSnapshot com_wily_getBlameStackSnapshot() {
        if (sHasNewConfiguration) {
            return BlameStackSnapshot.kEmptyBlameStackSnapshot;
        }
        try {
            ComponentTracer componentTracer = AgentShim.getAgent().IAgent_getComponentTracer();
            if (componentTracer != null) {
                return componentTracer.getSnapshot(ComponentTracer.kNoComponent);
            }
        }
        catch (AgentNotAvailableException anae) {
            AgentShim.handleError("Unable to access component tracer", anae);
        }
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    private final boolean com_wily_shouldMeterThisCall() {
        boolean shouldMeter;
        boolean bl = shouldMeter = sFileOutputRate != null;
        if (shouldMeter) {
            boolean bl2 = shouldMeter = this.fIsWriting != null && this.fIsWriting.get() != Boolean.TRUE;
            if (shouldMeter) {
                AgentMetric metric = sFileOutputRate.IDataAccumulator_getMetric();
                boolean bl3 = shouldMeter = !sAgent.IAgent_isMetricShutOff(metric);
                if (shouldMeter) {
                    this.fIsWriting.set(Boolean.TRUE);
                }
            }
        }
        return shouldMeter;
    }

    private final void com_wily_doneMeteringThisCall() {
        Assertion.wilyAssert(false);
        this.fIsWriting.set(Boolean.FALSE);
    }

    public static void setInWilyCallInThread() {
        fIsInWilyCall.set(Boolean.TRUE);
    }

    public static void unsetInWilyCallInThread() {
        fIsInWilyCall.set(Boolean.FALSE);
    }

    public static boolean isInWilyCallInThread() {
        Object o = fIsInWilyCall.get();
        return Boolean.TRUE == o;
    }
}

