/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties;

import com.wily.EDU.oswego.cs.dl.util.concurrent.Executor;
import com.wily.util.event.AListenerClosureRunnable;
import com.wily.util.event.AddToCollectionRunnable;
import com.wily.util.event.IListenerClosure;
import com.wily.util.event.RemoveFromCollectionRunnable;
import com.wily.util.exception.UnexpectedExceptionError;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IPropertiesHandler;
import com.wily.util.properties.IPropertyEventListener;
import com.wily.util.properties.PropertyEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;

public class PropertyChangeNotifier {
    private final Executor fExecutor;
    private final Vector fListeners;
    private final IPropertiesHandler fHandler;

    public PropertyChangeNotifier(IModuleFeedbackChannel feedback, Executor executor, IPropertiesHandler handler) {
        this.fExecutor = executor;
        this.fListeners = new Vector();
        this.fHandler = handler;
    }

    public synchronized void noticePropertyChange(Object key, Object oldValue, Object newValue) {
        this.broadcastNotifyNewPropertyValue((String)key, (String)oldValue, (String)newValue, false);
    }

    public synchronized void noticeIndexedPropertyChange(Object key, Object oldValue, Object newValue) {
        this.broadcastNotifyNewPropertyValue((String)key, (String)oldValue, (String)newValue, true);
    }

    public synchronized void addBroadcastListenerWithRewind(IPropertyEventListener listener) {
        this.propertiesRewind(listener);
        this.execute(new AddToCollectionRunnable(this.fListeners, listener));
    }

    public synchronized void removeBroadcastListener(IPropertyEventListener listener) {
        this.execute(new RemoveFromCollectionRunnable(this.fListeners, listener));
    }

    private void execute(Runnable runnable) {
        try {
            this.fExecutor.execute(runnable);
        }
        catch (InterruptedException e) {
            throw new UnexpectedExceptionError(e);
        }
    }

    private IListenerClosure getNotifyNewPropertyValueClosure(String key, String previousValue, String currentValue, boolean isIndexed) {
        final PropertyEvent newValueEvent = this.getNewPropertyValueEvent(key, previousValue, currentValue, isIndexed);
        return new IListenerClosure(){

            @Override
            public void execute(EventListener listener) {
                ((IPropertyEventListener)listener).preferenceValuesChanged(new PropertyEvent[]{newValueEvent});
            }
        };
    }

    private IPropertyEventListener[] getListenerSnapshot() {
        return this.fListeners.toArray(new IPropertyEventListener[0]);
    }

    private void broadcastNotifyNewPropertyValue(String key, String previousValue, String currentValue, boolean isIndexed) {
        this.execute(new AListenerClosureRunnable(this.getNotifyNewPropertyValueClosure(key, previousValue, currentValue, isIndexed)){

            @Override
            protected EventListener[] getEventListeners() {
                return PropertyChangeNotifier.this.getListenerSnapshot();
            }
        });
    }

    private PropertyEvent getNewPropertyValueEvent(String key, String previousValue, String currentValue, boolean isIndexed) {
        PropertyEvent newValueEvent = new PropertyEvent(110001, key, previousValue, currentValue, isIndexed);
        return newValueEvent;
    }

    private void propertiesRewind(final IPropertyEventListener listener) {
        if (this.fHandler.IPropertiesHandler_supportsRewind()) {
            final ArrayList<PropertyEvent> events = new ArrayList<PropertyEvent>();
            Enumeration keys = this.fHandler.IPropertiesHandler_getKeys();
            while (keys.hasMoreElements()) {
                String currentKey = (String)keys.nextElement();
                events.add(this.getNewPropertyValueEvent(currentKey, null, this.fHandler.IPropertiesHandler_getValue(currentKey), false));
            }
            this.execute(new Runnable(){

                @Override
                public void run() {
                    listener.preferenceValuesChanged(events.toArray(new PropertyEvent[0]));
                }
            });
        }
    }
}

