/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.selection;

import com.toedter.calendar.JCalendar;
import com.wily.ui.WilyUIUtilities;
import com.wily.ui.selection.Messages;
import com.wily.util.datetime.DateFormatException;
import com.wily.util.datetime.DateParser;
import com.wily.util.datetime.DateRangeParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class DateTimeSelector
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    public static final Date NOW_TIME = new Date(DateRangeParser.NOW);
    public static final String NOW_STRING = Messages.getString("DateSelector.NowDateValue");
    protected JButton calendarButton;
    protected JCalendar jcalendar;
    protected JPopupMenu popup;
    protected SimpleDateFormat dateFormatter;
    protected boolean dateSelected;
    private Date currentDate;
    private JTextField dateField;
    private List actionHandlers = new ArrayList();

    public DateTimeSelector() {
        this.jcalendar = new JCalendar();
        this.setLayout(new BorderLayout());
        this.setLocale(Locale.getDefault());
        this.jcalendar.getDayChooser().addPropertyChangeListener((PropertyChangeListener)this);
        this.jcalendar.getDayChooser().setAlwaysFireDayProperty(true);
        this.dateField = new JTextField(this.dateFormatter.toLocalizedPattern().length());
        FontMetrics fm = this.dateField.getFontMetrics(this.dateField.getFont());
        int stringWidth = fm.stringWidth(this.dateFormatter.toLocalizedPattern()) + 45;
        int stringHeight = fm.getHeight();
        this.dateField.setMinimumSize(new Dimension(stringWidth, stringHeight));
        this.dateField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DateTimeSelector.this.leaveTextField();
            }
        });
        this.add((Component)this.dateField, "Center");
        URL iconURL = this.getClass().getResource("calendar.png");
        ImageIcon icon = new ImageIcon(iconURL);
        this.calendarButton = new JButton(icon);
        this.calendarButton.setMargin(new Insets(0, 0, 0, 0));
        this.calendarButton.addMouseListener(new CalendarButtonHandler());
        this.calendarButton.setToolTipText(Messages.getString("DateTimeSelector.buttonToolTip"));
        this.calendarButton.setMnemonic(67);
        this.add((Component)this.calendarButton, "East");
        this.calendarButton.setMargin(new Insets(0, 0, 0, 0));
        this.popup = new JPopupMenu(){
            private static final long serialVersionUID = 8576609049658976435L;

            public void setVisible(boolean b) {
                Boolean isCanceled = (Boolean)this.getClientProperty("JPopupMenu.firePopupMenuCanceled");
                if (b || !b && DateTimeSelector.this.dateSelected || isCanceled != null && !b && isCanceled.booleanValue()) {
                    super.setVisible(b);
                }
            }
        };
        this.popup.setLightWeightPopupEnabled(true);
        this.popup.add((Component)this.jcalendar);
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.dateField.setEnabled(b);
        this.calendarButton.setEnabled(b);
    }

    public void setToolTipText(String v) {
        super.setToolTipText(v);
        this.dateField.setToolTipText(v);
    }

    protected void leaveTextField() {
        try {
            this.updateDateFromText();
        }
        catch (DateFormatException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), Messages.getString("DateSelector.EntryError"), 0);
        }
    }

    protected boolean updateDateFromText() throws DateFormatException {
        String text = this.dateField.getText().trim();
        Date newDate = this.currentDate;
        if (text.equalsIgnoreCase(NOW_STRING)) {
            newDate = NOW_TIME;
            this.dateField.setText(NOW_STRING);
        } else if (text.length() == 0) {
            newDate = null;
        } else {
            try {
                newDate = DateParser.getInstance().parseTimestamp(text);
            }
            catch (DateFormatException e) {
                Calendar sample = Calendar.getInstance();
                sample.set(1999, 2, 31, 11, 30);
                throw new DateFormatException(Messages.getString("DateSelector.InvalidDateMessage", text, this.dateFormatter.format(sample.getTime()), NOW_STRING));
            }
        }
        if (newDate == this.currentDate || newDate != null && newDate.equals(this.currentDate)) {
            return false;
        }
        this.currentDate = newDate;
        this.updateText();
        this.fireDateUpdatedEvent();
        return true;
    }

    private void initDateFormatter(Locale locale) {
        this.dateFormatter = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, locale);
    }

    public void showCalendar() {
        int x = this.calendarButton.getWidth() - (int)this.popup.getPreferredSize().getWidth();
        int y = this.calendarButton.getY() + this.calendarButton.getHeight();
        try {
            this.updateDateFromText();
        }
        catch (DateFormatException dateFormatException) {
            // empty catch block
        }
        if (this.currentDate != null && !this.currentDate.equals(NOW_TIME)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.currentDate);
            this.jcalendar.setCalendar(calendar);
        }
        this.popup.show(this.calendarButton, x, y);
        this.dateSelected = false;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("day")) {
            this.dateSelected = true;
            this.popup.setVisible(false);
            this.setDate(this.jcalendar.getCalendar().getTime());
        }
        this.fireDateUpdatedEvent();
    }

    public void updateUI() {
        super.updateUI();
        if (this.jcalendar != null) {
            SwingUtilities.updateComponentTreeUI(this.popup);
        }
    }

    public void setLocale(Locale l) {
        this.jcalendar.setLocale(l);
        this.initDateFormatter(l);
    }

    public String getName() {
        return "DateSelector";
    }

    public Date getDate() throws DateFormatException {
        this.updateDateFromText();
        return this.currentDate;
    }

    public void setDate(Date date) {
        this.currentDate = date;
        this.updateText();
    }

    public synchronized void addActionListener(ActionListener l) {
        ArrayList<ActionListener> handlers = new ArrayList<ActionListener>(this.actionHandlers);
        handlers.add(l);
        this.actionHandlers = handlers;
    }

    private void fireDateUpdatedEvent() {
        ActionEvent e = new ActionEvent(this, 1001, "Date Changed");
        Iterator i = this.actionHandlers.iterator();
        while (i.hasNext()) {
            ((ActionListener)i.next()).actionPerformed(e);
        }
    }

    private void updateText() {
        if (this.currentDate == null) {
            this.dateField.setText("");
        } else if (this.currentDate.equals(NOW_TIME)) {
            this.dateField.setText(NOW_STRING);
        } else {
            this.dateField.setText(this.dateFormatter.format(this.currentDate));
        }
    }

    public static void main(String[] a) {
        WilyUIUtilities.setLookAndFeel();
        JFrame frame = new JFrame("DateChooser");
        final JPanel p = new JPanel(new GridLayout(-1, 1));
        final DateTimeSelector s = new DateTimeSelector();
        JButton button = new JButton("show");
        p.add(s);
        p.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JOptionPane.showMessageDialog(p, "date: " + s.getDate());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(p, "Error in date: {0} " + ex);
                }
            }
        });
        frame.getContentPane().add(p);
        frame.pack();
        frame.setVisible(true);
    }

    private class CalendarButtonHandler
    extends MouseAdapter {
        private boolean popupAlreadyOpen;

        private CalendarButtonHandler() {
        }

        public void mousePressed(MouseEvent e) {
            this.popupAlreadyOpen = DateTimeSelector.this.popup.isVisible();
        }

        public void mouseReleased(MouseEvent e) {
            if (this.popupAlreadyOpen) {
                DateTimeSelector.this.popup.setVisible(false);
                this.popupAlreadyOpen = false;
            } else {
                DateTimeSelector.this.showCalendar();
            }
        }
    }
}

