/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback;

import com.wily.util.ConfigurationWatcher;
import com.wily.util.feedback.ABufferedApplicationFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.feedback.WilyLog4JConfigureAndWatchHelper;
import com.wily.util.feedback.backend.NativeFeedbackBackend;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.resource.IResource;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;

public class AsynchFeedbackChannel
extends ABufferedApplicationFeedbackChannel {
    private IRegisteredBehavior fAsyncLoggingBehavior;
    private IntervalHeartbeat fAsyncLoggingHeartbeat;
    public static final String kDisableAsyncLoggingKey = "com.wily.introscope.disableAsyncLogging";
    public static final String kDelayLoggingKey = "com.wily.introscope.delayLoggingInMillis";
    private static final int kLoggingIntervalInMillis = 1000;
    private static AsyncLoggingBehavior sAsyncLoggingBehavior = null;
    private static boolean sShouldLogAsync = true;

    public AsynchFeedbackChannel(String applicationName) {
        super(applicationName);
    }

    public AsynchFeedbackChannel(String applicationName, String defaultOutputTarget) {
        super(applicationName, null, defaultOutputTarget);
        this.fAsyncLoggingBehavior = null;
    }

    public final void setConfiguration(ConfigurationWatcher watcher, IResource configurationResource) {
        WilyLog4JConfigureAndWatchHelper listener = new WilyLog4JConfigureAndWatchHelper(configurationResource);
        watcher.addConfigurationListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAsyncLoggingToHeartbeat(IntervalHeartbeat heartbeat) {
        Assertion.wilyAssert(heartbeat != null);
        long loggingDelayInMillis = 0L;
        try {
            String delayString = System.getProperty(kDelayLoggingKey);
            if (delayString != null) {
                loggingDelayInMillis = Long.parseLong(delayString);
            }
        }
        catch (NumberFormatException nfe) {
            this.warn("Invalid numeric value for property com.wily.introscope.delayLoggingInMillis, ignoring");
        }
        catch (Exception e) {
            this.error("setLoggingHeartbeat", e);
        }
        String disableAsyncLoggingStr = null;
        try {
            disableAsyncLoggingStr = System.getProperty(kDisableAsyncLoggingKey);
        }
        catch (RuntimeException re) {
            this.error("setLoggingHeartbeat", re);
        }
        boolean shouldLogAsync = Boolean.valueOf(disableAsyncLoggingStr) == false;
        AsyncLoggingBehavior loggingBehavior = new AsyncLoggingBehavior();
        Object object = this.getFeedbackChannelLock();
        synchronized (object) {
            if (sAsyncLoggingBehavior != null) {
                this.warn("Async Logging Behavior already set.");
                return;
            }
            sShouldLogAsync = shouldLogAsync;
            if (!sShouldLogAsync) {
                this.debug("Async Logging Disabled");
                return;
            }
            sAsyncLoggingBehavior = loggingBehavior;
        }
        this.fAsyncLoggingHeartbeat = heartbeat;
        if (loggingDelayInMillis <= 0L) {
            this.doAddAsyncLoggingToHeartbeat(heartbeat);
            this.setShouldBuffer(false);
        } else {
            SimpleDelayBehavior behavior = new SimpleDelayBehavior(this, heartbeat);
            heartbeat.addBehavior(behavior, "Async Logging Delay", true, loggingDelayInMillis, false, 1);
        }
    }

    private void doAddAsyncLoggingToHeartbeat(IntervalHeartbeat heartbeat) {
        this.fAsyncLoggingBehavior = this.fAsyncLoggingHeartbeat.addBehavior((ITimestampedRunnable)sAsyncLoggingBehavior, "Async Logging", true, 1000L, false);
    }

    public void removeAsyncLoggingFromHeartbeat() {
        try {
            if (this.fAsyncLoggingHeartbeat != null) {
                this.fAsyncLoggingHeartbeat.removeBehavior(this.fAsyncLoggingBehavior);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void doLog(SeverityLevel severity, Module module, String message, Throwable t, boolean forceImmediate) {
        if (message == null) {
            message = "\n";
        }
        Object actualLogger = this.getActualLogger(module);
        if (!forceImmediate && sAsyncLoggingBehavior != null && sShouldLogAsync) {
            sAsyncLoggingBehavior.log(actualLogger, severity, message, t);
        } else {
            NativeFeedbackBackend.getNativeFeedbackBackend().log(actualLogger, severity, message, t);
        }
    }

    private static class AsyncLoggingBehavior
    implements ITimestampedRunnable {
        ArrayList fLogs = new ArrayList();

        private AsyncLoggingBehavior() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ITimestampedRunnable_execute(long nowInMillis) {
            LogInfo[] logs = null;
            ArrayList arrayList = this.fLogs;
            synchronized (arrayList) {
                logs = this.fLogs.toArray(LogInfo.kZeroLengthArray);
                this.fLogs.clear();
            }
            if (logs == null) {
                return;
            }
            for (int i = 0; i < logs.length; ++i) {
                NativeFeedbackBackend.getNativeFeedbackBackend().log(logs[i].getLogger(), logs[i].getSeverity(), logs[i].getMessage(), logs[i].getThrowable());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void log(Object logger, SeverityLevel severity, String message, Throwable t) {
            Assertion.wilyAssert(logger != null, "null logger in AsyncLoggingBehavior.log");
            LogInfo logInfo = new LogInfo(logger, severity, message, t);
            ArrayList arrayList = this.fLogs;
            synchronized (arrayList) {
                this.fLogs.add(logInfo);
            }
        }
    }

    private static class SimpleDelayBehavior
    implements ITimestampedRunnable {
        private IntervalHeartbeat fHeartbeat;
        private AsynchFeedbackChannel fParent;

        public SimpleDelayBehavior(AsynchFeedbackChannel parent, IntervalHeartbeat heartbeat) {
            this.fParent = parent;
            this.fHeartbeat = heartbeat;
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            this.fParent.doAddAsyncLoggingToHeartbeat(this.fHeartbeat);
            this.fParent.setShouldBuffer(false);
        }
    }

    private static class LogInfo {
        public static final LogInfo[] kZeroLengthArray = new LogInfo[0];
        private Object fLogger;
        private SeverityLevel fSeverity;
        private String fMessage;
        private Throwable fThrowable;

        public LogInfo(Object logger, SeverityLevel severity, String message, Throwable t) {
            this.fLogger = logger;
            this.fSeverity = severity;
            this.fMessage = message;
            this.fThrowable = t;
        }

        public Object getLogger() {
            return this.fLogger;
        }

        public SeverityLevel getSeverity() {
            return this.fSeverity;
        }

        public String getMessage() {
            return this.fMessage;
        }

        public Throwable getThrowable() {
            return this.fThrowable;
        }
    }
}

