/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class NumberFormatter {
    public static final long EXA = 0x1000000000000000L;
    public static final long PETA = 0x4000000000000L;
    public static final long TERA = 0x10000000000L;
    public static final int GIGA = 0x40000000;
    public static final int MEGA = 0x100000;
    public static final int KILO = 1024;
    public static final int NONE = 1;
    public static final String EXA_SUFFIX = "E";
    public static final String PETA_SUFFIX = "P";
    public static final String TERA_SUFFIX = "T";
    public static final String GIGA_SUFFIX = "G";
    public static final String MEGA_SUFFIX = "M";
    public static final String KILO_SUFFIX = "K";
    public static final String NONE_SUFFIX = "";
    private static NumberFormat sFormat = new DecimalFormat();
    private static final int kDefaultDecimalPlaces = 1;

    public static String getNumericalString(long value) {
        return Long.toString(value);
    }

    public static String getNumericalApproximationString(long value) {
        String suffix = NONE_SUFFIX;
        long scale = 1L;
        long absvalue = Math.abs(value);
        if (absvalue >= 0x10000000000L) {
            scale = 0x10000000000L;
            suffix = TERA_SUFFIX;
        } else if (absvalue >= 0x40000000L) {
            scale = 0x40000000L;
            suffix = GIGA_SUFFIX;
        } else if (absvalue >= 0x100000L) {
            scale = 0x100000L;
            suffix = MEGA_SUFFIX;
        } else if (absvalue >= 1024L) {
            scale = 1024L;
            suffix = KILO_SUFFIX;
        }
        if (scale == 1L) {
            return NumberFormatter.getNumericalString(value / scale) + suffix;
        }
        return NumberFormatter.getNumericalString((double)value / (double)scale, 1) + suffix;
    }

    public static String getNumericalString(double value) {
        return Double.toString(value);
    }

    public static String getNumericalString(double value, int numDecimalPlaces) {
        if (numDecimalPlaces == 1) {
            return sFormat.format(value);
        }
        DecimalFormat format = new DecimalFormat();
        format.setMaximumFractionDigits(numDecimalPlaces);
        return format.format(value);
    }

    public static String getNumericalApproximationString(double value) {
        return NumberFormatter.getNumericalApproximationString(value, false, 0);
    }

    public static String getNumericalApproximationString(double value, int numDecimalPlaces) {
        return NumberFormatter.getNumericalApproximationString(value, true, numDecimalPlaces);
    }

    private static String getNumericalApproximationString(double value, boolean round, int numDecimalPlaces) {
        String suffix = NONE_SUFFIX;
        long scale = 1L;
        double absvalue = Math.abs(value);
        if (absvalue >= 1.099511627776E12) {
            scale = 0x10000000000L;
            suffix = TERA_SUFFIX;
        } else if (absvalue >= 1.073741824E9) {
            scale = 0x40000000L;
            suffix = GIGA_SUFFIX;
        } else if (absvalue >= 1048576.0) {
            scale = 0x100000L;
            suffix = MEGA_SUFFIX;
        } else if (absvalue >= 1024.0) {
            scale = 1024L;
            suffix = KILO_SUFFIX;
        }
        if (round) {
            return NumberFormatter.getNumericalString(value / (double)scale, numDecimalPlaces) + suffix;
        }
        return NumberFormatter.getNumericalString(value / (double)scale) + suffix;
    }

    static {
        sFormat.setMaximumFractionDigits(1);
    }
}

