/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.websphere;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.JAXWSNameFormatter;
import java.util.Map;

public class JAXWSAsynchClientFormatter
extends JAXWSNameFormatter
implements KConstants {
    public JAXWSAsynchClientFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    public final String getServiceName(InvocationData data) {
        String currServiceName;
        try {
            Object listenerObj = data.getInvocationObject();
            Object handlerObj = WSMUtils.invokeMethodOnObject(listenerObj, "getHandler");
            Object objRequestContext = WSMUtils.invokeMethodOnObject(handlerObj, "getRequestContext");
            Map mapRequestContext = (Map)objRequestContext;
            currServiceName = (String)mapRequestContext.get("javax.xml.ws.service.endpoint.address");
            this.logger.debug("mapRequestContext:" + mapRequestContext);
            this.logger.debug("serviceName:" + currServiceName);
            this.logger.debug("JAXWSProxyHandlerNameFormatter.getServiceName()");
            if (currServiceName == null) {
                currServiceName = "UnknownService";
            }
        }
        catch (Exception exception) {
            return "UnknownService";
        }
        return currServiceName;
    }

    @Override
    public final String getOperationName(InvocationData data) {
        Object listenerObj = data.getInvocationObject();
        try {
            Object handlerObj = WSMUtils.invokeMethodOnObject(listenerObj, "getHandler");
            Map reqctxtobj = (Map)WSMUtils.invokeMethodOnObject(handlerObj, "getRequestContext");
            Object opNameObj = reqctxtobj.get("soa_asynch_opname");
            if (opNameObj != null) {
                return opNameObj.toString();
            }
            return "UnknownOperationName";
        }
        catch (Throwable e) {
            this.logger.info("ClientAsynchTracer:Error in retreiving from request context", e);
            return "UnknownOperationName";
        }
    }

    @Override
    public final String getNamespace(InvocationData data) {
        try {
            Object listenerObj = data.getInvocationObject();
            Object handlerObj = WSMUtils.invokeMethodOnObject(listenerObj, "getHandler");
            Object objServiceDelegate = WSMUtils.invokeMethodOnObject(handlerObj, "getServiceDelegate");
            Object serviceQName = WSMUtils.invokeMethodOnObject(objServiceDelegate, "getServiceName");
            String currNamespace = (String)WSMUtils.invokeMethodOnObject(serviceQName, "getNamespaceURI()");
            if (currNamespace != null) {
                return currNamespace;
            }
            return this.getServiceName(data);
        }
        catch (Exception exception) {
            return this.getServiceName(data);
        }
    }
}

