/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ObjectCounterInputStream
extends FilterInputStream {
    private final byte[] fBuffer = new byte[4];
    private int fCurrBufferIndex;
    private int fCount;
    private boolean fIsClosed;
    private int fNumBytesToNextObject;
    private int fCurrObjectSizeAndLength;
    private int fLastObjectSizeAndLength;

    public ObjectCounterInputStream(InputStream in) {
        super(in);
    }

    public int getCount() {
        return this.fCount >> 1;
    }

    public int getOverflow() {
        int overflow = this.fCurrObjectSizeAndLength - this.fNumBytesToNextObject;
        if ((this.fCount & 1) == 1) {
            overflow += this.fLastObjectSizeAndLength;
        }
        return overflow;
    }

    public int read() throws IOException {
        int val = this.in.read();
        if (val != -1) {
            if (this.fNumBytesToNextObject == 0) {
                this.fBuffer[this.fCurrBufferIndex++] = (byte)val;
                ++this.fCurrObjectSizeAndLength;
                if (this.fCurrBufferIndex == 4) {
                    this.fNumBytesToNextObject = (this.fBuffer[0] & 0xFF) << 24 | (this.fBuffer[1] & 0xFF) << 16 | (this.fBuffer[2] & 0xFF) << 8 | this.fBuffer[3] & 0xFF;
                    this.fCurrObjectSizeAndLength += this.fNumBytesToNextObject;
                    this.fCurrBufferIndex = 0;
                }
            } else if (--this.fNumBytesToNextObject == 0) {
                this.fLastObjectSizeAndLength = this.fCurrObjectSizeAndLength;
                this.fCurrObjectSizeAndLength = 0;
                ++this.fCount;
            }
        }
        return val;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int num = this.in.read(b, off, len);
        if (num == -1) {
            return -1;
        }
        int l = off + num;
        for (int i = off; i < l; ++i) {
            if (this.fNumBytesToNextObject == 0) {
                this.fBuffer[this.fCurrBufferIndex++] = b[i];
                ++this.fCurrObjectSizeAndLength;
                if (this.fCurrBufferIndex != 4) continue;
                this.fNumBytesToNextObject = (this.fBuffer[0] & 0xFF) << 24 | (this.fBuffer[1] & 0xFF) << 16 | (this.fBuffer[2] & 0xFF) << 8 | this.fBuffer[3] & 0xFF;
                this.fCurrObjectSizeAndLength += this.fNumBytesToNextObject;
                this.fCurrBufferIndex = 0;
                continue;
            }
            int remainingLoops = l - i;
            if (remainingLoops >= this.fNumBytesToNextObject) {
                i += this.fNumBytesToNextObject - 1;
                this.fNumBytesToNextObject = 0;
                this.fLastObjectSizeAndLength = this.fCurrObjectSizeAndLength;
                this.fCurrObjectSizeAndLength = 0;
                ++this.fCount;
                continue;
            }
            this.fNumBytesToNextObject -= remainingLoops;
            break;
        }
        return num;
    }

    public void resetCount() {
        this.fCount = (this.fCount & 1) == 1 ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            this.fIsClosed = true;
        }
    }

    public boolean isClosed() {
        return this.fIsClosed;
    }
}

