/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent.frontend;

import com.wily.agent.main.IIntelligentInstrumentationTracerHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.agent.trace.intelligent.frontend.FrontendCandidate;
import com.wily.introscope.agent.trace.intelligent.frontend.FrontendCandidatePerformance;
import com.wily.introscope.agent.trace.intelligent.frontend.InitialFrontEndCandidate;
import com.wily.util.adt.ICappedMap;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.adt.WeakIdentityKey;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.classfile.java.MethodName;
import com.wily.util.clock.MasterClock;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class FrontEndCandidateAnalyzer {
    public static final short AUTO_FRONTEND_METHOD_SCORE = 2000;
    public static final short INSTRUMENTED_STILL_INSTRUMENTED = 1;
    public static final int SCORE_INDEX = 0;
    public static final int ID_INDEX = 1;
    public static final int STATE_INDEX = 2;
    public static volatile boolean sIsInitialized = false;
    public static volatile boolean sReceivedShutdownNotice = false;
    static IRegisteredBehavior sInitialCandidateProcessor = null;
    static IRegisteredBehavior sMonitoredCandidateProcessor = null;
    public static final String NULL_DESCRIPTOR = null;
    public static ConcurrentHashMap<Integer, InitialFrontEndCandidate> fInitalFrontendMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<Integer, FrontendCandidatePerformance> fCandidatePerformanceMap = new ConcurrentHashMap();
    public static IWeakIdentityMap fDeepStacks;
    private static IAgent fAgent;
    private static volatile IIntelligentInstrumentationTracerHelper fHelper;
    private static volatile long sInitialCandidateProcessorInterval;
    private static volatile long sMonitoredCandidateProcessorInterval;
    public static int sFrontendCandidateTxCountThreshold;
    public static long fFrontendCandidateStallThreshold;
    public static long fFrontendCandidateInactivityThreshold;
    public static long fPseudoCandidateInstrumentationTimeThreshold;

    static {
        sInitialCandidateProcessorInterval = 60000L;
        sMonitoredCandidateProcessorInterval = 60000L;
        sFrontendCandidateTxCountThreshold = 100;
        fFrontendCandidateStallThreshold = 300000L;
        fFrontendCandidateInactivityThreshold = 600000L;
        fPseudoCandidateInstrumentationTimeThreshold = 180000L;
    }

    public static void initialize(IAgent agent) {
        if (!sIsInitialized && !sReceivedShutdownNotice) {
            IConcurrentMapFactory factory;
            fAgent = agent;
            sInitialCandidateProcessor = fAgent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)new InitialEntryPointCandidateProcessor(), "InitialFrontendCandidateProcessor", true, sInitialCandidateProcessorInterval, false);
            sMonitoredCandidateProcessor = fAgent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)new MonitoredFrontendCandidateProcessor(), "MonitoredFrontendCandidateProcessor", true, sMonitoredCandidateProcessorInterval, false);
            sIsInitialized = true;
            if (fAgent != null && (factory = agent.IAgent_getConcurrentMapFactory()) != null) {
                fDeepStacks = factory.getConcurrentCappedWeakIdentityMap("DeepStack");
            }
        }
    }

    public static void reset() {
        sIsInitialized = false;
        sReceivedShutdownNotice = false;
    }

    public static boolean isInitialized() {
        return sIsInitialized;
    }

    public static void setInitialCandidateProcessorInterval(long intervalInSeconds) {
        sInitialCandidateProcessorInterval = TimeUnit.MILLISECONDS.convert(intervalInSeconds, TimeUnit.SECONDS);
    }

    public static void setMonitoredCandidateProcessorInterval(long intervalInSeconds) {
        sMonitoredCandidateProcessorInterval = TimeUnit.MILLISECONDS.convert(intervalInSeconds, TimeUnit.SECONDS);
    }

    public static FrontendCandidatePerformance getFrontendCandidatePerformance(int probeIndex) {
        return fCandidatePerformanceMap.get(probeIndex);
    }

    public static FrontendCandidatePerformance addFrontendCandidatePerformance(int probeIndex) {
        FrontendCandidatePerformance fecp = new FrontendCandidatePerformance(probeIndex);
        fecp = fCandidatePerformanceMap.putIfAbsent(probeIndex, fecp);
        if (fecp == null) {
            SustainabilityMetricsHelper.reportTrackedCandidate();
        }
        return fecp;
    }

    public static void registerDeepStack(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack) {
        if (fDeepStacks != null) {
            fDeepStacks.putWeak(deepStack, Boolean.TRUE);
        }
    }

    public static void analyzeCompletedTransaction() {
        Logger.logTraceMessage("Analyzing Entry Point Candidate Performance Data : - Started");
        long currentTime = MasterClock.currentTimeMillis();
        long stuckPseudoCandidateTimeStampCuttOff = currentTime - fPseudoCandidateInstrumentationTimeThreshold;
        long stuckCandidateTimeStampCuttOff = currentTime - fFrontendCandidateInactivityThreshold;
        for (Integer key : fCandidatePerformanceMap.keySet()) {
            FrontendCandidatePerformance fec = fCandidatePerformanceMap.get(key);
            if (fec == null) continue;
            int txNum = fec.getCompletedTransactionCount();
            long timeStamp = fec.getTimeStamp();
            String[] probeEntry = fHelper.getIntelligentInstrumentationInfoForSequentialHashCode(key);
            if (Logger.isTraceEnabled()) {
                Logger.logTraceMessage("Entry Point Candidate: " + key + " " + probeEntry[0] + ":" + probeEntry[1] + " " + probeEntry[2] + "[count = " + txNum + ", age = " + (currentTime - timeStamp) + "]");
            }
            if (txNum > sFrontendCandidateTxCountThreshold) {
                if (FrontendCandidate.FrontEndCandidateState.PSEUDOFRONTEND.toString() == probeEntry[6]) {
                    if (timeStamp >= stuckPseudoCandidateTimeStampCuttOff) continue;
                    fHelper.setEntryPointStateForMethod(key, FrontendCandidate.FrontEndCandidateState.INSTRUMENTED.toString());
                    fCandidatePerformanceMap.remove(key);
                    continue;
                }
                if (FrontendCandidate.FrontEndCandidateState.IDENTIFIED.toString() == probeEntry[6] || FrontendCandidate.FrontEndCandidateState.REJECTED.toString() == probeEntry[6]) {
                    fCandidatePerformanceMap.remove(key);
                    continue;
                }
                fHelper.markMethodAsPseudoFrontendAndPersist(key, FrontendCandidate.FrontEndCandidateState.PSEUDOFRONTEND.toString());
                fec.resetTime();
                Logger.logDebugMessage("Entry Point Identified: " + key + " " + probeEntry[0] + ":" + probeEntry[1] + " " + probeEntry[2]);
                SustainabilityMetricsHelper.reportIdentifiedEntryPoint();
                continue;
            }
            if (txNum != 0 || timeStamp >= stuckCandidateTimeStampCuttOff) continue;
            fHelper.setEntryPointStateForMethod(key, FrontendCandidate.FrontEndCandidateState.INSTRUMENTED.toString());
            Logger.logDebugMessage("Removed  Inactive Frontend Candidate: " + key + " " + probeEntry[0] + ":" + probeEntry[1] + " " + probeEntry[2]);
            fCandidatePerformanceMap.remove(key);
        }
        Logger.logTraceMessage("Analyzing Entry Point Candidate Performance Data : - Completed");
    }

    public static void sweepDeepStacksForStuckFrontendCandidates() {
        Logger.logTraceMessage("Sweeping deep stacks for stuck entry point candidates: - Started");
        long currentTime = System.currentTimeMillis();
        final long stuckCandidateStartTimeCuttOff = currentTime - fFrontendCandidateStallThreshold;
        if (fDeepStacks != null) {
            fDeepStacks.iterateThrougEntries(new ICappedMap.IOperateOnEntry(){

                @Override
                public void doOnEntry(Map.Entry entry) {
                    FrontendCandidate candidate;
                    int probeInfo;
                    WeakIdentityKey wk = (WeakIdentityKey)entry.getKey();
                    HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = (HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack)wk.get();
                    if (deepStack != null && (probeInfo = (candidate = deepStack.getFrontendCandidate()).getProbeInfoIndex()) > -1 && candidate.getTimestamp() < stuckCandidateStartTimeCuttOff) {
                        fHelper.setEntryPointStateForMethod(probeInfo, FrontendCandidate.FrontEndCandidateState.REJECTED.toString());
                        String[] probeEntry = fHelper.getIntelligentInstrumentationInfoForSequentialHashCode(probeInfo);
                        Logger.logDebugMessage("Blacklisted  Stuck Frontend Candidate: " + probeInfo + " " + probeEntry[0] + ":" + probeEntry[1] + " " + probeEntry[2]);
                        candidate.reset();
                        if (fCandidatePerformanceMap.remove(probeInfo) != null) {
                            SustainabilityMetricsHelper.reportBlacklistedCandidate();
                        }
                    }
                }
            });
        }
        Logger.logTraceMessage("Sweeping deep stacks for stuck entry point candidates: - Completed");
    }

    public static void addInitialFrontEndCandidate(String className, String methodName, String desc) {
        Logger.logDebugMessage("Initial Entry Point Candidate from stack: " + className + ":" + methodName + " " + desc);
        if (fHelper != null) {
            if (desc == NULL_DESCRIPTOR) {
                ArrayList methods = fHelper.getMatchingMethods(className, methodName, fHelper.getAllClassesInVm());
                int i = 0;
                while (i < methods.size()) {
                    Method m = (Method)methods.get(i);
                    try {
                        MethodName mname = MethodName.getMethodName(m, true);
                        FrontEndCandidateAnalyzer.addInitialFrontEndCandidateHelper(className, methodName, mname.getMethodDescriptor().toString());
                    }
                    catch (InvalidMethodDescriptorException e) {
                        Logger.logException(e);
                    }
                    catch (InvalidMethodNameException e) {
                        Logger.logException(e);
                    }
                    ++i;
                }
            } else {
                FrontEndCandidateAnalyzer.addInitialFrontEndCandidateHelper(className, methodName, desc);
            }
        }
    }

    private static void addInitialFrontEndCandidateHelper(String className, String methodName, String desc) {
        Logger.logDebugMessage("Initial Entry Point Candidate from VM: " + className + ":" + methodName + " " + desc);
        InitialFrontEndCandidate fec = new InitialFrontEndCandidate(className, methodName, desc);
        StringBuilder buf = new StringBuilder();
        buf.append(className).append(methodName).append(desc);
        String str = buf.toString();
        int hash = str.hashCode();
        Integer key = hash;
        if (fInitalFrontendMap.putIfAbsent(key, fec) == null) {
            SustainabilityMetricsHelper.reportInitialCandidate();
        }
    }

    public static void shutdown() {
        if (FrontEndCandidateAnalyzer.isActive()) {
            Logger.logDebugMessage("Disabling initial candidate processor");
            sInitialCandidateProcessor.IRegisteredBehavior_setEnableState(false);
            fInitalFrontendMap.clear();
            Logger.logDebugMessage("Disabling monitored candidate processor");
            sMonitoredCandidateProcessor.IRegisteredBehavior_setEnableState(false);
            fCandidatePerformanceMap.clear();
        }
        sReceivedShutdownNotice = true;
    }

    public static int getInitialCandidatesCount() {
        return fInitalFrontendMap.size();
    }

    static int getPerformanceCandidatesCount() {
        return fCandidatePerformanceMap.size();
    }

    public static boolean isActive() {
        return sIsInitialized && sInitialCandidateProcessor.IRegisteredBehavior_isActive() && sMonitoredCandidateProcessor.IRegisteredBehavior_isActive();
    }

    public static void stopTrackingPerformance(String className, String methodName) {
        List metas = fHelper.getMatchingMethodMetadata(className, methodName);
        for (short[] meta : metas) {
            short probeInfoIndex = meta[1];
            FrontendCandidatePerformance x = fCandidatePerformanceMap.remove(probeInfoIndex);
            if (x == null || !Logger.isTraceEnabled()) continue;
            String[] probeEntry = fHelper.getIntelligentInstrumentationInfoForSequentialHashCode(probeInfoIndex);
            Logger.logDebugMessage("Removed Rejected Frontend Candidate: " + probeInfoIndex + " " + probeEntry[0] + ":" + probeEntry[1] + " " + probeEntry[2]);
        }
    }

    public static class InitialEntryPointCandidateProcessor
    implements ITimestampedRunnable {
        public InitialEntryPointCandidateProcessor() {
            this.initializeHelper();
        }

        @Override
        public void ITimestampedRunnable_execute(long nowInMillis) {
            Logger.logTraceMessage("InitialEntryPointCandidateProcessor executing ..");
            SustainabilityMetricsHelper.reportInitialCandidateSustainabilityMetrics();
            ArrayList<String[]> redefineList = new ArrayList<String[]>();
            Iterator itKeys = fInitalFrontendMap.keySet().iterator();
            try {
                while (itKeys.hasNext()) {
                    Integer key = (Integer)itKeys.next();
                    InitialFrontEndCandidate fec = fInitalFrontendMap.get(key);
                    if (fec == null || fHelper == null) continue;
                    if (fHelper.isMethodInstrumented(fec.getClassname(), fec.getMethodname(), fec.getMethodDescriptor())) {
                        short[] meta = fHelper.getMethodMetadata(fec.getClassname(), fec.getMethodname(), fec.getMethodDescriptor());
                        if (meta == null) {
                            Logger.logDebugMessage("Initial Entry Point Candidate method instrumented, but in transient state - " + fec.getClassname() + ":" + fec.getMethodname() + fec.getMethodDescriptor());
                            continue;
                        }
                        short probeInfoIndex = meta[1];
                        Logger.logDebugMessage("Initial Entry Point Candidate: " + probeInfoIndex + " " + fec.getClassname() + ":" + fec.getMethodname() + " " + fec.getMethodDescriptor());
                        fHelper.updateMethodScoreAndState(fec.getClassname(), fec.getMethodname(), fec.getMethodDescriptor(), (short)2000, (short)1);
                        if (FrontendCandidate.FrontEndCandidateState.INSTRUMENTED.toString().equals(fHelper.getMethodState(probeInfoIndex))) {
                            FrontEndCandidateAnalyzer.addFrontendCandidatePerformance(probeInfoIndex);
                            fHelper.markMethodAsFrontendCandidate(probeInfoIndex, FrontendCandidate.FrontEndCandidateState.MONITORED.toString());
                        }
                        fInitalFrontendMap.remove(key);
                        continue;
                    }
                    Logger.logDebugMessage("Initial Entry Point Candidate method not instrumented -" + fec.getClassname() + ":" + fec.getMethodname() + fec.getMethodDescriptor());
                    String[] methodInfo = new String[]{fec.getClassname(), fec.getMethodname(), fec.getMethodDescriptor()};
                    redefineList.add(methodInfo);
                }
                if (redefineList.size() > 0) {
                    Logger.logDebugMessage("Scheduling redefinition of classes with methods not instrumented but marked as Initial Entry Point Candidate(s)");
                    fHelper.scheduleRedefinition(redefineList);
                }
            }
            catch (Exception e) {
                Logger.logException("Exception while processing entry point candidates", e);
            }
            Logger.logDebugMessage("InitialEntryPointCandidateProcessor finished.");
        }

        private void initializeHelper() {
            if (fHelper == null && fAgent != null) {
                try {
                    fHelper = fAgent.IAgent_getTracerAdministrator().getIntelligentInstrumentationService();
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
            }
        }
    }

    public static class MonitoredFrontendCandidateProcessor
    implements ITimestampedRunnable {
        @Override
        public void ITimestampedRunnable_execute(long nowInMillis) {
            try {
                SustainabilityMetricsHelper.reportTrackedCandidateSustainabilityMetrics();
                FrontEndCandidateAnalyzer.sweepDeepStacksForStuckFrontendCandidates();
                FrontEndCandidateAnalyzer.analyzeCompletedTransaction();
            }
            catch (Exception e) {
                Logger.logException("Exception while processing monitored entry point candidates", e);
            }
        }
    }
}

